/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx.ltc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.LocalTransaction.InconsistentLocalTranException;
import com.ibm.ws.LocalTransaction.LocalTranCoordImpl;
import com.ibm.ws.LocalTransaction.RolledbackException;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws390.tx.NativeTransactionContext;
import java.util.Arrays;
import javax.transaction.HeuristicMixedException;
import javax.transaction.RollbackException;

public final class NativeLocalTransactionContext
extends NativeTransactionContext {
    private byte[] _rawTxInfo;
    private byte[] _nativeTxID;
    private static final TraceComponent tc = Tr.register(NativeLocalTransactionContext.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");

    public static final NativeLocalTransactionContext create(LocalTranCoordImpl localTranCoordImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create", localTranCoordImpl);
        }
        NativeLocalTransactionContext nativeLocalTransactionContext = null;
        byte[] byArray = NativeLocalTransactionContext.beginLocal(localTranCoordImpl);
        nativeLocalTransactionContext = new NativeLocalTransactionContext(byArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create", nativeLocalTransactionContext);
        }
        return nativeLocalTransactionContext;
    }

    private static final native byte[] beginLocal(LocalTranCoordImpl var0);

    private NativeLocalTransactionContext(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", byArray);
        }
        this._rawTxInfo = byArray;
        this.setContextToken(Util.duplicateByteArray(byArray, 0, 16));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public byte[] getNativeTranID() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNativeTranID");
        }
        if (this._nativeTxID == null) {
            this._nativeTxID = Util.duplicateByteArray(this._rawTxInfo, 16, this._rawTxInfo.length - 16);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNativeTranID", this._nativeTxID);
        }
        return this._nativeTxID;
    }

    public void commit() throws RolledbackException, InconsistentLocalTranException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit");
        }
        try {
            this.endCurrentUR(null, true);
            NativeLocalTransactionContext.reportTranEnd(true);
        }
        catch (RollbackException rollbackException) {
            throw new RolledbackException(rollbackException.toString(), rollbackException);
        }
        catch (HeuristicMixedException heuristicMixedException) {
            throw new InconsistentLocalTranException(heuristicMixedException.toString(), new String[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit");
        }
    }

    public void rollback() throws InconsistentLocalTranException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rollback");
        }
        try {
            this.endCurrentUR(null, false);
            NativeLocalTransactionContext.reportTranEnd(true);
        }
        catch (RollbackException rollbackException) {
        }
        catch (HeuristicMixedException heuristicMixedException) {
            throw new InconsistentLocalTranException(heuristicMixedException.toString(), new String[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "rollback");
        }
    }

    public int hashCode() {
        return Util.getIntFromBytes(this._rawTxInfo, 0, 4);
    }

    public boolean equals(Object object) {
        if (object instanceof NativeLocalTransactionContext) {
            NativeLocalTransactionContext nativeLocalTransactionContext = (NativeLocalTransactionContext)object;
            return Arrays.equals(this._rawTxInfo, nativeLocalTransactionContext._rawTxInfo);
        }
        return false;
    }

    public boolean isLocal() {
        return true;
    }
}

