/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx.xarecovery;

import com.ibm.ws390.tx.xarecovery.FsTokenHelper;
import com.ibm.ws390.tx.xarecovery.HeuristicException;
import com.ibm.ws390.tx.xarecovery.HeuristicExceptionHelper;
import com.ibm.ws390.tx.xarecovery.LogPropertiesHelper;
import com.ibm.ws390.tx.xarecovery.RecoveryException;
import com.ibm.ws390.tx.xarecovery.RecoveryExceptionHelper;
import com.ibm.ws390.tx.xarecovery.ResourceManagerException;
import com.ibm.ws390.tx.xarecovery.ResourceManagerExceptionHelper;
import com.ibm.ws390.tx.xarecovery.ResourceTokenHelper;
import com.ibm.ws390.tx.xarecovery.StokenHelper;
import com.ibm.ws390.tx.xarecovery.XARecoveryAgent;
import com.ibm.ws390.tx.xarecovery.XID;
import com.ibm.ws390.tx.xarecovery.XIDHelper;
import com.ibm.ws390.tx.xarecovery.XIDListHelper;
import java.util.Hashtable;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.CORBA_2_3.portable.ObjectImpl;

public abstract class _XARecoveryAgentImplBase
extends ObjectImpl
implements XARecoveryAgent,
InvokeHandler {
    private static Hashtable _methods = new Hashtable();
    private static String[] __ids;

    public OutputStream _invoke(String string, InputStream inputStream, ResponseHandler responseHandler) {
        OutputStream outputStream = null;
        Integer n = (Integer)_methods.get(string);
        if (n == null) {
            throw new BAD_OPERATION(0, CompletionStatus.COMPLETED_MAYBE);
        }
        switch (n) {
            case 0: {
                try {
                    XID[] xIDArray = XIDListHelper.read(inputStream);
                    int n2 = inputStream.read_ulong();
                    byte[] byArray = StokenHelper.read(inputStream);
                    this.rollbackUnknownTransactions(xIDArray, n2, byArray);
                    outputStream = responseHandler.createReply();
                }
                catch (RecoveryException recoveryException) {
                    outputStream = responseHandler.createExceptionReply();
                    RecoveryExceptionHelper.write(outputStream, recoveryException);
                }
                break;
            }
            case 1: {
                try {
                    XID xID = XIDHelper.read(inputStream);
                    byte[] byArray = ResourceTokenHelper.read(inputStream);
                    byte[] byArray2 = FsTokenHelper.read(inputStream);
                    byte[] byArray3 = LogPropertiesHelper.read(inputStream);
                    this.commit(xID, byArray, byArray2, byArray3);
                    outputStream = responseHandler.createReply();
                }
                catch (ResourceManagerException resourceManagerException) {
                    outputStream = responseHandler.createExceptionReply();
                    ResourceManagerExceptionHelper.write(outputStream, resourceManagerException);
                }
                catch (RecoveryException recoveryException) {
                    outputStream = responseHandler.createExceptionReply();
                    RecoveryExceptionHelper.write(outputStream, recoveryException);
                }
                catch (HeuristicException heuristicException) {
                    outputStream = responseHandler.createExceptionReply();
                    HeuristicExceptionHelper.write(outputStream, heuristicException);
                }
                break;
            }
            case 2: {
                try {
                    XID xID = XIDHelper.read(inputStream);
                    byte[] byArray = ResourceTokenHelper.read(inputStream);
                    byte[] byArray4 = FsTokenHelper.read(inputStream);
                    byte[] byArray5 = LogPropertiesHelper.read(inputStream);
                    this.rollback(xID, byArray, byArray4, byArray5);
                    outputStream = responseHandler.createReply();
                }
                catch (ResourceManagerException resourceManagerException) {
                    outputStream = responseHandler.createExceptionReply();
                    ResourceManagerExceptionHelper.write(outputStream, resourceManagerException);
                }
                catch (RecoveryException recoveryException) {
                    outputStream = responseHandler.createExceptionReply();
                    RecoveryExceptionHelper.write(outputStream, recoveryException);
                }
                catch (HeuristicException heuristicException) {
                    outputStream = responseHandler.createExceptionReply();
                    HeuristicExceptionHelper.write(outputStream, heuristicException);
                }
                break;
            }
            case 3: {
                try {
                    XID xID = XIDHelper.read(inputStream);
                    byte[] byArray = ResourceTokenHelper.read(inputStream);
                    this.forget(xID, byArray);
                    outputStream = responseHandler.createReply();
                }
                catch (ResourceManagerException resourceManagerException) {
                    outputStream = responseHandler.createExceptionReply();
                    ResourceManagerExceptionHelper.write(outputStream, resourceManagerException);
                }
                catch (RecoveryException recoveryException) {
                    outputStream = responseHandler.createExceptionReply();
                    RecoveryExceptionHelper.write(outputStream, recoveryException);
                }
                break;
            }
            case 4: {
                try {
                    this.rrsRecoveryComplete();
                    outputStream = responseHandler.createReply();
                }
                catch (RecoveryException recoveryException) {
                    outputStream = responseHandler.createExceptionReply();
                    RecoveryExceptionHelper.write(outputStream, recoveryException);
                }
                break;
            }
            default: {
                throw new BAD_OPERATION(0, CompletionStatus.COMPLETED_MAYBE);
            }
        }
        return outputStream;
    }

    public String[] _ids() {
        return __ids;
    }

    static {
        _methods.put("rollbackUnknownTransactions", new Integer(0));
        _methods.put("commit", new Integer(1));
        _methods.put("rollback", new Integer(2));
        _methods.put("forget", new Integer(3));
        _methods.put("rrsRecoveryComplete", new Integer(4));
        __ids = new String[]{"IDL:com.ibm.ws390.tx/xarecovery/XARecoveryAgent:1.0"};
    }
}

