/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.wsba;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.activity.GlobalIdImpl;
import com.ibm.ws.cscope.CScopePGMgr;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.wscoor.CoordinationContext;
import com.ibm.ws390.wscoor.WSCoorSoapRequestMonitor;
import com.ibm.wsspi.soapchannel.monitor.SOAPRequestController;
import com.ibm.wsspi.soapchannel.monitor.SOAPRequestMonitor;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;

public class WSBASOAPRequestMonitor
implements SOAPRequestMonitor {
    private static final TraceComponent tc = Tr.register(WSBASOAPRequestMonitor.class, "CScope", "com.ibm.ws.cscope.resources.CScopeMessages");

    public WSBASOAPRequestMonitor() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "WSBASOAPRequestMonitor");
        }
    }

    public String getName() {
        return "WSBASOAPRequestMonitor";
    }

    public int getWeight() {
        return 33;
    }

    public void handleRequest(MessageContext messageContext, SOAPRequestController sOAPRequestController) {
        SOAPHeader sOAPHeader;
        block8: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "handleRequest", new Object[]{messageContext, sOAPRequestController, this});
            }
            sOAPHeader = null;
            SOAPMessage sOAPMessage = messageContext.getMessage();
            try {
                sOAPHeader = sOAPMessage.getSOAPHeader();
            }
            catch (SOAPException sOAPException) {
                FFDCFilter.processException(sOAPException, "com.ibm.ws390.wsba.WSBASOAPRequestMonitor.handleRequest", "74");
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "handleRequest caught exception getting soap header", (Object)sOAPException);
            }
        }
        if (sOAPHeader != null) {
            CoordinationContext coordinationContext;
            block9: {
                coordinationContext = null;
                try {
                    coordinationContext = CoordinationContext.extractFromSOAPHeader(sOAPHeader, CScopePGMgr.COORDINATION_TYPE.toString());
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ws390.wsba.WSBASOAPRequestMonitor.handleRequest", "90");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block9;
                    Tr.debug(tc, "handleRequest caught exception getting WSBA context", exception);
                }
            }
            byte[] byArray = null;
            if (coordinationContext != null) {
                String string = coordinationContext.getIdentifier().getURI().toString();
                byte[] byArray2 = new GlobalIdImpl(string).toBytes();
                byArray = new byte[byArray2.length + 12];
                System.arraycopy(WSBASOAPRequestMonitor.intToBytes(0), 0, byArray, 0, 4);
                System.arraycopy(WSBASOAPRequestMonitor.intToBytes(1), 0, byArray, 4, 4);
                System.arraycopy(WSBASOAPRequestMonitor.intToBytes(byArray2.length), 0, byArray, 8, 4);
                System.arraycopy(byArray2, 0, byArray, 12, byArray2.length);
            }
            WSCoorSoapRequestMonitor.handleRequest(messageContext, sOAPRequestController, byArray);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "handleRequest");
        }
    }

    public static byte[] intToBytes(int n) {
        return new byte[]{(byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n};
    }
}

