/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.cache;

import com.ibm.ws.cache.intf.DCache;
import com.ibm.wsspi.cache.CacheEntry;
import com.ibm.wsspi.cache.CacheStatisticsListener;
import java.util.Collection;
import java.util.Enumeration;

public class Cache {
    private DCache cacheInstance = null;

    public Cache(DCache dCache) {
        this.cacheInstance = dCache;
    }

    public void refreshEntry(CacheEntry cacheEntry) {
        this.cacheInstance.refreshEntry(cacheEntry.cacheEntry);
    }

    public boolean getSwapToDisk() {
        return this.cacheInstance.getSwapToDisk();
    }

    public CacheEntry getEntryDisk(Object object) {
        return new CacheEntry(this.cacheInstance.getEntryDisk(object));
    }

    public void clearDisk() {
        this.cacheInstance.clearDisk();
    }

    public Collection getIdsByRangeDisk(int n, int n2) {
        return this.cacheInstance.getIdsByRangeDisk(n, n2);
    }

    public Collection getTemplatesByRangeDisk(int n, int n2) {
        return this.cacheInstance.getTemplatesByRangeDisk(n, n2);
    }

    public CacheStatisticsListener getCacheStatisticsListener() {
        return new CacheStatisticsListener(this.cacheInstance.getCacheStatisticsListener());
    }

    public CacheEntry getEntry(Object object) {
        return new CacheEntry(this.cacheInstance.getEntry(object));
    }

    public void invalidateById(String string, boolean bl) {
        this.cacheInstance.invalidateById(string, bl);
    }

    public void invalidateByTemplate(String string, boolean bl) {
        this.cacheInstance.invalidateByTemplate(string, bl);
    }

    public void clear() {
        this.cacheInstance.clear();
    }

    public Enumeration getAllIds() {
        return this.cacheInstance.getAllIds();
    }

    public int getMaxNumberCacheEntries() {
        return this.cacheInstance.getMaxNumberCacheEntries();
    }

    public int getNumberCacheEntries() {
        return this.cacheInstance.getNumberCacheEntries();
    }

    public int getDefaultPriority() {
        return this.cacheInstance.getDefaultPriority();
    }

    public Collection getAllDependencyIds() {
        return this.cacheInstance.getAllDependencyIds();
    }

    public Collection getCacheIdsByDependency(String string) {
        return this.cacheInstance.getCacheIdsByDependency(string);
    }

    public Collection getCacheIdsByTemplate(String string) {
        return this.cacheInstance.getCacheIdsByTemplate(string);
    }

    public int getTemplatesSizeDisk() {
        return this.cacheInstance.getTemplatesSizeDisk();
    }

    public Collection getTemplateValueDisk(String string) {
        return this.cacheInstance.getCacheIdsByTemplateDisk(string);
    }

    public int getIdsSizeDisk() {
        return this.cacheInstance.getIdsSizeDisk();
    }

    public int getDepIdsSizeDisk() {
        return this.cacheInstance.getDepIdsSizeDisk();
    }

    public Collection getDepIdsByRangeDisk(int n, int n2) {
        return this.cacheInstance.getDepIdsByRangeDisk(n, n2);
    }

    public Collection getDepIdValueDisk(Object object) {
        return this.cacheInstance.getCacheIdsByDependencyDisk(object);
    }

    public long getDiskCacheSizeLimit() {
        return this.cacheInstance.getCacheConfig().getDiskCacheSize();
    }

    public long getDiskCacheSizeInGBLimit() {
        return this.cacheInstance.getCacheConfig().getDiskCacheSizeInGB();
    }

    public long getDiskCacheEntrySizeInMBLimit() {
        return this.cacheInstance.getCacheConfig().getDiskCacheEntrySizeInMB();
    }

    public boolean getFlushToDiskOnStop() {
        return this.cacheInstance.getCacheConfig().isFlushToDiskOnStop();
    }

    public int getDiskCachePerformanceLevel() {
        return this.cacheInstance.getCacheConfig().getDiskCachePerformanceLevel();
    }

    public long getCleanupFrequency() {
        return this.cacheInstance.getCacheConfig().getCleanupFrequency();
    }

    public boolean getDelayOffload() {
        return this.cacheInstance.getCacheConfig().isDelayOffload();
    }

    public long getDelayOffloadEntriesLimit() {
        return this.cacheInstance.getCacheConfig().getDelayOffloadEntriesLimit();
    }

    public long getDelayOffloadDepIdBuckets() {
        return this.cacheInstance.getCacheConfig().getDelayOffloadDepIdBuckets();
    }

    public long getDelayOffloadTemplateBuckets() {
        return this.cacheInstance.getCacheConfig().getDelayOffloadTemplateBuckets();
    }

    public int getDiskCacheEvictionPolicy() {
        return this.cacheInstance.getCacheConfig().getDiskCacheEvictionPolicy();
    }

    public int getDiskCacheHighThreshold() {
        return this.cacheInstance.getCacheConfig().getDiskCacheHighThreshold();
    }

    public int getDiskCacheLowThreshold() {
        return this.cacheInstance.getCacheConfig().getDiskCacheLowThreshold();
    }

    public float getDiskCacheSizeInMBs() {
        return this.cacheInstance.getDiskCacheSizeInMBs();
    }
}

