/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.cluster.selection.rule;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.KeyRepository;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.ws.cluster.topography.SelectionClusterMemberDescription;
import com.ibm.wsspi.cluster.selection.rule.DefaultRule;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AttributeRule
extends DefaultRule {
    private static final TraceComponent tc = Tr.register(AttributeRule.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final KeyRepository keyRepository = KeyRepositoryFactory.getInstance().getKeyRepository();
    private static final Map scmdDistinction = new HashMap(1);
    private Map selectionDescriptions = new HashMap();
    private final Set attributes;

    public AttributeRule(Set set) {
        this.attributes = set;
    }

    public void subset(List list, StringBuffer stringBuffer) {
        if (this.attributes != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object object;
                DescriptionKey descriptionKey = (DescriptionKey)iterator.next();
                this.registerNotificationType(descriptionKey, "type.add.extrinsic");
                this.registerNotificationType(descriptionKey, "type.remove.extrinsic");
                SelectionClusterMemberDescription selectionClusterMemberDescription = (SelectionClusterMemberDescription)this.selectionDescriptions.get(descriptionKey);
                if (selectionClusterMemberDescription == null) {
                    object = keyRepository.getDescriptionKey(descriptionKey, scmdDistinction);
                    selectionClusterMemberDescription = (SelectionClusterMemberDescription)descMgr.getDescription((DescriptionKey)object);
                    this.selectionDescriptions.put(descriptionKey, selectionClusterMemberDescription);
                }
                if (selectionClusterMemberDescription == null) {
                    iterator.remove();
                    stringBuffer.append(descriptionKey);
                    stringBuffer.append(" removed: Lack of attribute container. ");
                    continue;
                }
                this.registerNotificationType(selectionClusterMemberDescription.getKey(), "type.attribute.added");
                this.registerNotificationType(selectionClusterMemberDescription.getKey(), "type.attribute.removed");
                object = ((SelectionClusterMemberDescription.Memento)selectionClusterMemberDescription.getMemento()).getAttributes();
                if (object.containsAll(this.attributes)) continue;
                iterator.remove();
                stringBuffer.append(descriptionKey);
                stringBuffer.append(" removed: Lack of matching attributes ");
                stringBuffer.append(object);
                stringBuffer.append(' ');
            }
        }
    }

    public String toString() {
        return super.toString() + this.attributes;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AttributeRule)) {
            return false;
        }
        return ((Object)this.attributes).equals(((AttributeRule)object).attributes);
    }

    public int hashCode() {
        return ((Object)this.attributes).hashCode();
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.8");
        }
        scmdDistinction.put(SelectionClusterMemberDescription.distinction[0], SelectionClusterMemberDescription.distinction[1]);
    }
}

