/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.configarchive;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.configarchive.FileAccessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DefaultFileAccessor
extends FileAccessor {
    private File rootDir;
    private static TraceComponent tc = Tr.register(DefaultFileAccessor.class, "DefaultFileAccessor", "com.ibm.ws.management.resources.bundle");
    private static final String DFA_FILE_NOT_FOUND = "The system cannot find the specified file, either the filename is too long on Windows system or run out of file descriptor on UNIX platform. ";
    private static final int MAXBYTES = 2048;

    public DefaultFileAccessor(File file) {
        this.rootDir = file;
    }

    public File getRootDir() {
        return this.rootDir;
    }

    public void create(String string, InputStream inputStream) throws IOException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create (" + string + " " + inputStream + ")");
        }
        String string2 = this.rootDir.getPath() + File.separator + string;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Creating file " + string2);
        }
        File file = new File(string2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Creating parent dirs " + string2);
        }
        File file2 = file.getParentFile();
        file2.mkdirs();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Writing to file " + string2);
        }
        byte[] byArray = new byte[2048];
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (IOException iOException) {
            throw new IOException(DFA_FILE_NOT_FOUND + iOException);
        }
        while ((n = inputStream.read(byArray, 0, 2048)) != -1) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileOutputStream.flush();
        fileOutputStream.close();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create");
        }
    }

    public void delete(String string) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "delete (" + string + ")");
        }
        String string2 = this.rootDir.getPath() + File.separator + string;
        File file = new File(string2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "deleting file " + string2);
        }
        if (file.exists() && !file.delete()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "delete failed " + string2);
            }
            file.deleteOnExit();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "delete");
        }
    }

    public InputStream load(String string) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "load (" + string + ")");
        }
        String string2 = this.rootDir.getPath() + File.separator + string;
        FileInputStream fileInputStream = null;
        File file = new File(string2);
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (IOException iOException) {
            throw new IOException(DFA_FILE_NOT_FOUND + iOException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "load");
        }
        return fileInputStream;
    }

    public void save(String string, InputStream inputStream) throws IOException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "save (" + string + " " + inputStream + ")");
        }
        String string2 = this.rootDir.getPath() + File.separator + string;
        File file = new File(string2);
        file.getParentFile().mkdirs();
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (IOException iOException) {
            throw new IOException(DFA_FILE_NOT_FOUND + iOException);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Writing to file " + string2);
        }
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray, 0, 2048)) != -1) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileOutputStream.flush();
        fileOutputStream.close();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "save");
        }
    }

    public List listFolders(String string) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listFolders (" + string + ")");
        }
        List<String> list = new ArrayList();
        String string2 = this.rootDir.getPath() + File.separator + string;
        File file = new File(string2);
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isDirectory()) continue;
                list.add(fileArray[i].getPath());
            }
        }
        list = this.adjustPaths(list);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listFolders");
        }
        return list;
    }

    public List listFiles(String string) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listFiles (" + string + ")");
        }
        List<String> list = new ArrayList();
        String string2 = this.rootDir.getPath() + "/" + string;
        File file = new File(string2);
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) continue;
                list.add(fileArray[i].getPath());
            }
        }
        list = this.adjustPaths(list);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listFiles");
        }
        return list;
    }

    public boolean exists(String string) throws IOException {
        File file;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exists (" + string + ")");
        }
        String string2 = this.rootDir.getPath() + File.separator + string;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "exists (" + string2 + ")");
        }
        if ((file = new File(string2)).exists()) {
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exists false");
        }
        return false;
    }

    public OutputStream getOutputStream(String string) throws IOException {
        String string2;
        File file;
        File file2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOutputStream (" + string + ")");
        }
        if (!(file2 = (file = new File(string2 = this.rootDir.getPath() + File.separator + string)).getParentFile()).exists()) {
            file2.mkdirs();
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (IOException iOException) {
            throw new IOException(DFA_FILE_NOT_FOUND + iOException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOutputStream");
        }
        return fileOutputStream;
    }

    public void makeDir(String string) throws IOException {
        String string2;
        File file;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "makeDir (" + string + ")");
        }
        if (!(file = new File(string2 = this.rootDir.getPath() + File.separator + string)).exists()) {
            file.mkdirs();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "makeDir");
        }
    }

    private List adjustPaths(List list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            string = string.substring(this.rootDir.getPath().length() + 1);
            arrayList.add(string);
        }
        return arrayList;
    }

    public void createNewFile(String string) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createNewFile (" + string + ")");
        }
        String string2 = this.rootDir.getPath() + File.separator + string;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createNewFile (" + string2 + ")");
        }
        File file = new File(string2);
        File file2 = file.getParentFile();
        file2.mkdirs();
        file.createNewFile();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createNewFile");
        }
    }

    public void deleteRootDir() {
        String string = this.rootDir.getPath();
        String string2 = string.substring(0, string.lastIndexOf(File.separatorChar));
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "deleteRootDir (" + string2 + ")");
        }
        File file = new File(string2);
        file.delete();
    }

    public long getLength(String string) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLength (" + string + ")");
        }
        String string2 = this.rootDir.getPath() + File.separator + string;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getLength (" + string2 + ")");
        }
        File file = new File(string2);
        long l = file.length();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLength " + l);
        }
        return l;
    }

    public String getFullPath(String string) {
        return this.rootDir.getPath() + File.separator + string;
    }
}

