/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.configarchive;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.configarchive.ConfigArchiveCommand;
import com.ibm.wsspi.configarchive.ConfigArchiveException;
import com.ibm.wsspi.configarchive.FileAccessor;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class ExportCommand
extends ConfigArchiveCommand {
    private static TraceComponent tc = Tr.register(ExportCommand.class, "configarchive", "com.ibm.ws.management.resources.configarchive");

    public ExportCommand(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public ExportCommand(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    private void createArchiveSession() throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createArchiveWorkspace");
        }
        try {
            File file = this.getArchiveLocation();
            Method method2 = this.composerCls.getMethod("createConfigArchiveSession", String.class, FileAccessor.class);
            Session session = (Session)method2.invoke(null, file.getName(), null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "archiveSession", session);
            }
            this.setConfigArchiveSession(session);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createArchiveSession");
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof ConfigArchiveException) {
                FFDCFilter.processException(invocationTargetException, "com.ibm.wsspi.configarchive.ExportCommand.createArchiveSession", "88");
                throw (ConfigArchiveException)throwable;
            }
            FFDCFilter.processException(invocationTargetException, "com.ibm.wsspi.configarchive.ExportCommand.createArchiveSession", "91");
            throw new ConfigArchiveException(throwable, "unexpected exception");
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.wsspi.configarchive.ExportCommand.createArchiveSession", "95");
            throw new ConfigArchiveException(throwable, "unexpected exception");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        try {
            this.createArchiveSession();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.wsspi.configarchive.ExportCommand.beforeStepsExecuted", "99");
            taskCommandResultImpl.setException(new ConfigArchiveException(throwable, "exportCommand command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        try {
            if (taskCommandResultImpl.isSuccessful()) {
                Session session = this.getConfigArchiveSession();
                Method method2 = this.composerCls.getMethod("saveConfigArchive", String.class, File.class);
                method2.invoke(null, session.toString(), this.getArchiveLocation());
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            if (throwable instanceof InvocationTargetException) {
                throwable2 = ((InvocationTargetException)throwable).getTargetException();
            }
            FFDCFilter.processException(throwable2, "com.ibm.wsspi.configarchive.ExportCommand.afterStepsExecuted", "99");
            taskCommandResultImpl.setException(new ConfigArchiveException(throwable2, this.getName() + " command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

