/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.handlerfw;

public class JavabeanParam {
    private String name;
    private Class type;
    private String valueStr;
    private Object value;

    public JavabeanParam(String string, Class clazz, String string2) throws IllegalArgumentException, NumberFormatException {
        this.name = string;
        this.type = clazz;
        this.valueStr = string2;
        this.value = this.validate(string, clazz, this.valueStr);
    }

    public Object validate(String string, Class clazz, String string2) throws IllegalArgumentException, NumberFormatException {
        Object object = null;
        if (string == null || clazz == null || string2 == null) {
            throw new IllegalArgumentException("Invalid Params: name=" + string + ",type=" + clazz + ",value=" + string2);
        }
        if (clazz == String.class) {
            object = string2;
        } else if (clazz == Integer.class || clazz == Integer.TYPE) {
            this.type = Integer.TYPE;
            object = new Integer(string2);
        } else if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            this.type = Boolean.TYPE;
            object = new Boolean(string2);
        } else if (clazz == Double.class || clazz == Double.TYPE) {
            this.type = Double.TYPE;
            object = new Double(string2);
        } else if (clazz == Byte.class || clazz == Byte.TYPE) {
            this.type = Byte.TYPE;
            object = new Byte(string2);
        } else if (clazz == Short.class || clazz == Short.TYPE) {
            this.type = Short.TYPE;
            object = new Short(string2);
        } else if (clazz == Long.class || clazz == Long.TYPE) {
            this.type = Long.TYPE;
            object = new Long(string2);
        } else if (clazz == Float.class || clazz == Float.TYPE) {
            this.type = Float.TYPE;
            object = new Float(string2);
        } else if (clazz == Character.class || clazz == Character.TYPE) {
            if (string2.length() != 1) {
                throw new IllegalArgumentException("Illegal Char type value: " + string2);
            }
            this.type = Character.TYPE;
            object = new Character(string2.charAt(0));
        } else {
            throw new IllegalArgumentException("Invalid Primitive Java class type: " + clazz);
        }
        return object;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public Class getType() {
        return this.type;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (object instanceof JavabeanParam) {
            JavabeanParam javabeanParam = (JavabeanParam)object;
            if (!this.name.equals(javabeanParam.getName())) {
                return false;
            }
            if (!this.type.equals(javabeanParam.getType())) {
                return false;
            }
            if (!this.value.equals(javabeanParam.getValue())) {
                return false;
            }
        }
        return bl;
    }

    public String toString() {
        String string = "(name=" + this.name + ",type=" + this.type + ",value=" + this.value;
        return string;
    }
}

