/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.jms;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;

public class JmsMessageListenerSupport {
    private static final Map _messageListenerSetters;
    private static final TraceNLS _nls;
    private static final TraceComponent tc;

    public static void setMessageListener(MessageConsumer messageConsumer, MessageListener messageListener) throws JMSException {
        MessageListenerSetter messageListenerSetter;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMessageListener", new Object[]{messageConsumer, messageListener});
        }
        if ((messageListenerSetter = (MessageListenerSetter)_messageListenerSetters.get(messageConsumer.getClass().getName())) == null) {
            String string = _nls.getFormattedMessage("UNKNOWN_SESSION_TYPE_WMSG0500E", new Object[]{messageConsumer.getClass().getName()}, null);
            JMSException jMSException = new JMSException(string);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setMessageListener", (Object)jMSException);
            }
            throw jMSException;
        }
        messageListenerSetter.setMessageListener(messageConsumer, messageListener);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMessageListener");
        }
    }

    static {
        tc = Tr.register(JmsMessageListenerSupport.class, "Messaging", "com.ibm.ejs.jms.messaging");
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<clinit>");
        }
        _nls = TraceNLS.getTraceNLS("com.ibm.ejs.jms.messaging");
        _messageListenerSetters = new HashMap();
        IExtensionRegistry iExtensionRegistry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        String string = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".jmsMessageListenerSetters";
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "processing " + iConfigurationElementArray.length + " message listener setters");
        }
        for (int i = 0; i < iConfigurationElementArray.length; ++i) {
            try {
                String string2 = iConfigurationElementArray[i].getAttribute("type");
                Object object = iConfigurationElementArray[i].createExecutableExtension("setter");
                _messageListenerSetters.put(string2, object);
                continue;
            }
            catch (CoreException coreException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception loading class", (Object)coreException);
                }
                FFDCFilter.processException(coreException, "com.ibm.ejs.jms.JmsMessageListenerSupport.<clinit>", "85");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<clinit>");
        }
    }

    public static interface MessageListenerSetter {
        public void setMessageListener(MessageConsumer var1, MessageListener var2) throws JMSException;
    }
}

