/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.commands.ports;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.wsspi.management.commands.ports.ClusterCollection;
import com.ibm.wsspi.management.commands.ports.PortsCommandProvider;
import com.ibm.wsspi.management.commands.ports.PortsCommandUtil;
import com.ibm.wsspi.management.commands.ports.ServerCollection;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class ApplicationPorts {
    private static TraceComponent tc = Tr.register(ApplicationPorts.class, PortsCommandProvider.PORTS_COMMAND_TRACEGROUP, PortsCommandProvider.PORTS_COMMAND_PACKAGE);
    private ServerCollection _serverCollection;
    private ClusterCollection _clusterCollection;
    private String _appName;
    private ObjectName _deploymentON;
    private ConfigService _service;
    private Session _session;
    private ModuleTargetNames _webModuleTargetNames;
    private ModuleTargetNames _ejbModuleTargetNames;
    private ModuleTargetNames _sipModuleTargetNames;
    private DocumentBuilder _documentBuilder;
    private ConfigService _configService;
    private ArrayList _appPorts;

    protected ApplicationPorts(ConfigService configService, Session session, String string, ObjectName objectName) throws CommandException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CWPMC ApplicationPorts(" + string + ")");
        }
        this._service = configService;
        this._session = session;
        this._appName = string;
        this._deploymentON = objectName;
        this._serverCollection = new ServerCollection(configService, session);
        this._clusterCollection = new ClusterCollection(configService, session, this._serverCollection);
        this._webModuleTargetNames = null;
        this._ejbModuleTargetNames = null;
        this._sipModuleTargetNames = null;
        this._appPorts = null;
        if (this.findModuleTargetNames()) {
            this._appPorts = this.getApplicationPorts();
        }
    }

    protected ArrayList getPorts() {
        if (this._appPorts == null) {
            this._appPorts = new ArrayList();
        }
        return this._appPorts;
    }

    private boolean findModuleTargetNames() throws CommandException {
        boolean bl;
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "CWPMC ApplicationPorts.findModuleTargetNames(" + this._appName + ")");
            }
            bl = false;
            this._webModuleTargetNames = new ModuleTargetNames();
            this._ejbModuleTargetNames = new ModuleTargetNames();
            this._sipModuleTargetNames = new ModuleTargetNames();
            ObjectName objectName = (ObjectName)PortsCommandUtil.getAttribute(this._service, this._session, this._deploymentON, PortsCommandUtil.DEPLOYEDOBJECT_ATTR_TYPE);
            List list = (List)PortsCommandUtil.getAttribute(this._service, this._session, objectName, PortsCommandUtil.MODULES_ATTR_TYPE);
            Iterator iterator = list.iterator();
            String string = System.getProperty("was.repository.root") + File.separator;
            String string2 = File.separator + PortsCommandUtil.WEB_DD_LOCATION + File.separator + PortsCommandUtil.SIP_CONFIG_FILE;
            String string3 = File.separator + PortsCommandUtil.WEB_DD_LOCATION + File.separator + PortsCommandUtil.WEB_CONFIG_FILE;
            try {
                while (iterator.hasNext()) {
                    ObjectName objectName2 = (ObjectName)iterator.next();
                    String string4 = ConfigServiceHelper.getConfigDataType(objectName2);
                    String string5 = ConfigServiceHelper.getDisplayName(objectName2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "moduleName (displayName)=" + string5);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "CWPMC ApplicationPorts.findModuleTargetNames - moduleON found,  dataType = " + string4, objectName2);
                    }
                    if (string4.equals(PortsCommandUtil.WEBMODULEDEPLOYMENT_OBJECT_TYPE)) {
                        String string6 = this.getModulePath(objectName2, string);
                        File file = new File(string6);
                        if (!file.exists()) {
                            if (!tc.isErrorEnabled()) continue;
                            Tr.error(tc, "CWPMC getApplicationPorts - invalid module path: " + string6);
                            continue;
                        }
                        File file2 = new File(string6 + string2);
                        boolean bl2 = file2.exists();
                        this.processWebDeploymentTargets(bl2, objectName2, file + string3, file2);
                        bl = true;
                        continue;
                    }
                    if (!string4.equals(PortsCommandUtil.EJBMODULEDEPLOYMENT_OBJECT_TYPE)) continue;
                    this.addTarget(this._ejbModuleTargetNames, objectName2);
                    bl = true;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.wsspi.management.commands.ports.ApplicationPorts.findModuleTargetNames", (String)"1", (Object)this);
                if (!tc.isErrorEnabled()) break block9;
                Tr.error(tc, "An error occurred during the attempt to get the ports for the appliction: " + exception.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CWPMC ApplicationPorts.findModuleTargetNames(" + this._appName + ")");
        }
        return bl;
    }

    private ArrayList getApplicationPorts() throws CommandException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CWPMC ApplicationPorts.getApplicationPorts(" + this._appName + ")");
        }
        ArrayList<ArrayList> arrayList = new ArrayList<ArrayList>();
        List list = (List)PortsCommandUtil.getAttribute(this._service, this._session, this._deploymentON, PortsCommandUtil.DEPLOYMENTTARGETS_ATTR_TYPE);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object;
            ObjectName objectName = (ObjectName)iterator.next();
            String string = ConfigServiceHelper.getConfigDataType(objectName);
            String string2 = (String)PortsCommandUtil.getAttribute(this._service, this._session, objectName, "name");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CWPMC ApplicationPorts.getApplicationPorts - targetON found, targetType = " + string + ", targetName = " + string2, objectName);
            }
            boolean bl = false;
            ArrayList<String> arrayList2 = new ArrayList<String>();
            if (this._webModuleTargetNames.contains(string2)) {
                arrayList2.add(PortsCommandUtil.WEBCONTAINER_PORTS);
                bl = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "CWPMC ApplicationPorts.getApplicationPorts - WebModule target " + string2 + " ports needed");
                }
            }
            if (this._ejbModuleTargetNames.contains(string2)) {
                arrayList2.add(PortsCommandUtil.ORB_PORTS);
                bl = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "CWPMC ApplicationPorts.getApplicationPorts - EjbModule target " + string2 + " ports needed");
                }
            }
            if (this._sipModuleTargetNames.contains(string2)) {
                arrayList2.add(PortsCommandUtil.SIP_PORTS);
                bl = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "CWPMC ApplicationPorts.getApplicationPorts - SipModule target " + string2 + " ports needed");
                }
            }
            if (!bl) continue;
            if (string.equals(PortsCommandUtil.CLUSTEREDTARGET_OBJECT_TYPE)) {
                object = this._clusterCollection.getCluster(string2);
                if (object != null) {
                    arrayList.addAll(((ClusterCollection.Cluster)object).getPorts(arrayList2));
                    continue;
                }
                Tr.error(tc, "CWPMC getApplicationPorts - Cluster " + string2 + " not found");
                continue;
            }
            if (!string.equals(PortsCommandUtil.SERVERTARGET_OBJECT_TYPE)) continue;
            object = (String)PortsCommandUtil.getAttribute(this._service, this._session, objectName, PortsCommandUtil.NODENAME_ATTR_TYPE);
            String string3 = (String)PortsCommandUtil.getAttribute(this._service, this._session, objectName, PortsCommandUtil.NAME_ATTR_TYPE);
            arrayList.add(this._serverCollection.getPorts((String)object, string3, arrayList2));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CWPMC ApplicationPorts.getApplicationPorts(" + this._appName + ")");
        }
        return arrayList;
    }

    private void processWebDeploymentTargets(boolean bl, ObjectName objectName, String string, File file) throws IOException, SAXException, ParserConfigurationException, CommandException {
        if (tc.isDebugEnabled()) {
            if (bl) {
                Tr.debug(tc, "SIP ports will be included in the list of application ports");
            } else {
                Tr.debug(tc, "SIP ports will be filtered from the list of application ports.");
            }
        }
        if (bl) {
            Document document = this.createDocument(string);
            Set set = this.getServletNames(document);
            Set set2 = this.getServletNames(this.createDocument(file));
            this.addTarget(this._sipModuleTargetNames, objectName);
            if (((Object)set2).equals(set)) {
                if (this.containsElement(document, PortsCommandUtil.WELCOME_FILE_ELEMENT_NAME) || this.containsElement(document, PortsCommandUtil.ERROR_PAGE_FILE_ELEMENT_NAME)) {
                    this.addTarget(this._webModuleTargetNames, objectName);
                }
            } else {
                this.addTarget(this._webModuleTargetNames, objectName);
                this.addTarget(this._sipModuleTargetNames, objectName);
            }
        } else {
            this.addTarget(this._webModuleTargetNames, objectName);
        }
    }

    private String getModulePath(ObjectName objectName, String string) throws ConnectorException, ConfigServiceException {
        if (this._configService == null) {
            this.initializeConfigService();
        }
        String string2 = (String)this._configService.getAttribute(this._session, objectName, PortsCommandUtil.URI_ATTR_TYPE);
        String string3 = ConfigServiceHelper.getConfigDataId(objectName).getContextUri();
        return string + string3 + File.separator + string2;
    }

    private void addTarget(ModuleTargetNames moduleTargetNames, ObjectName objectName) throws CommandException {
        if (moduleTargetNames == this._webModuleTargetNames) {
            this._webModuleTargetNames.addTargets(objectName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CWPMC ApplicationPorts.findModuleTargetNames - moduleON added to list of WebModule targets", objectName);
            }
        } else if (moduleTargetNames == this._sipModuleTargetNames) {
            this._sipModuleTargetNames.addTargets(objectName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CWPMC ApplicationPorts.findModuleTargetNames - moduleON added to list of SipModule targets", objectName);
            }
        } else if (moduleTargetNames == this._ejbModuleTargetNames) {
            this._ejbModuleTargetNames.addTargets(objectName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CWPMC ApplicationPorts.findModuleTargetNames - moduleON added to list of EjbModule targets", objectName);
            }
        }
    }

    private Document createDocument(File file) throws IOException, ParserConfigurationException, SAXException {
        return this.createDocument(new FileInputStream(file));
    }

    private Document createDocument(String string) throws IOException, ParserConfigurationException, SAXException {
        return this.createDocument(new FileInputStream(string));
    }

    private Document createDocument(InputStream inputStream) throws IOException, ParserConfigurationException, SAXException {
        if (this._documentBuilder == null) {
            this.initializeDocumentBuilder();
        }
        return this._documentBuilder.parse(inputStream);
    }

    private void initializeDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this._documentBuilder = documentBuilderFactory.newDocumentBuilder();
    }

    private void initializeConfigService() {
        this._configService = ConfigServiceFactory.getConfigService();
    }

    private Set getServletNames(Document document) {
        HashSet<String> hashSet = new HashSet<String>();
        NodeList nodeList = document.getElementsByTagName(PortsCommandUtil.SERVLET_ELEMENT_NAME);
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            String string;
            Element element = (Element)nodeList.item(i);
            Element element2 = (Element)element.getElementsByTagName(PortsCommandUtil.SERVLET_NAME_ELEMENT_NAME).item(0);
            if (element2 == null || (string = element2.getFirstChild().getNodeValue()) == null || string.length() <= 0) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    private boolean containsElement(Document document, String string) {
        NodeList nodeList = document.getElementsByTagName(string);
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            String string2 = node.getFirstChild().getNodeValue();
            if (string2 == null || string2.length() <= 0) continue;
            return true;
        }
        return false;
    }

    class ModuleTargetNames {
        private ArrayList _targetNames = new ArrayList();

        private boolean contains(String string) {
            return this._targetNames.contains(string);
        }

        private ArrayList addTargets(ObjectName objectName) throws CommandException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "CWPMC ApplicationPorts.addTargets", objectName);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            List list = (List)PortsCommandUtil.getAttribute(ApplicationPorts.this._service, ApplicationPorts.this._session, objectName, PortsCommandUtil.TARGETMAPPINGS_ATTR_TYPE);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ObjectName objectName2 = (ObjectName)iterator.next();
                ObjectName objectName3 = (ObjectName)PortsCommandUtil.getAttribute(ApplicationPorts.this._service, ApplicationPorts.this._session, objectName2, PortsCommandUtil.TARGET_ATTR_TYPE);
                String string = ConfigServiceHelper.getDisplayName(objectName3);
                this._targetNames.add(string);
                arrayList.add(string);
            }
            return arrayList;
        }
    }
}

