/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.commands.ports;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.wsspi.management.commands.ports.PortsCommandProvider;
import com.ibm.wsspi.management.commands.ports.PortsCommandUtil;
import com.ibm.wsspi.management.commands.ports.Server;
import com.ibm.wsspi.management.commands.ports.ServerCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.management.ObjectName;

class ClusterCollection {
    private static TraceComponent tc = Tr.register(ClusterCollection.class, PortsCommandProvider.PORTS_COMMAND_TRACEGROUP, PortsCommandProvider.PORTS_COMMAND_PACKAGE);
    private ConfigService _service;
    private Properties _clusters = new Properties();
    private ServerCollection _serverCollection;
    private Session _session;
    private boolean _retrievedClusterCollection = false;

    public ClusterCollection(ConfigService configService, Session session, ServerCollection serverCollection) {
        this._serverCollection = serverCollection;
        this._session = session;
        this._service = configService;
    }

    protected Cluster getCluster(String string) throws CommandException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CWPMC ClusterCollection.getCluster(" + string + ")");
        }
        if (!this._retrievedClusterCollection) {
            this.retrieveClusterCollection();
            this._retrievedClusterCollection = true;
        }
        return (Cluster)this._clusters.get(string);
    }

    private void retrieveClusterCollection() throws CommandException {
        ArrayList arrayList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CWPMC ClusterCollection.retrieveClusterCollection");
        }
        if ((arrayList = PortsCommandUtil.getObjects(this._service, this._session, PortsCommandUtil.SERVERCLUSTER_OBJECT_TYPE)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CWPMC ClusterCollection.retrieveClusterCollection", "No ServerClusters found");
            }
            return;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName = (ObjectName)iterator.next();
            String string = (String)PortsCommandUtil.getAttribute(this._service, this._session, objectName, PortsCommandUtil.NAME_ATTR_TYPE);
            Cluster cluster = this.addCluster(string);
            List list = (List)PortsCommandUtil.getAttribute(this._service, this._session, objectName, PortsCommandUtil.MEMBERS_ATTR_TYPE);
            if (list == null) continue;
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                ObjectName objectName2 = (ObjectName)iterator2.next();
                String string2 = (String)PortsCommandUtil.getAttribute(this._service, this._session, objectName2, PortsCommandUtil.NODENAME_ATTR_TYPE);
                String string3 = (String)PortsCommandUtil.getAttribute(this._service, this._session, objectName2, PortsCommandUtil.MEMBERNAME_ATTR_TYPE);
                cluster.addServer(string2, string3);
            }
        }
    }

    private Cluster addCluster(String string) {
        Cluster cluster;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CWPMC ClusterCollection.addCluster(" + string + ")");
        }
        if ((cluster = (Cluster)this._clusters.get(string)) == null) {
            cluster = new Cluster(string);
            this._clusters.put(string, cluster);
        }
        return cluster;
    }

    protected class Cluster {
        String _name;
        ArrayList _servers;

        protected Cluster(String string) {
            this._name = string;
            this._servers = new ArrayList();
        }

        protected void addServer(String string, String string2) throws CommandException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "CWPMC ClusterCollection.addServer(" + string + ":" + string2 + ")");
            }
            Server server2 = ClusterCollection.this._serverCollection.getServer(string, string2);
            this._servers.add(server2);
        }

        protected ArrayList getPorts(ArrayList arrayList) throws CommandException {
            ArrayList arrayList2 = new ArrayList();
            Iterator iterator = this._servers.iterator();
            while (iterator.hasNext()) {
                Server server2 = (Server)iterator.next();
                arrayList2.addAll(server2.getPorts(arrayList));
            }
            return arrayList2;
        }
    }
}

