/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.commands.ports;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.wsspi.management.commands.ports.PortsCommandBase;
import com.ibm.wsspi.management.commands.ports.PortsCommandProvider;
import com.ibm.wsspi.management.commands.ports.PortsCommandUtil;
import com.ibm.wsspi.management.commands.ports.Server;

public class DisableServerPortCommand
extends PortsCommandBase {
    private static TraceComponent tc = Tr.register(DisableServerPortCommand.class, PortsCommandProvider.PORTS_COMMAND_TRACEGROUP, PortsCommandProvider.PORTS_COMMAND_PACKAGE);
    private ConfigService _service;
    private Session _session;
    private String _serverName;
    private String _nodeName;
    private String _endPointName;
    private Server _server;

    public DisableServerPortCommand(CommandMetadata commandMetadata) throws CommandNotFoundException {
        super(commandMetadata);
    }

    public DisableServerPortCommand(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CWPMC disableServerPort.execute");
        }
        CommandResultImpl commandResultImpl = new CommandResultImpl();
        this._service = this.getConfigService();
        this._session = this.getConfigSession();
        try {
            this._serverName = (String)this.getTargetObject();
            this._nodeName = (String)this.getParameter(PortsCommandUtil.NODENAME_PARM_TYPE);
            this._endPointName = (String)this.getParameter(PortsCommandUtil.ENDPOINTNAME_PARM_TYPE);
            this.validate();
            this._server = new Server(this._service, this._session, this._nodeName, this._serverName);
            commandResultImpl.setResult(this._server.disableServerPort(this._endPointName));
        }
        catch (CommandException commandException) {
            Tr.error(tc, "CWPMC execute - Exception executing disableServerPort command: ", commandException);
            commandResultImpl.setException(commandException);
        }
        this.setCommandResult(commandResultImpl);
    }

    public void validate() throws CommandValidationException {
        super.validate();
        this._nodeName = PortsCommandUtil.validateNodeAndServer(this._service, this._session, this._nodeName, this._serverName);
    }
}

