/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.commands.ports;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.wsspi.management.commands.ports.ApplicationPorts;
import com.ibm.wsspi.management.commands.ports.PortsCommandBase;
import com.ibm.wsspi.management.commands.ports.PortsCommandProvider;
import com.ibm.wsspi.management.commands.ports.PortsCommandUtil;
import java.util.ArrayList;
import java.util.Iterator;
import javax.management.ObjectName;

public class ListApplicationPortsCommand
extends PortsCommandBase {
    private static TraceComponent tc = Tr.register(ListApplicationPortsCommand.class, PortsCommandProvider.PORTS_COMMAND_TRACEGROUP, PortsCommandProvider.PORTS_COMMAND_PACKAGE);
    private ConfigService _service;
    private Session _session;
    private String _appName;
    private ObjectName _deploymentON;

    public ListApplicationPortsCommand(CommandMetadata commandMetadata) throws CommandNotFoundException {
        super(commandMetadata);
    }

    public ListApplicationPortsCommand(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ListApplicationPortsCommand.execute");
        }
        CommandResultImpl commandResultImpl = new CommandResultImpl();
        this._service = this.getConfigService();
        this._session = this.getConfigSession();
        this._deploymentON = null;
        try {
            this._appName = (String)this.getTargetObject();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CWPMC ListApplicationPortsCommand.execute - application = " + this._appName);
            }
            this.validate();
            commandResultImpl.setResult(this.getApplicationPorts());
        }
        catch (CommandException commandException) {
            Tr.error(tc, "CWPMC execute- Exception executing listApplicationPorts command: ", commandException);
            commandResultImpl.setException(commandException);
        }
        this.setCommandResult(commandResultImpl);
    }

    public void validate() throws CommandValidationException {
        ArrayList arrayList;
        super.validate();
        try {
            arrayList = PortsCommandUtil.getObjects(this._service, this._session, PortsCommandUtil.DEPLOYMENT_OBJECT_TYPE);
        }
        catch (CommandException commandException) {
            throw new CommandValidationException(commandException.getMessage());
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName = (ObjectName)iterator.next();
            String string = ConfigServiceHelper.getDisplayName(objectName);
            if (!string.equals(this._appName)) continue;
            this._deploymentON = objectName;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CWPMC ListApplicationPortsCommand.validate - Deployment found for app " + this._appName, this._deploymentON);
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "CWPMC ListApplicationPortsCommand.findDeploymentForApp", "No deployments found for app " + this._appName);
        }
        throw new CommandValidationException(PortsCommandUtil.getErrorMessage("error.application.not.found", this._appName));
    }

    private ArrayList getApplicationPorts() throws CommandException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CWPMC ListApplicationPortsCommand.getApplicationPorts");
        }
        ApplicationPorts applicationPorts = new ApplicationPorts(this._service, this._session, this._appName, this._deploymentON);
        return applicationPorts.getPorts();
    }
}

