/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.commands.ports;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.models.config.host.VirtualHost;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.security.util.RestrictedAccess;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.wsspi.management.commands.ports.PortsCommandProvider;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class PortsCommandUtil {
    private static TraceComponent tc = Tr.register(PortsCommandUtil.class, PortsCommandProvider.PORTS_COMMAND_TRACEGROUP, PortsCommandProvider.PORTS_COMMAND_PACKAGE);
    protected static String BUNDLE = "com.ibm.wsspi.management.commands.resources.portscommandsmsgs";
    protected static String NODE_ATTRIBUTE_NAME = "node";
    protected static String SERVER_ATTRIBUTE_NAME = "server";
    protected static String ENDPOINTNAME_ATTRIBUTE_NAME = "endpointname";
    protected static String HOST_ATTRIBUTE_NAME = "host";
    protected static String PORT_ATTRIBUTE_NAME = "port";
    protected static String ENDPOINTNAME_PARM_TYPE = "endPointName";
    protected static String HOST_PARM_TYPE = "host";
    protected static String NODENAME_PARM_TYPE = "nodeName";
    protected static String PORT_PARM_TYPE = "port";
    protected static String MODIFYSHARED_PARM_TYPE = "modifyShared";
    protected static String CLUSTEREDTARGET_OBJECT_TYPE = "ClusteredTarget";
    protected static String DEPLOYMENT_OBJECT_TYPE = "Deployment";
    protected static String EJBMODULEDEPLOYMENT_OBJECT_TYPE = "EJBModuleDeployment";
    protected static String ORB_CHANNEL_OBJECT_TYPE = "ORBInboundChannel";
    protected static String SERVERCLUSTER_OBJECT_TYPE = "ServerCluster";
    protected static String SERVERTARGET_OBJECT_TYPE = "ServerTarget";
    protected static String SIP_CHANNEL_OBJECT_TYPE = "SIPInboundChannel";
    protected static String TCP_CHANNEL_OBJECT_TYPE = "TCPInboundChannel";
    protected static String TCS_OBJECT_TYPE = "TransportChannelService";
    protected static String UDP_CHANNEL_OBJECT_TYPE = "UDPInboundChannel";
    protected static String WC_CHANNEL_OBJECT_TYPE = "WebContainerInboundChannel";
    protected static String WEBMODULEDEPLOYMENT_OBJECT_TYPE = "WebModuleDeployment";
    protected static String PROXY_CHANNEL_OBJECT_TYPE = "ProxyInboundChannel";
    protected static String CHAINS_ATTR_TYPE = "chains";
    protected static String DEPLOYEDOBJECT_ATTR_TYPE = "deployedObject";
    protected static String DEPLOYMENTTARGETS_ATTR_TYPE = "deploymentTargets";
    protected static String ENDPOINT_ATTR_TYPE = "endPoint";
    protected static String ENDPOINTNAME_ATTR_TYPE = "endPointName";
    protected static String HOST_ATTR_TYPE = "host";
    protected static String MEMBERNAME_ATTR_TYPE = "memberName";
    protected static String MEMBERS_ATTR_TYPE = "members";
    protected static String MODULES_ATTR_TYPE = "modules";
    protected static String NAME_ATTR_TYPE = "name";
    protected static String NODENAME_ATTR_TYPE = "nodeName";
    protected static String PARENT_ATTR_TYPE = "parent";
    protected static String PORT_ATTR_TYPE = "port";
    protected static String SERVICES_ATTR_TYPE = "services";
    protected static String SPECIALENDPOINTS_ATTR_TYPE = "specialEndpoints";
    protected static String TARGET_ATTR_TYPE = "target";
    protected static String TARGETMAPPINGS_ATTR_TYPE = "targetMappings";
    protected static String TRANSPORTCHANNELS_ATTR_TYPE = "transportChannels";
    protected static String URI_ATTR_TYPE = "uri";
    protected static String CHAIN_ENABLE_ATTR_TYPE = "enable";
    protected static String NODE_SPECIFICATION = "Node=";
    protected static String SERVER_SPECIFICATION = "Server=";
    protected static String SERVERENTRY_SPECIFICATION = "ServerEntry=";
    protected static String WEBCONTAINER_PORTS = "0";
    protected static String ORB_PORTS = "1";
    protected static String SIP_PORTS = "2";
    protected static String VIRTUAL_HOSTS_FILE = "virtualhosts.xml";
    protected static String SIP_CONFIG_FILE = "sip.xml";
    protected static String WEB_CONFIG_FILE = "web.xml";
    protected static String WEB_DD_LOCATION = "WEB-INF";
    protected static String SERVLET_ELEMENT_NAME = "servlet";
    protected static String SERVLET_NAME_ELEMENT_NAME = "servlet-name";
    protected static String WELCOME_FILE_ELEMENT_NAME = "welcome-file";
    protected static String ERROR_PAGE_FILE_ELEMENT_NAME = "error-page";

    protected static ConfigService getConfigService() {
        return CommandMgr.getCommandMgr().getCommandProviderHelper().getConfigService();
    }

    protected static ArrayList getObjects(ConfigService configService, Session session, String string) throws CommandException {
        ArrayList<ObjectName> arrayList = new ArrayList<ObjectName>();
        ObjectName[] objectNameArray = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CWPMC getObjects (" + string + ")");
        }
        try {
            ObjectName objectName = ConfigServiceHelper.createObjectName(null, string, null);
            objectNameArray = configService.queryConfigObjects(session, null, objectName, null);
            for (int i = 0; i < objectNameArray.length; ++i) {
                arrayList.add(objectNameArray[i]);
            }
        }
        catch (Exception exception) {
            Tr.error(tc, "CWPMC Exception getting " + string + "objects: ", exception);
            throw new CommandException(PortsCommandUtil.getErrorMessage("unexpected.error.object", string));
        }
        return arrayList;
    }

    protected static String getServerKey(String string, String string2) {
        return string + "%%" + string2;
    }

    protected static ObjectName getServerON(ConfigService configService, Session session, String string, String string2) throws CommandException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CWPMC getServerON (" + string + ":" + string2 + ")");
        }
        ObjectName[] objectNameArray = PortsCommandUtil.resolveONs(configService, session, SERVER_SPECIFICATION + string2);
        for (int i = 0; i < objectNameArray.length; ++i) {
            ObjectName objectName = PortsCommandUtil.getParent(configService, session, objectNameArray[i]);
            String string3 = (String)PortsCommandUtil.getAttribute(configService, session, objectName, NAME_ATTR_TYPE);
            if (!string3.equals(string)) continue;
            return objectNameArray[i];
        }
        throw new CommandException(PortsCommandUtil.getErrorMessage("error.server.not.found.on.node", new Object[]{string, string2}));
    }

    protected static ObjectName getParent(ConfigService configService, Session session, ObjectName objectName) throws CommandException {
        ObjectName objectName2;
        try {
            objectName2 = configService.getRelationship(session, objectName, PARENT_ATTR_TYPE)[0];
        }
        catch (Exception exception) {
            Tr.error(tc, "CWPMC getParent -Caught exception: ", exception);
            throw new CommandException(PortsCommandUtil.getErrorMessage("unexpected.error.parent", new Object[]{objectName}));
        }
        return objectName2;
    }

    protected static List getServerChains(ConfigService configService, Session session, String string, String string2) throws CommandException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CWPMC getServerChains (" + string + ":" + string2 + ")");
        }
        ObjectName objectName = PortsCommandUtil.getServerON(configService, session, string, string2);
        ObjectName objectName2 = PortsCommandUtil.getTransportChannelService(configService, session, objectName);
        return (List)PortsCommandUtil.getAttribute(configService, session, objectName2, CHAINS_ATTR_TYPE);
    }

    protected static List getServerChannels(ConfigService configService, Session session, String string, String string2) throws CommandException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CWPMC getServerChannels (" + string + ":" + string2 + ")");
        }
        ObjectName objectName = PortsCommandUtil.getServerON(configService, session, string, string2);
        ObjectName objectName2 = PortsCommandUtil.getTransportChannelService(configService, session, objectName);
        return (List)PortsCommandUtil.getAttribute(configService, session, objectName2, TRANSPORTCHANNELS_ATTR_TYPE);
    }

    protected static ObjectName[] resolveONs(ConfigService configService, Session session, String string) throws CommandException {
        ObjectName[] objectNameArray;
        try {
            objectNameArray = configService.resolve(session, string);
        }
        catch (Exception exception) {
            Tr.error(tc, "CWPMC resolveONs - Caught exception: ", exception);
            throw new CommandException(PortsCommandUtil.getErrorMessage("unexpected.error.specification", string));
        }
        return objectNameArray;
    }

    protected static Object getAttribute(ConfigService configService, Session session, ObjectName objectName, String string) throws CommandException {
        Object object;
        try {
            object = configService.getAttribute(session, objectName, string, false);
        }
        catch (Exception exception) {
            Tr.error(tc, "CWPMC getAttribute - Caught exception: ", exception);
            throw new CommandException(PortsCommandUtil.getErrorMessage("unexpected.error.attributes", new Object[]{string, objectName}));
        }
        return object;
    }

    protected static String getErrorMessage(String string) {
        return PortsCommandUtil.getErrorMessage(string, (Object[])null);
    }

    protected static ObjectName getTransportChannelService(ConfigService configService, Session session, ObjectName objectName) throws CommandException {
        List list = (List)PortsCommandUtil.getAttribute(configService, session, objectName, SERVICES_ATTR_TYPE);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName2 = (ObjectName)iterator.next();
            String string = ConfigServiceHelper.getConfigDataType(objectName2);
            if (!string.equals(TCS_OBJECT_TYPE)) continue;
            return objectName2;
        }
        return null;
    }

    protected static String getErrorMessage(String string, String string2) {
        return PortsCommandUtil.getErrorMessage(string, new Object[]{string2});
    }

    protected static String getErrorMessage(String string, Object[] objectArray) {
        String string2 = TraceNLS.getFormattedMessage(BUNDLE, string, objectArray, null);
        Tr.error(tc, string, string2);
        return string2;
    }

    protected static String getWarningMessage(String string, Object[] objectArray) {
        String string2 = TraceNLS.getFormattedMessage(BUNDLE, string, objectArray, null);
        if (tc.isWarningEnabled()) {
            Tr.warning(tc, string2);
        }
        return string2;
    }

    protected static AttributeList getSpecialEndpoints(ConfigService configService, Session session, String string, String string2) throws CommandException {
        AttributeList attributeList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CWPMC getSpecialEndpoints (" + string + ":" + string2 + ")");
        }
        try {
            ObjectName objectName = configService.resolve(session, null, "Node=" + string)[0];
            ObjectName objectName2 = configService.getRelationship(session, objectName, "ServerIndex")[0];
            ObjectName objectName3 = configService.resolve(session, objectName2, SERVERENTRY_SPECIFICATION + string2)[0];
            attributeList = configService.getAttributes(session, objectName3, new String[]{SPECIALENDPOINTS_ATTR_TYPE}, false);
        }
        catch (Exception exception) {
            Tr.error(tc, "CWPMC getSpecialEndpoints - Caught exception: ", exception);
            throw new CommandException(PortsCommandUtil.getErrorMessage("unexpected.error.endpoints", new Object[]{string2, string}));
        }
        return attributeList;
    }

    protected static ObjectName getServerON(ConfigService configService, Session session, String string) throws CommandException {
        ObjectName[] objectNameArray;
        try {
            objectNameArray = configService.resolve(session, SERVER_SPECIFICATION + string);
        }
        catch (Exception exception) {
            throw new CommandException(PortsCommandUtil.getErrorMessage("error.server.not.found", string));
        }
        if (objectNameArray.length != 1) {
            String string2 = objectNameArray.length == 0 ? PortsCommandUtil.getErrorMessage("error.server.not.found", string) : PortsCommandUtil.getErrorMessage("error.server.not.unique", string);
            throw new CommandException(string2);
        }
        return objectNameArray[0];
    }

    protected static String getNodeName(ConfigService configService, Session session, String string) throws CommandException {
        ObjectName objectName = PortsCommandUtil.getServerON(configService, session, string);
        ObjectName objectName2 = PortsCommandUtil.getParent(configService, session, objectName);
        return (String)PortsCommandUtil.getAttribute(configService, session, objectName2, NAME_ATTR_TYPE);
    }

    protected static ObjectName[] getNodeON(ConfigService configService, Session session, String string) throws CommandException {
        ObjectName[] objectNameArray = null;
        objectNameArray = PortsCommandUtil.resolveONs(configService, session, NODE_SPECIFICATION + string);
        if (objectNameArray == null || objectNameArray.length == 0) {
            throw new CommandException(PortsCommandUtil.getErrorMessage("error.node.not.found", string));
        }
        return objectNameArray;
    }

    protected static String validateNodeAndServer(ConfigService configService, Session session, String string, String string2) throws CommandValidationException {
        try {
            if (string == null) {
                string = PortsCommandUtil.getNodeName(configService, session, string2);
            } else {
                PortsCommandUtil.getNodeON(configService, session, string);
            }
            PortsCommandUtil.getServerON(configService, session, string, string2);
        }
        catch (CommandException commandException) {
            throw new CommandValidationException(commandException.getMessage());
        }
        return string;
    }

    public static VirtualHost[] getVirtualHosts(Session session) {
        VirtualHost[] virtualHostArray;
        block21: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getVirtualHosts");
            }
            virtualHostArray = null;
            try {
                WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
                RepositoryContext repositoryContext = workSpace.getRootContext();
                RepositoryMetaData repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
                RepositoryContextType repositoryContextType = repositoryMetaData.getContextType("cells");
                Collection collection = repositoryContext.findContext(repositoryContextType);
                if (collection == null || collection.size() < 1) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getVirtualHosts", "Cannot find cell context");
                    }
                    throw new Exception("Cannot find cell context");
                }
                RepositoryContext repositoryContext2 = (RepositoryContext)collection.iterator().next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found context for cell", repositoryContext2.getName());
                }
                String string = repositoryContext2.getName();
                Resource resource = null;
                RepositoryContext repositoryContext3 = workSpace.findContext("cells/" + string);
                if (repositoryContext3 == null) {
                    virtualHostArray = new VirtualHost[]{};
                    return virtualHostArray;
                }
                ResourceSet resourceSet = repositoryContext3.getResourceSet();
                if (repositoryContext3.isAvailable(VIRTUAL_HOSTS_FILE)) {
                    Object object;
                    RepositoryContext repositoryContext4;
                    if (!repositoryContext3.isExtracted(VIRTUAL_HOSTS_FILE)) {
                        if (SecurityContext.isSecurityEnabled()) {
                            if (!RestrictedAccess.isReadable(VIRTUAL_HOSTS_FILE)) {
                                repositoryContext4 = repositoryContext3;
                                object = VIRTUAL_HOSTS_FILE;
                                try {
                                    SecurityContext.runAsSystem(new PrivilegedExceptionAction((String)object){
                                        private final /* synthetic */ String val$f;
                                        {
                                            this.val$f = string;
                                        }

                                        public Object run() throws WorkSpaceException {
                                            repositoryContext4.extract(this.val$f, false);
                                            if (tc.isEntryEnabled()) {
                                                Tr.exit(tc, "getVirtualHosts");
                                            }
                                            return new String[0];
                                        }
                                    });
                                }
                                catch (PrivilegedActionException privilegedActionException) {
                                    throw (WorkSpaceException)privilegedActionException.getException();
                                }
                            } else {
                                repositoryContext3.extract(VIRTUAL_HOSTS_FILE, false);
                            }
                        } else {
                            repositoryContext3.extract(VIRTUAL_HOSTS_FILE, false);
                        }
                    }
                    resource = resourceSet.createResource(URI.createURI((String)VIRTUAL_HOSTS_FILE));
                    resource.load(new HashMap());
                    repositoryContext4 = resource.getContents();
                    if (repositoryContext4 != null && repositoryContext4.size() > 0) {
                        object = repositoryContext4.iterator();
                        ArrayList<VirtualHost> arrayList = new ArrayList<VirtualHost>();
                        while (object.hasNext()) {
                            Object e2 = object.next();
                            if (!(e2 instanceof VirtualHost)) continue;
                            VirtualHost virtualHost = (VirtualHost)e2;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "virtual host found: " + virtualHost.getName());
                            }
                            arrayList.add(virtualHost);
                        }
                        int n = arrayList.size();
                        virtualHostArray = new VirtualHost[n];
                        for (int i = 0; i < n; ++i) {
                            virtualHostArray[i] = (VirtualHost)arrayList.get(i);
                        }
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.wsspi.management.commands.ports.PortsCommandUtil.getVirtualHosts", (String)"1", (Object)PortsCommandUtil.class);
                if (!tc.isErrorEnabled()) break block21;
                Tr.error(tc, "An error occurred during the attempt to get the virtual hosts: " + exception.getMessage());
            }
        }
        if (virtualHostArray == null) {
            virtualHostArray = new VirtualHost[]{};
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getVirtualHosts");
        }
        return virtualHostArray;
    }
}

