/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.commands.ports;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.models.config.host.HostAlias;
import com.ibm.websphere.models.config.host.VirtualHost;
import com.ibm.wsspi.management.commands.ports.PortsCommandProvider;
import com.ibm.wsspi.management.commands.ports.PortsCommandUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;

class Server {
    private static TraceComponent tc = Tr.register(Server.class, PortsCommandProvider.PORTS_COMMAND_TRACEGROUP, PortsCommandProvider.PORTS_COMMAND_PACKAGE);
    private ConfigService _service;
    private Session _session;
    private String _node;
    private String _name;
    private String _serverType;
    Hashtable _endpointNames;
    private Hashtable _endPoints;
    private List _serverChannels;
    private List _serverChains;
    private boolean _modifyShared;
    private boolean _affectedVirtualHosts = false;
    private String _previousHost;
    private String _previousPort;
    private int _numVirtualHosts;
    private int[][] _ports;
    private String[][] _hostNames;

    protected Server(ConfigService configService, Session session, String string, String string2) throws CommandException {
        this.initServer(configService, session, string, string2, true);
    }

    protected Server(ConfigService configService, Session session, String string, String string2, boolean bl) throws CommandException {
        this.initServer(configService, session, string, string2, bl);
    }

    private void initServer(ConfigService configService, Session session, String string, String string2, boolean bl) throws CommandException {
        this._service = configService;
        this._session = session;
        this._node = string;
        this._name = string2;
        this._endPoints = new Hashtable();
        this._endpointNames = new Hashtable();
        ObjectName objectName = PortsCommandUtil.getServerON(this._service, this._session, this._node, this._name);
        this._serverType = (String)PortsCommandUtil.getAttribute(this._service, this._session, objectName, "serverType");
        if (this._serverType.equals("WEB_SERVER") || this._serverType.equals("XDAGENT")) {
            this._serverChains = new ArrayList();
            this._serverChannels = new ArrayList();
        } else {
            this._serverChains = PortsCommandUtil.getServerChains(this._service, this._session, this._node, this._name);
            this._serverChannels = PortsCommandUtil.getServerChannels(this._service, this._session, this._node, this._name);
        }
        this._modifyShared = bl;
    }

    protected AttributeList modifyPort(String string, String string2, String string3) throws CommandException {
        ServerEndPoint serverEndPoint = null;
        ObjectName objectName = this.getNamedEndpoint(string);
        if (objectName == null) {
            throw new CommandException(PortsCommandUtil.getErrorMessage("error.endpoint.not.found", string));
        }
        if (!this._modifyShared && this.endPointIsShared(string)) {
            throw new CommandException(PortsCommandUtil.getErrorMessage("error.shared.port", string));
        }
        try {
            ObjectName objectName2 = (ObjectName)this._service.getAttribute(this._session, objectName, PortsCommandUtil.ENDPOINT_ATTR_TYPE, false);
            AttributeList attributeList = new AttributeList();
            if (string2 != null) {
                attributeList.add(new Attribute(PortsCommandUtil.HOST_ATTR_TYPE, string2));
            }
            if (string3 != null) {
                attributeList.add(new Attribute(PortsCommandUtil.PORT_ATTR_TYPE, new Integer(string3)));
            }
            this.calculateAffectedVirtualHosts(string2, string3, objectName2, string);
            this._service.setAttributes(this._session, objectName2, attributeList);
            serverEndPoint = new ServerEndPoint(string, objectName);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Tr.error(tc, "CWPMC Server.modifyPort - Caught exception: ", exception);
            throw new CommandException(PortsCommandUtil.getErrorMessage("unexpected.error.modify.endpoints", new Object[]{string, this._name, this._node}));
        }
        return this.displayEndPoint(serverEndPoint);
    }

    private void calculateAffectedVirtualHosts(String string, String string2, ObjectName objectName, String string3) throws CommandException, ConnectorException, ConfigServiceException {
        if (this.endPointVirtualHostAssociated(string3)) {
            boolean bl;
            this._previousHost = (String)this._service.getAttribute(this._session, objectName, PortsCommandUtil.HOST_ATTR_TYPE);
            Integer n = (Integer)this._service.getAttribute(this._session, objectName, PortsCommandUtil.PORT_ATTR_TYPE);
            this._previousPort = n.toString();
            boolean bl2 = string != null && string.length() > 0 && !string.equals("*") && !this._previousHost.equals(string);
            boolean[] blArray = null;
            if (bl2) {
                this.loadVirtualHostAliases();
                for (int i = 0; i < this._numVirtualHosts; ++i) {
                    blArray = this.getMatchingVirtualHostAliasHostSubset(i, this._previousHost);
                    if (blArray == null || !this.matchVirtualHostAliasPortSubset(i, this._previousPort, blArray) && !this.matchVirtualHostAliasPortSubset(i, "*", blArray)) continue;
                    if (string.equals("*")) {
                        if (this.matchVirtualHostAlias(i, string2)) continue;
                        this._affectedVirtualHosts = true;
                        return;
                    }
                    if (this.matchVirtualHostAlias(i, string, string2) || this.matchVirtualHostAlias(i, string, "*") || this.matchVirtualHostAlias(i, "*", string2)) continue;
                    this._affectedVirtualHosts = true;
                    return;
                }
                return;
            }
            boolean bl3 = bl = string2 != null && string2.length() > 0 && !this._previousPort.equals(string2);
            if (bl) {
                this.loadVirtualHostAliases();
                for (int i = 0; i < this._numVirtualHosts; ++i) {
                    blArray = this.getMatchingVirtualHostAliasPortSubset(i, this._previousPort);
                    if (blArray == null || !this._previousHost.equals("*") && !this.matchVirtualHostAliasHostnameSubset(i, this._previousHost, blArray) && !this.matchVirtualHostAliasHostnameSubset(i, "*", blArray) || this.matchVirtualHostAlias(i, string, string2) || this.matchVirtualHostAlias(i, string, "*") || this.matchVirtualHostAlias(i, "*", string2)) continue;
                    this._affectedVirtualHosts = true;
                    return;
                }
            }
        }
    }

    protected String getPreviousHost() {
        return this._previousHost;
    }

    protected String getPreviousPort() {
        return this._previousPort;
    }

    private void loadVirtualHostAliases() {
        VirtualHost[] virtualHostArray = PortsCommandUtil.getVirtualHosts(this._session);
        LinkedList<String> linkedList = new LinkedList<String>();
        LinkedList<String> linkedList2 = new LinkedList<String>();
        this._hostNames = new String[virtualHostArray.length][];
        this._ports = new int[virtualHostArray.length][];
        this._numVirtualHosts = virtualHostArray.length;
        for (int i = 0; i < virtualHostArray.length; ++i) {
            int n;
            int n2;
            EList eList = virtualHostArray[i].getAliases();
            linkedList = new LinkedList();
            linkedList2 = new LinkedList();
            if (eList == null || eList.size() == 0) {
                this._hostNames[i] = new String[0];
                this._ports[i] = new int[0];
                continue;
            }
            int n3 = eList.size();
            for (n2 = 0; n2 < n3; ++n2) {
                HostAlias hostAlias = (HostAlias)eList.get(n2);
                linkedList.add(this.normalizeHostname(hostAlias.getHostname()));
                String string = hostAlias.getPort();
                if (string.equals("*")) {
                    string = "-1";
                }
                linkedList2.add(string);
            }
            n2 = linkedList.size();
            this._hostNames[i] = new String[n2];
            for (n = 0; n < n2; ++n) {
                this._hostNames[i][n] = (String)linkedList.get(n);
            }
            n = linkedList2.size();
            this._ports[i] = new int[n];
            for (int j = 0; j < n; ++j) {
                this._ports[i][j] = Integer.parseInt((String)linkedList2.get(j));
            }
        }
    }

    private String normalizeHostname(String string) {
        String string2 = new String(string);
        string2 = string2.replaceAll("[\\.]", "\\\\\\.");
        string2 = string2.replaceAll("[*]", "\\.\\*");
        return string2;
    }

    protected boolean isAffectedVirtualHosts() {
        return this._affectedVirtualHosts;
    }

    private boolean matchVirtualHostAlias(int n, String string) {
        String string2 = string;
        if (string2 == null) {
            string2 = this._previousPort;
        }
        int n2 = Integer.parseInt(string2);
        for (int i = 0; i < this._ports[n].length; ++i) {
            if (n2 != this._ports[n][i] && -1 != this._ports[n][i]) continue;
            return true;
        }
        return false;
    }

    private boolean matchVirtualHostAlias(int n, String string, String string2) {
        String string3;
        String string4 = string;
        if (string4 == null) {
            string4 = this._previousHost;
        }
        if ((string3 = string2) == null) {
            string3 = this._previousPort;
        }
        int n2 = string3.equals("*") ? -1 : Integer.parseInt(string3);
        for (int i = 0; i < this._ports[n].length; ++i) {
            if (n2 != this._ports[n][i] || !string4.matches(this._hostNames[n][i])) continue;
            return true;
        }
        return false;
    }

    private boolean matchVirtualHostAliasPortSubset(int n, String string, boolean[] blArray) {
        int n2 = string.equals("*") ? -1 : Integer.parseInt(string);
        for (int i = 0; i < this._ports[n].length; ++i) {
            if (!blArray[i] || this._ports[n][i] != n2) continue;
            return true;
        }
        return false;
    }

    private boolean matchVirtualHostAliasHostnameSubset(int n, String string, boolean[] blArray) {
        for (int i = 0; i < this._hostNames[n].length; ++i) {
            if (!blArray[i] || !string.matches(this._hostNames[n][i])) continue;
            return true;
        }
        return false;
    }

    private boolean[] getMatchingVirtualHostAliasHostSubset(int n, String string) {
        int n2 = 0;
        boolean[] blArray = new boolean[this._hostNames[n].length];
        for (int i = 0; i < this._hostNames[n].length; ++i) {
            if (string.equals("*")) {
                blArray[i] = true;
                ++n2;
                continue;
            }
            if (!string.matches(this._hostNames[n][i])) continue;
            blArray[i] = true;
            ++n2;
        }
        if (n2 == 0) {
            return null;
        }
        return blArray;
    }

    private boolean[] getMatchingVirtualHostAliasPortSubset(int n, String string) {
        int n2 = 0;
        boolean[] blArray = new boolean[this._ports[n].length];
        int n3 = Integer.parseInt(string);
        for (int i = 0; i < this._ports[n].length; ++i) {
            if (this._ports[n][i] != n3 && this._ports[n][i] != -1) continue;
            blArray[i] = true;
            ++n2;
        }
        if (n2 == 0) {
            return null;
        }
        return blArray;
    }

    private boolean endPointIsShared(String string) throws CommandException {
        int n = 0;
        Iterator iterator = this._serverChains.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName = (ObjectName)iterator.next();
            List list = (List)PortsCommandUtil.getAttribute(this._service, this._session, objectName, PortsCommandUtil.TRANSPORTCHANNELS_ATTR_TYPE);
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                boolean bl = false;
                ObjectName objectName2 = (ObjectName)iterator2.next();
                String string2 = ConfigServiceHelper.getConfigDataType(objectName2);
                if (string2.equals(PortsCommandUtil.TCP_CHANNEL_OBJECT_TYPE)) {
                    bl = true;
                } else if (string2.equals(PortsCommandUtil.UDP_CHANNEL_OBJECT_TYPE)) {
                    bl = true;
                }
                if (!bl || !this.channelUsesEndpoint(objectName2, string) || ++n <= 1) continue;
                return true;
            }
        }
        return false;
    }

    private boolean endPointVirtualHostAssociated(String string) throws CommandException {
        Iterator iterator = this._serverChains.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName = (ObjectName)iterator.next();
            List list = (List)PortsCommandUtil.getAttribute(this._service, this._session, objectName, PortsCommandUtil.TRANSPORTCHANNELS_ATTR_TYPE);
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                ObjectName objectName2 = (ObjectName)iterator2.next();
                String string2 = ConfigServiceHelper.getConfigDataType(objectName2);
                if (!string2.equals(PortsCommandUtil.WC_CHANNEL_OBJECT_TYPE) && !string2.equals(PortsCommandUtil.PROXY_CHANNEL_OBJECT_TYPE)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean channelUsesEndpoint(ObjectName objectName, String string) throws CommandException {
        String string2 = (String)PortsCommandUtil.getAttribute(this._service, this._session, objectName, PortsCommandUtil.ENDPOINTNAME_ATTR_TYPE);
        return string.equals(string2);
    }

    protected ArrayList getPorts() throws CommandException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CWPMC Server.getPorts(" + this._node + ":" + this._name + ")");
        }
        AttributeList attributeList = PortsCommandUtil.getSpecialEndpoints(this._service, this._session, this._node, this._name);
        List list = (List)((Attribute)attributeList.get(0)).getValue();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName = (ObjectName)iterator.next();
            String string = (String)PortsCommandUtil.getAttribute(this._service, this._session, objectName, PortsCommandUtil.ENDPOINTNAME_ATTR_TYPE);
            this.addEndPoint(string, objectName);
        }
        return this.displayEndPoints();
    }

    protected ArrayList getPorts(ArrayList arrayList) throws CommandException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        boolean bl = arrayList.contains(PortsCommandUtil.WEBCONTAINER_PORTS);
        boolean bl2 = arrayList.contains(PortsCommandUtil.ORB_PORTS);
        boolean bl3 = arrayList.contains(PortsCommandUtil.SIP_PORTS);
        Iterator iterator = this._serverChains.iterator();
        while (iterator.hasNext()) {
            object6 = (ObjectName)iterator.next();
            object5 = ConfigServiceHelper.getConfigDataType((ObjectName)object6);
            object4 = ConfigServiceHelper.getDisplayName((ObjectName)object6);
            object3 = null;
            object2 = null;
            object = (List)PortsCommandUtil.getAttribute(this._service, this._session, (ObjectName)object6, PortsCommandUtil.TRANSPORTCHANNELS_ATTR_TYPE);
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                ObjectName objectName = (ObjectName)iterator2.next();
                object5 = ConfigServiceHelper.getConfigDataType(objectName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "CWPMC Server.getPorts - channelON found, dataType = " + (String)object5, objectName);
                }
                if (((String)object5).equals(PortsCommandUtil.WC_CHANNEL_OBJECT_TYPE)) {
                    if (!bl) continue;
                    object2 = ConfigServiceHelper.getDisplayName(objectName);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "CWPMC Server.getPorts - found webContainer terminating channel " + (String)object2);
                    continue;
                }
                if (((String)object5).equals(PortsCommandUtil.ORB_CHANNEL_OBJECT_TYPE)) {
                    if (!bl2) continue;
                    object2 = ConfigServiceHelper.getDisplayName(objectName);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "CWPMC Server.getPorts - found ORB terminating channel " + (String)object2);
                    continue;
                }
                if (((String)object5).equals(PortsCommandUtil.SIP_CHANNEL_OBJECT_TYPE)) {
                    if (!bl3) continue;
                    object2 = ConfigServiceHelper.getDisplayName(objectName);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "CWPMC Server.getPorts - found SIP terminating channel " + (String)object2);
                    continue;
                }
                if (((String)object5).equals(PortsCommandUtil.TCP_CHANNEL_OBJECT_TYPE)) {
                    object3 = ConfigServiceHelper.getDisplayName(objectName);
                    continue;
                }
                if (!((String)object5).equals(PortsCommandUtil.UDP_CHANNEL_OBJECT_TYPE)) continue;
                object3 = ConfigServiceHelper.getDisplayName(objectName);
            }
            if (object2 == null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CWPMC Server.getPorts - applicationChannelName = " + (String)object2 + " networkChannelName = " + (String)object3);
            }
            hashtable.put(object3, object4);
        }
        object6 = this._serverChannels.iterator();
        while (object6.hasNext()) {
            object5 = (ObjectName)object6.next();
            object4 = ConfigServiceHelper.getConfigDataType((ObjectName)object5);
            if (!((String)object4).equals(PortsCommandUtil.TCP_CHANNEL_OBJECT_TYPE) && !((String)object4).equals(PortsCommandUtil.UDP_CHANNEL_OBJECT_TYPE) || hashtable.get(object3 = ConfigServiceHelper.getDisplayName((ObjectName)object5)) == null) continue;
            this.addEndpointName((ObjectName)object5);
        }
        object5 = PortsCommandUtil.getSpecialEndpoints(this._service, this._session, this._node, this._name);
        object4 = (List)((Attribute)((ArrayList)object5).get(0)).getValue();
        object3 = object4.iterator();
        while (object3.hasNext()) {
            object2 = (ObjectName)object3.next();
            object = (String)PortsCommandUtil.getAttribute(this._service, this._session, (ObjectName)object2, PortsCommandUtil.ENDPOINTNAME_ATTR_TYPE);
            if (this._endpointNames.get(object) == null) continue;
            this.addEndPoint((String)object, (ObjectName)object2);
        }
        return this.displayEndPoints();
    }

    private ObjectName getNamedEndpoint(String string) throws CommandException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CWPMC Server.getNamedEndpoint(" + string + ")");
        }
        try {
            AttributeList attributeList = PortsCommandUtil.getSpecialEndpoints(this._service, this._session, this._node, this._name);
            List list = (List)((Attribute)attributeList.get(0)).getValue();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ObjectName objectName = (ObjectName)iterator.next();
                String string2 = (String)this._service.getAttribute(this._session, objectName, PortsCommandUtil.ENDPOINTNAME_ATTR_TYPE, false);
                if (!string2.equals(string)) continue;
                return objectName;
            }
        }
        catch (Exception exception) {
            throw new CommandException(PortsCommandUtil.getErrorMessage("unexpected.error.endpoints", new Object[]{this._name, this._node}));
        }
        return null;
    }

    private void addEndpointName(ObjectName objectName) throws CommandException {
        String string = (String)PortsCommandUtil.getAttribute(this._service, this._session, objectName, PortsCommandUtil.ENDPOINTNAME_ATTR_TYPE);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "CWPMC Server.addEndpointName - endpoint name = " + string);
        }
        this._endpointNames.put(string, string);
    }

    private void addEndPoint(String string, ObjectName objectName) throws CommandException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CWPMC Server.addEndPoint(" + string + ")");
        }
        this._endPoints.put(string, new ServerEndPoint(string, objectName));
    }

    private AttributeList displayEndPoint(ServerEndPoint serverEndPoint) {
        AttributeList attributeList = new AttributeList();
        attributeList.add(new Attribute(PortsCommandUtil.HOST_ATTRIBUTE_NAME, serverEndPoint._host));
        attributeList.add(new Attribute(PortsCommandUtil.NODE_ATTRIBUTE_NAME, this._node));
        attributeList.add(new Attribute(PortsCommandUtil.SERVER_ATTRIBUTE_NAME, this._name));
        attributeList.add(new Attribute(PortsCommandUtil.PORT_ATTRIBUTE_NAME, serverEndPoint._port));
        AttributeList attributeList2 = new AttributeList();
        attributeList2.add(new Attribute(serverEndPoint._endPointName, attributeList));
        return attributeList2;
    }

    private ArrayList displayEndPoints() {
        ArrayList<AttributeList> arrayList = new ArrayList<AttributeList>();
        Enumeration enumeration = this._endPoints.elements();
        while (enumeration.hasMoreElements()) {
            ServerEndPoint serverEndPoint = (ServerEndPoint)enumeration.nextElement();
            arrayList.add(this.displayEndPoint(serverEndPoint));
        }
        return arrayList;
    }

    public Object disableServerPort(String string) throws CommandException {
        List list;
        Serializable serializable;
        Object object;
        ObjectName objectName = PortsCommandUtil.getServerON(this._service, this._session, this._node, this._name);
        ObjectName objectName2 = PortsCommandUtil.getTransportChannelService(this._service, this._session, objectName);
        try {
            object = CommandMgr.getCommandMgr().createCommand("listChains");
            object.setTargetObject(objectName2);
            object.setParameter("endPointFilter", string);
            object.execute();
            serializable = object.getCommandResult();
            list = (List)serializable.getResult();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.wsspi.management.commands.ports.Server", (String)"1", (Object)this);
            if (tc.isErrorEnabled()) {
                Tr.error(tc, "An error occurred during the listChains operation:" + exception.getMessage());
            }
            exception.printStackTrace();
            throw new CommandException("Error while retrieving the filtered list of channel chains");
        }
        object = list.iterator();
        while (object.hasNext()) {
            try {
                serializable = (ObjectName)object.next();
                AttributeList attributeList = new AttributeList();
                attributeList.add(new Attribute(PortsCommandUtil.CHAIN_ENABLE_ATTR_TYPE, false));
                this._service.setAttributes(this._session, (ObjectName)serializable, attributeList);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.wsspi.management.commands.ports.Server", (String)"2", (Object)this);
                if (tc.isErrorEnabled()) {
                    Tr.error(tc, "An error occurred during the setAttributes operation : " + exception.getMessage());
                }
                exception.printStackTrace();
                throw new CommandException("Error while setting the enable attribute on a channel chain");
            }
        }
        return list;
    }

    private class ServerEndPoint {
        String _endPointName;
        String _host;
        String _port;

        private ServerEndPoint(String string, String string2, String string3) {
            this._endPointName = string;
            this._host = string2;
            this._port = string3;
        }

        protected ServerEndPoint(String string, ObjectName objectName) throws CommandException {
            ObjectName objectName2 = (ObjectName)PortsCommandUtil.getAttribute(Server.this._service, Server.this._session, objectName, PortsCommandUtil.ENDPOINT_ATTR_TYPE);
            String string2 = (String)PortsCommandUtil.getAttribute(Server.this._service, Server.this._session, objectName2, PortsCommandUtil.HOST_ATTR_TYPE);
            Integer n = (Integer)PortsCommandUtil.getAttribute(Server.this._service, Server.this._session, objectName2, PortsCommandUtil.PORT_ATTR_TYPE);
            this._endPointName = string;
            this._host = string2;
            this._port = n.toString();
        }
    }
}

