/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.odc;

import com.ibm.wsspi.odc.ODCException;

public class ODCCardinality {
    public static final ODCCardinality ONE_TO_ONE = new ODCCardinality("one-to-one", false, false);
    public static final ODCCardinality ONE_TO_MANY = new ODCCardinality("one-to-many", true, false);
    public static final ODCCardinality MANY_TO_ONE = new ODCCardinality("many-to-one", false, true);
    public static final ODCCardinality MANY_TO_MANY = new ODCCardinality("many-to-many", true, true);
    public static final ODCCardinality[] ALL = new ODCCardinality[]{ONE_TO_ONE, ONE_TO_MANY, MANY_TO_ONE, MANY_TO_MANY};
    private final String name;
    public final boolean toOne;
    public final boolean toMany;
    public final boolean fromOne;
    public final boolean fromMany;

    private ODCCardinality(String string, boolean bl, boolean bl2) {
        this.name = string;
        this.toOne = !bl;
        this.toMany = bl;
        this.fromOne = !bl2;
        this.fromMany = bl2;
    }

    public static ODCCardinality findByName(String string) throws ODCException {
        for (int i = 0; i < ALL.length; ++i) {
            if (!string.equalsIgnoreCase(ODCCardinality.ALL[i].name)) continue;
            return ALL[i];
        }
        throw new ODCException("invalid ODC cardinality: '" + string + "'");
    }

    public ODCCardinality getReverse() {
        if (this == ONE_TO_MANY) {
            return MANY_TO_ONE;
        }
        if (this == MANY_TO_ONE) {
            return ONE_TO_MANY;
        }
        return this;
    }

    public String toString() {
        return this.name;
    }
}

