/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.odc;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.wsspi.odc.IODCFactory;
import com.ibm.wsspi.odc.ODCEdgeCardinality;
import com.ibm.wsspi.odc.ODCEdgeType;
import com.ibm.wsspi.odc.ODCException;
import com.ibm.wsspi.odc.ODCFactory;
import com.ibm.wsspi.odc.ODCManager;
import com.ibm.wsspi.odc.ODCManagerFactory;
import com.ibm.wsspi.odc.ODCNodeType;
import com.ibm.wsspi.odc.ODCPropertyDescriptor;
import com.ibm.wsspi.odc.ODCPropertyType;
import com.ibm.wsspi.odc.ODCSchema;

public class ODCHelper {
    private static final TraceComponent tc = TrUtil.register(ODCHelper.class);
    private static ODCHelper instance = null;
    public static final String CUSTOM_PROP_PREFIX = "cp.";
    public static final String CLUSTER_TYPE_STATIC = "static";
    public static final String CLUSTER_TYPE_DYNAMIC = "dynamic";
    public static final String CLUSTER_TYPE_GENERIC = "generic";
    public static final String CLUSTER_TYPE_SINGLE_SERVER = "single-server";
    public final ODCManager mgr = ODCManagerFactory.getManager();
    public final ODCSchema schema = this.mgr.getSchema();
    public final ODCNodeType cellGroup = this.schema.findNodeType("cellGroup");
    public final ODCNodeType cell = this.schema.findNodeType("cell");
    public final ODCNodeType nodeGroup = this.schema.findNodeType("nodeGroup");
    public final ODCNodeType node = this.schema.findNodeType("node");
    public final ODCNodeType cluster = this.schema.findNodeType("cluster");
    public final ODCNodeType server = this.schema.findNodeType("server");
    public final ODCNodeType serverApplication = this.schema.findNodeType("serverApplication");
    public final ODCNodeType proxyContainer = this.schema.findNodeType("proxyContainer");
    public final ODCNodeType transport = this.schema.findNodeType("transport");
    public final ODCNodeType channelChain = this.schema.findNodeType("channelChain");
    public final ODCNodeType channel = this.schema.findNodeType("channel");
    public final ODCNodeType vhostGroup = this.schema.findNodeType("vhostGroup");
    public final ODCNodeType vhost = this.schema.findNodeType("vhost");
    public final ODCNodeType application = this.schema.findNodeType("application");
    public final ODCNodeType webModule = this.schema.findNodeType("webModule");
    public final ODCNodeType ejbModule = this.schema.findNodeType("ejbModule");
    public final ODCNodeType uri = this.schema.findNodeType("uri");
    public final ODCNodeType proxy = this.schema.findNodeType("proxy");
    public final ODCNodeType metg = this.schema.findNodeType("metg");
    public final ODCNodeType met = this.schema.findNodeType("met");
    public final ODCNodeType txcls = this.schema.findNodeType("txcls");
    public final ODCNodeType svccls = this.schema.findNodeType("svccls");
    public final ODCNodeType svcgoal = this.schema.findNodeType("svcgoal");
    public final ODCNodeType webRouteWorkClass = this.schema.findNodeType("webRouteWorkClass");
    public final ODCNodeType webSLAWorkClass = this.schema.findNodeType("webSLAWorkClass");
    public final ODCNodeType rule = this.schema.findNodeType("rule");
    public final ODCNodeType webService = this.schema.findNodeType("webService");
    public final ODCNodeType webServiceOperation = this.schema.findNodeType("webServiceOperation");
    public final ODCNodeType webServiceRouteWorkClass = this.schema.findNodeType("webServiceRouteWorkClass");
    public final ODCNodeType webServiceSLAWorkClass = this.schema.findNodeType("webServiceSLAWorkClass");
    public final ODCNodeType ejbMethod = this.schema.findNodeType("ejbMethod");
    public final ODCNodeType ejbRouteWorkClass;
    public final ODCNodeType ejbSLAWorkClass;
    public final ODCNodeType ejbPattern = this.schema.findNodeType("ejbPattern");
    public final ODCPropertyDescriptor cellIsWebSphere;
    public final ODCPropertyDescriptor cellArfmMode;
    public final ODCPropertyDescriptor cellMagicN;
    public final ODCPropertyDescriptor cellMagicNMode;
    public final ODCPropertyDescriptor cellArfmStatsPeriod;
    public final ODCPropertyDescriptor cellArfmCtlCycleMinLength;
    public final ODCPropertyDescriptor cellArfmSmoothingWindow;
    public final ODCPropertyDescriptor cellMaxArfmQueueLength;
    public final ODCPropertyDescriptor cellCpuLimit;
    public final ODCPropertyDescriptor cellBoostCPUThreshold;
    public final ODCPropertyDescriptor cellProfilerPeriod;
    public final ODCPropertyDescriptor cellProfilerHalfLife;
    public final ODCPropertyDescriptor cellUseODRs;
    public final ODCPropertyDescriptor cellUseProcessCPU;
    public final ODCPropertyDescriptor cellUseOverhead;
    public final ODCPropertyDescriptor nodeIsWebSphere;
    public final ODCPropertyDescriptor nodeIsXD;
    public final ODCPropertyDescriptor nodeHostName;
    public final ODCPropertyDescriptor nodeSpeed;
    public final ODCPropertyDescriptor nodeNumberOfCPUs;
    public final ODCPropertyDescriptor nodeStatsCollectorConfig;
    public final ODCPropertyDescriptor nodeStatsCollectorImplClass;
    public final ODCPropertyDescriptor nodeStatsCollectorRemoteAgentPort;
    public final ODCPropertyDescriptor serverType;
    public final ODCPropertyDescriptor serverSubType;
    public final ODCPropertyDescriptor serverState;
    public final ODCPropertyDescriptor serverCloneId;
    public final ODCPropertyDescriptor serverReachable;
    public final ODCPropertyDescriptor serverWeight;
    public final ODCPropertyDescriptor serverStaticWeight;
    public final ODCPropertyDescriptor serverIsODR;
    public final ODCPropertyDescriptor serverThreadPoolMin;
    public final ODCPropertyDescriptor serverThreadPoolMax;
    public final ODCPropertyDescriptor serverThreadPoolIsGrowable;
    public final ODCPropertyDescriptor serverApplicationState;
    public final ODCPropertyDescriptor transportHost;
    public final ODCPropertyDescriptor transportPort;
    public final ODCPropertyDescriptor transportProtocol;
    public final ODCPropertyDescriptor transportClass;
    public final ODCPropertyDescriptor transportSSL;
    public final ODCPropertyDescriptor transportODR;
    public final ODCPropertyDescriptor vhostHost;
    public final ODCPropertyDescriptor vhostPort;
    public final ODCPropertyDescriptor webModuleId;
    public final ODCPropertyDescriptor webModuleContextRoot;
    public final ODCPropertyDescriptor webModuleFailureStatusCode;
    public final ODCPropertyDescriptor webModuleFileServingEnabled;
    public final ODCPropertyDescriptor webModuleServeServletsByName;
    public final ODCPropertyDescriptor webModuleRedirectURL;
    public final ODCPropertyDescriptor webModuleProtocolMap;
    public final ODCPropertyDescriptor webModuleRoutingEnabled;
    public final ODCPropertyDescriptor ejbModuleContextRoot;
    public final ODCPropertyDescriptor proxyCellName;
    public final ODCPropertyDescriptor proxyNodeName;
    public final ODCPropertyDescriptor proxyServerName;
    public final ODCPropertyDescriptor txclsId;
    public final ODCPropertyDescriptor metgAlpha;
    public final ODCPropertyDescriptor metPriority;
    public final ODCPropertyDescriptor svcgoalType;
    public final ODCPropertyDescriptor svcgoalValue;
    public final ODCPropertyDescriptor svcgoalDeltaValue;
    public final ODCPropertyDescriptor svcgoalTimePeriodValue;
    public final ODCPropertyDescriptor svcgoalPercentile;
    public final ODCPropertyDescriptor svcgoalImportance;
    public final ODCPropertyDescriptor svcgoalMaxTp;
    public final ODCPropertyDescriptor svcgoalMaxTpUnit;
    public final ODCPropertyDescriptor channelChainCFEndpoint;
    public final ODCPropertyDescriptor channelFactoryClass;
    public final ODCPropertyDescriptor clusterIsReal;
    public final ODCPropertyDescriptor clusterType;
    public final ODCPropertyDescriptor clusterSpeedFactorOverrideSpec;
    public final ODCPropertyDescriptor clusterHttpSessionAffinityPolicyDescriptor;
    public final ODCPropertyDescriptor appIsWebSphere;
    public final ODCPropertyDescriptor appRoot;
    public final ODCPropertyDescriptor appEdition;
    public final ODCPropertyDescriptor appState;
    public final ODCPropertyDescriptor applicationIsSystem;
    public final ODCPropertyDescriptor appLastChangeTime;
    public final ODCPropertyDescriptor appSessionAffinityCookie;
    public final ODCPropertyDescriptor appSessionOverride;
    public final ODCPropertyDescriptor ruleExpression;
    public final ODCPropertyDescriptor ruleAction;
    public final ODCPropertyDescriptor SOAPAction;
    public final ODCPropertyDescriptor sessionPersistenceMode;
    public final ODCPropertyDescriptor transportIsActive;
    public final ODCPropertyDescriptor transportIsConfig;

    public static synchronized ODCHelper getInstance() throws ODCException {
        if (instance == null) {
            IODCFactory iODCFactory = null;
            try {
                iODCFactory = ODCFactory.getInstance();
                instance = iODCFactory.createODCHelper();
            }
            catch (Throwable throwable) {
                TrUtil.warning(throwable, "ODCHelper", "getInstance", tc);
            }
        }
        return instance;
    }

    public ODCHelper() throws ODCException {
        this.ejbRouteWorkClass = this.schema.findNodeType("ejbRouteWorkClass");
        this.ejbSLAWorkClass = this.schema.findNodeType("ejbSLAWorkClass");
        this.cellIsWebSphere = this.cell.findPropertyDescriptor("isWebSphere");
        this.cellArfmMode = this.cell.findPropertyDescriptor("arfmMode");
        this.cellMagicN = this.cell.findPropertyDescriptor("magicN");
        this.cellMagicNMode = this.cell.findPropertyDescriptor("magicNMode");
        this.cellArfmStatsPeriod = this.cell.findPropertyDescriptor("arfmStatsPeriod");
        this.cellArfmCtlCycleMinLength = this.cell.findPropertyDescriptor("arfmCtlCycleMinLength");
        this.cellArfmSmoothingWindow = this.cell.findPropertyDescriptor("arfmSmoothingWindow");
        this.cellMaxArfmQueueLength = this.cell.findPropertyDescriptor("maxArfmQueueLength");
        this.cellCpuLimit = this.cell.findPropertyDescriptor("cpuLimit");
        this.cellBoostCPUThreshold = this.cell.findPropertyDescriptor("boostCPUThreshold");
        this.cellProfilerPeriod = this.cell.findPropertyDescriptor("profilerPeriod");
        this.cellProfilerHalfLife = this.cell.findPropertyDescriptor("profilerHalfLife");
        this.cellUseODRs = this.cell.findPropertyDescriptor("useODRs");
        this.cellUseProcessCPU = this.cell.findPropertyDescriptor("useProcessCPU");
        this.cellUseOverhead = this.cell.findPropertyDescriptor("useOverhead");
        this.nodeIsWebSphere = this.node.findPropertyDescriptor("isWebSphere");
        this.nodeIsXD = this.node.findPropertyDescriptor("isXD");
        this.nodeHostName = this.node.findPropertyDescriptor("hostName");
        this.nodeSpeed = this.node.findPropertyDescriptor("speed");
        this.nodeNumberOfCPUs = this.node.findPropertyDescriptor("numberOfCPUs");
        this.nodeStatsCollectorConfig = this.node.findPropertyDescriptor("stats.collector.config");
        this.nodeStatsCollectorImplClass = this.node.findPropertyDescriptor("stats.collector.implementation.class");
        this.nodeStatsCollectorRemoteAgentPort = this.node.findPropertyDescriptor("stats.collector.remote.agent.port");
        this.serverType = this.server.findPropertyDescriptor("type");
        this.serverSubType = this.server.findPropertyDescriptor("subType");
        this.serverState = this.server.findPropertyDescriptor("state");
        this.serverCloneId = this.server.findPropertyDescriptor("id");
        this.serverReachable = this.server.findPropertyDescriptor("reachable");
        this.serverWeight = this.server.findPropertyDescriptor("weight");
        this.serverStaticWeight = this.server.findPropertyDescriptor("staticweight");
        this.serverIsODR = this.server.findPropertyDescriptor("ODR");
        this.serverThreadPoolMin = this.server.findPropertyDescriptor("threadPoolMin");
        this.serverThreadPoolMax = this.server.findPropertyDescriptor("threadPoolMax");
        this.serverThreadPoolIsGrowable = this.server.findPropertyDescriptor("threadPoolIsGrowable");
        this.serverApplicationState = this.serverApplication.findPropertyDescriptor("state");
        this.transportHost = this.transport.findPropertyDescriptor("host");
        this.transportPort = this.transport.findPropertyDescriptor("port");
        this.transportProtocol = this.transport.findPropertyDescriptor("protocol");
        this.transportClass = this.transport.findPropertyDescriptor("class");
        this.transportSSL = this.transport.findPropertyDescriptor("ssl");
        this.transportODR = this.transport.findPropertyDescriptor("ODR");
        this.vhostHost = this.vhost.findPropertyDescriptor("host");
        this.vhostPort = this.vhost.findPropertyDescriptor("port");
        this.webModuleId = this.webModule.findPropertyDescriptor("id");
        this.webModuleContextRoot = this.webModule.findPropertyDescriptor("contextRoot");
        this.webModuleFileServingEnabled = this.webModule.findPropertyDescriptor("fileServingEnabled");
        this.webModuleServeServletsByName = this.webModule.findPropertyDescriptor("serveServletsByName");
        this.webModuleRedirectURL = this.webModule.findPropertyDescriptor("redirectURL");
        this.webModuleFailureStatusCode = this.webModule.findPropertyDescriptor("failureStatusCode");
        this.webModuleProtocolMap = this.webModule.findPropertyDescriptor("protocolMap");
        this.webModuleRoutingEnabled = this.webModule.findPropertyDescriptor("routingEnabled");
        this.ejbModuleContextRoot = this.ejbModule.findPropertyDescriptor("contextRoot");
        this.proxyCellName = this.proxy.findPropertyDescriptor("cellName");
        this.proxyNodeName = this.proxy.findPropertyDescriptor("nodeName");
        this.proxyServerName = this.proxy.findPropertyDescriptor("processName");
        this.txclsId = this.txcls.findPropertyDescriptor("id");
        this.metgAlpha = this.metg.findPropertyDescriptor("alpha");
        this.metPriority = this.met.findPropertyDescriptor("priority");
        this.svcgoalType = this.svcgoal.findPropertyDescriptor("type");
        this.svcgoalValue = this.svcgoal.findPropertyDescriptor("value");
        this.svcgoalDeltaValue = this.svcgoal.findPropertyDescriptor("deltaValue");
        this.svcgoalTimePeriodValue = this.svcgoal.findPropertyDescriptor("timePeriodValue");
        this.svcgoalPercentile = this.svcgoal.findPropertyDescriptor("percentile");
        this.svcgoalImportance = this.svcgoal.findPropertyDescriptor("importance");
        this.svcgoalMaxTp = this.svcgoal.findPropertyDescriptor("maxTp");
        this.svcgoalMaxTpUnit = this.svcgoal.findPropertyDescriptor("maxTpUnit");
        this.channelChainCFEndpoint = this.channelChain.findPropertyDescriptor("CFEndpoint");
        this.channelFactoryClass = this.channel.findPropertyDescriptor("factoryClass");
        this.clusterIsReal = this.cluster.findPropertyDescriptor("isReal");
        this.clusterType = this.cluster.findPropertyDescriptor("type");
        this.clusterSpeedFactorOverrideSpec = this.cluster.findPropertyDescriptor("speedFactorOverrideSpec");
        this.clusterHttpSessionAffinityPolicyDescriptor = this.getPD(this.cluster, "HttpSessionAffinityPolicyDescriptor", ODCPropertyType.STRING, null, true);
        this.appIsWebSphere = this.application.findPropertyDescriptor("isWebSphere");
        this.appRoot = this.application.findPropertyDescriptor("root");
        this.appEdition = this.application.findPropertyDescriptor("edition");
        this.appState = this.application.findPropertyDescriptor("state");
        this.applicationIsSystem = this.application.findPropertyDescriptor("isSystem");
        this.appLastChangeTime = this.application.findPropertyDescriptor("lastChangeTime");
        this.appSessionAffinityCookie = this.application.findPropertyDescriptor("sessionAffinityCookie");
        this.appSessionOverride = this.application.findPropertyDescriptor("sessionOverride");
        this.ruleExpression = this.rule.findPropertyDescriptor("expression");
        this.ruleAction = this.rule.findPropertyDescriptor("action");
        this.SOAPAction = this.webServiceOperation.findPropertyDescriptor("SOAPAction");
        this.sessionPersistenceMode = this.server.findPropertyDescriptor("sessionPersistenceMode");
        this.transportIsActive = this.transport.findPropertyDescriptor("isActive");
        this.transportIsConfig = this.transport.findPropertyDescriptor("isConfig");
    }

    protected ODCPropertyDescriptor getPD(ODCNodeType oDCNodeType, String string, ODCPropertyType oDCPropertyType, Object object, boolean bl) throws ODCException {
        ODCPropertyDescriptor oDCPropertyDescriptor = oDCNodeType.getPropertyDescriptor(string);
        if (oDCPropertyDescriptor == null) {
            oDCPropertyDescriptor = oDCNodeType.createPropertyDescriptor(string, oDCPropertyType, object, bl);
        }
        return oDCPropertyDescriptor;
    }

    protected ODCNodeType getNT(String string) throws ODCException {
        ODCNodeType oDCNodeType = this.schema.getNodeType(string);
        if (oDCNodeType == null) {
            oDCNodeType = this.schema.createNodeType(string);
        }
        return oDCNodeType;
    }

    protected ODCEdgeType getET(ODCNodeType oDCNodeType, ODCNodeType oDCNodeType2, ODCEdgeCardinality oDCEdgeCardinality, boolean bl) throws ODCException {
        return this.schema.createEdgeType(oDCNodeType, oDCNodeType2, oDCEdgeCardinality, bl);
    }

    protected static void setInstance(ODCHelper oDCHelper) {
        instance = oDCHelper;
    }
}

