/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.profile;

import com.ibm.ws.install.configmanager.launcher.Launcher;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.WSProfileContext;
import com.ibm.ws.profile.bootstrap.WSProfileProperties;
import com.ibm.ws.profile.cli.output.OutputStreamHandler;
import com.ibm.ws.profile.registry.ProfileRegistryMarshaller;
import com.ibm.ws.profile.registry.ProfileRegistrySnippetMarshaller;
import com.ibm.ws.profile.utils.FileUtils;
import com.ibm.ws.profile.utils.PrereqTemplateUtils;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.ws.profile.utils.SystemPropertiesUtils;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.WSProfileTemplate;
import com.ibm.wsspi.profile.registry.Profile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class WSProfile {
    public static final int N_SUCCESS = 0;
    public static final int N_PARTIAL_SUCCESS = 2;
    public static final int N_FAILURE = 1;
    private static final String S_EMPTY = "";
    private static final String S_NO_PROFILE_EXISTS_AT_GIVEN_PATH_KEY = "WSProfile.WSProfile.noProfileExistsAtGivenPath";
    private static final String S_NO_PROFILE_TEMPLATE_EXISTS_AT_GIVEN_PATH_KEY = "WSProfile.WSProfile.noProfileTemplateExistsAtGivenPath";
    private static final String S_DIR_EXISTS_NOT_EMPTY_KEY = "WSProfile.WSProfile.dirExistsNotEmpty";
    private static final String S_PATH_EXISTS_NOT_DIR_KEY = "WSProfile.WSProfile.pathExistsNotDirectory";
    private static final String S_PATH_NOT_WRITABLE_KEY = "WSProfile.WSProfile.pathNotWritable";
    private static final String S_PROFILE_NAME_EXISTS_KEY = "WSProfile.WSProfile.profileNameExists";
    private static final String S_RESERVATION_TICKET_NOT_AVAILABLE_KEY = "WSProfile.WSProfile.reservationTicketNotAvailableKey";
    private static final String S_ZIP_READING_ERROR = "WSProfile.WSProfile.zipReadingError";
    private static final String S_INVALID_PROFILE_TEMPLATE_OPERATION_KEY = "WSProfile.WSProfile.invalidProfileTemplateOperation";
    private static final String S_CANNOT_REPEAT_TEMPLATE_OPERATION_KEY = "WSProfile.WSProfile.cannotRepeatTemplateOperation";
    private static final String S_INVALID_PROFILE_TEMPLATE_KEY = "WSProfile.WSProfile.invalideProfileTemplate";
    private static final String S_UNSATISFIED_PREREQS_KEY = "WSProfile.WSProfile.augmentPrereqNotMet";
    private static final Logger LOGGER = LoggerFactory.createLogger(WSProfile.class);
    private static final String S_CLASS_NAME = WSProfile.class.getName();

    public static int create(String string, File file, File file2, String string2, String string3, String string4) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "create");
        LOGGER.exiting(WSProfile.class.getName(), "create");
        return WSProfile.create(string, file, file2, string2, string3, string4, new HashMap());
    }

    public static int create(String string, File file, File file2, String string2, String string3, String string4, Map map) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "create");
        LOGGER.exiting(WSProfile.class.getName(), "create");
        return WSProfile.create(string, file, file2, string2, string3, string4, map, WSProfile.getRegistryFile());
    }

    public static int create(String string, File file, File file2, String string2, String string3, String string4, Map map, File file3) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "create");
        WSProfile.validateAProfileTemplateExistsAtTheGivenPath(file2);
        WSProfileTemplate wSProfileTemplate = WSProfile.getWSProfileTemplate(file2);
        if (wSProfileTemplate.getPrereqTemplatePath() != null) {
            try {
                Vector vector = PrereqTemplateUtils.getTemplatesForStackCreation(wSProfileTemplate);
                return WSProfile.stackCreate(string, file, vector, string2, string3, string4, map, file3);
            }
            catch (WSProfileException wSProfileException) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "create", "Exception caught while attempting to perform profile creation-augmenation");
                return 1;
            }
        }
        WSProfile.validateDirectoryIsWritable(file);
        WSProfile.throwExceptionIfTheGivenTargetProfilePathIsInvalidForCreate(file);
        WSProfile.throwExceptionIfTheGivenProfileIsAlreadyRegistered(string, file, file2, file3);
        WSProfile.validateProfileCreationTemplate(wSProfileTemplate);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "create", "Creating new profile " + string + " at " + file.getAbsolutePath() + ", using registry file: " + file3.getAbsolutePath());
        boolean bl = map.containsKey("isDefault");
        Profile profile = new Profile(string, file, file2, bl, true);
        int n = WSProfile.doCreate(profile, wSProfileTemplate, string2, string3, string4, map, file3);
        LOGGER.exiting(WSProfile.class.getName(), "create");
        return n;
    }

    private static int stackCreate(String string, File file, Vector vector, String string2, String string3, String string4, Map map, File file2) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "create");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "stackCreate", "Entering profile creation-augmentation mode. " + vector.size() + " WSProfile operations will be performed.");
        PrereqTemplateUtils.validateListForCreation(vector);
        File file3 = ((WSProfileTemplate)vector.get(0)).getProfileTemplatePath();
        WSProfile.validateDirectoryIsWritable(file);
        WSProfile.throwExceptionIfTheGivenTargetProfilePathIsInvalidForCreate(file);
        WSProfile.throwExceptionIfTheGivenProfileIsAlreadyRegistered(string, file, file3, file2);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "stackCreate", "Creating new profile " + string + " at " + file.getAbsolutePath() + ", using registry file: " + file2.getAbsolutePath());
        boolean bl = map.containsKey("isDefault");
        Profile profile = new Profile(string, file, file3, bl, true);
        Map map2 = WSProfile.replaceTemplatePathArg(map, file3.getAbsolutePath());
        int n = WSProfile.doCreate(profile, (WSProfileTemplate)vector.get(0), string2, string3, string4, map2, file2);
        int n2 = 1;
        while (n != 1 && n2 < vector.size()) {
            file3 = ((WSProfileTemplate)vector.get(n2)).getProfileTemplatePath();
            map2 = WSProfile.replaceTemplatePathArg(map, file3.getAbsolutePath());
            int n3 = WSProfile.doAugment(profile, (WSProfileTemplate)vector.get(n2), map2, file2);
            ++n2;
            if (n3 == 2 && n == 0) {
                n = 2;
            }
            if (n3 != 1 || n != 0 && n != 2) continue;
            n = 1;
        }
        if (n == 1) {
            WSProfile.unregister(string);
        }
        WSProfile.unsetReservationTicketFromRegistry(string, file2);
        LOGGER.exiting(WSProfile.class.getName(), "create");
        return n;
    }

    private static int doCreate(Profile profile, WSProfileTemplate wSProfileTemplate, String string, String string2, String string3, Map map, File file) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "doCreate");
        WSProfile.registerPreCreate(profile, file);
        String string4 = profile.getName();
        File file2 = profile.getPath();
        File file3 = wSProfileTemplate.getProfileTemplatePath();
        SystemPropertiesUtils.setJavaSystemPropertiesForConfigManagerBasedOnActionRegistry(string4, file2.getAbsolutePath(), file3.getAbsolutePath(), string, string2, string3, map, new File(file3.getAbsolutePath(), "actionRegistry.xml"));
        int n = Launcher.mainForInProcessCMTCallers();
        if (n == 1) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "doCreate", "Creation of profile " + string4 + " at path " + file2.getAbsolutePath() + " failed.");
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "doCreate", "Unregistering profile " + string4);
            WSProfile.unregister(string4, file, true);
        } else {
            if (n == 2) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "doCreate", "Creation of profile " + string4 + " at path " + file2.getAbsolutePath() + " was successful, but some non-fatal config actions failed.");
            }
            if (n == 0) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "doCreate", "Creation of profile " + string4 + " at path " + file2.getAbsolutePath() + " was successful.");
            }
            WSProfile.registerPostCreate(profile, file);
            WSProfile.unsetReservationTicketFromRegistry(string4, file);
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "doCreate", "Resetting the system properties to remove custom properties");
        SystemPropertiesUtils.resetJavaSystemPropertiesForConfigManagerProfileCreationOrDeletion(map);
        LOGGER.exiting(WSProfile.class.getName(), "doCreate");
        return n;
    }

    public static int augment(String string, File file, Map map) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "augment");
        LOGGER.exiting(WSProfile.class.getName(), "augment");
        return WSProfile.augment(string, file, map, WSProfile.getRegistryFile());
    }

    public static int augment(String string, File file, Map map, File file2) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "augment");
        Profile profile = WSProfile.getProfile(string, file2);
        File file3 = profile.getPath();
        WSProfileTemplate wSProfileTemplate = WSProfile.getWSProfileTemplate(file);
        if (wSProfileTemplate.getPrereqTemplatePath() != null) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "augment", "Prerequisite detected. Launching stack augment mode.");
            try {
                Vector vector = PrereqTemplateUtils.getTemplatesForStackAugmentation(wSProfileTemplate, WSProfile.getProfile(string));
                return WSProfile.stackAugment(string, vector, map, file2);
            }
            catch (WSProfileException wSProfileException) {
                OutputStreamHandler.println(ResourceBundleUtils.getLocaleString(S_UNSATISFIED_PREREQS_KEY));
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "augment", wSProfileException.getLocalizedMessage());
                return 1;
            }
        }
        WSProfile.setReservationTicketToRegistry(string, file2);
        try {
            WSProfile.validateAProfileTemplateExistsAtTheGivenPath(file);
            WSProfile.validateDirectoryIsWritable(file3);
            WSProfile.validateProfileAugmentationTemplate(profile, wSProfileTemplate);
        }
        catch (WSProfileException wSProfileException) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "augment", "Validation failed, unsetting reservation ticket in registry. The profile has not been modified.");
            WSProfile.unsetReservationTicketFromRegistry(string, file2);
            throw wSProfileException;
        }
        int n = WSProfile.doAugment(profile, wSProfileTemplate, map, file2);
        WSProfile.unsetReservationTicketFromRegistry(string, file2);
        LOGGER.exiting(WSProfile.class.getName(), "augment");
        return n;
    }

    private static int stackAugment(String string, Vector vector, Map map, File file) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "augment");
        WSProfile.setReservationTicketToRegistry(string, file);
        Profile profile = WSProfile.getProfile(string, file);
        File file2 = profile.getPath();
        int n = 0;
        int n2 = 0;
        File file3 = null;
        Map map2 = null;
        try {
            WSProfile.validateDirectoryIsWritable(file2);
            PrereqTemplateUtils.validateListForAugmentation(vector, profile);
        }
        catch (WSProfileException wSProfileException) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "stackAugment", "Validation failed, unsetting reservation ticket in registry. The profile has not been modified.");
            WSProfile.unsetReservationTicketFromRegistry(string, file);
            throw wSProfileException;
        }
        while (n2 != 1 && n < vector.size()) {
            file3 = ((WSProfileTemplate)vector.get(n)).getProfileTemplatePath();
            map2 = WSProfile.replaceTemplatePathArg(map, file3.getAbsolutePath());
            int n3 = WSProfile.doAugment(profile, (WSProfileTemplate)vector.get(n), map2, file);
            ++n;
            if (n3 == 2 && n2 == 0) {
                n2 = 2;
            }
            if (n3 != 1 || n2 != 0 && n2 != 2) continue;
            n2 = 1;
        }
        WSProfile.unsetReservationTicketFromRegistry(string, file);
        LOGGER.exiting(WSProfile.class.getName(), "augment");
        return n2;
    }

    private static int doAugment(Profile profile, WSProfileTemplate wSProfileTemplate, Map map, File file) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "doAugment");
        String string = profile.getName();
        File file2 = profile.getPath();
        File file3 = wSProfileTemplate.getProfileTemplatePath();
        SystemPropertiesUtils.setJavaSystemPropertiesForConfigManagerBasedOnActionRegistry(string, file2.getAbsolutePath(), file3.getAbsolutePath(), null, null, null, map, new File(file3.getAbsolutePath(), "actionRegistry.xml"));
        int n = Launcher.mainForInProcessCMTCallers();
        if (n == 1) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "doAugment", "Augmentation of profile " + string + " at path " + file2.getAbsolutePath() + " using profile template " + file3 + " failed.");
        }
        if (n == 2) {
            profile = WSProfile.getProfile(profile.getName());
            profile.addAugmentor(file3.getAbsolutePath());
            WSProfile.unregister(string, file);
            WSProfile.register(profile, file);
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "doAugment", "Augmentation of profile " + string + " at path " + file2.getAbsolutePath() + " using profile template " + file3 + " was successful, but some non-fatal config actions failed.");
        }
        if (n == 0) {
            profile = WSProfile.getProfile(profile.getName());
            profile.addAugmentor(file3.getAbsolutePath());
            WSProfile.unregister(string, file);
            WSProfile.register(profile, file);
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "doAugment", "Augmentation of profile " + string + " at path " + file2.getAbsolutePath() + " using profile template " + file3);
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "doAugment", "Resetting the system properties to remove custom properties");
        SystemPropertiesUtils.resetJavaSystemPropertiesForConfigManagerProfileCreationOrDeletion(map);
        LOGGER.exiting(WSProfile.class.getName(), "doAugment");
        return n;
    }

    public static int delete(String string, Map map) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "delete");
        LOGGER.exiting(WSProfile.class.getName(), "delete");
        return WSProfile.delete(string, map, WSProfile.getRegistryFile());
    }

    public static int delete(String string, Map map, File file) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "delete");
        WSProfile.setReservationTicketToRegistry(string, file);
        Profile profile = WSProfile.getProfile(string, file);
        File file2 = profile.getPath();
        File file3 = profile.getTemplate();
        List list = profile.getAugmentors();
        int n = 0;
        if (list.size() > 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "delete", string + " has " + list.size() + " augments applied. " + "Unaugmentation will be performed on each prior to deletion.");
            WSProfile.unsetReservationTicketFromRegistry(string, file);
            for (int i = 0; i < list.size(); ++i) {
                int n2 = WSProfile.unaugment(string, map, file);
                if (n2 == 2 && n == 0) {
                    n = 2;
                }
                if (n2 != 1 || n != 0 && n != 2) continue;
                n = 1;
            }
            WSProfile.setReservationTicketToRegistry(string, file);
            if (n == 1) {
                LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "delete", "Unaugmentation of " + string + " at " + file2.getAbsolutePath() + " failed.  Profile deletion will continue.");
            }
            if (n == 2) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "delete", "Unaugmentation of " + string + " at " + file2.getAbsolutePath() + " was successful, but some non-fatal config actions failed.  Profile deletion will continue.");
            }
            if (n == 0) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "delete", "Unaugmentation of " + string + " at " + file2.getAbsolutePath() + " was successful.  Profile deletion will continue.");
            }
        }
        try {
            WSProfile.validateDirectoryIsWritable(file2);
        }
        catch (WSProfileException wSProfileException) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "delete", "Validation failed, unsetting reservation ticket in registry. The profile has not been modified.");
            WSProfile.unsetReservationTicketFromRegistry(string, file);
            throw wSProfileException;
        }
        SystemPropertiesUtils.setJavaSystemPropertiesForConfigManagerBasedOnActionRegistry(string, file2.getAbsolutePath(), file3.getAbsolutePath(), null, null, null, map, new File(file3.getAbsolutePath(), "deleteRegistry.xml"));
        n = 1;
        if (WSProfile.unregister(string, file)) {
            n = Launcher.mainForInProcessCMTCallers();
        } else {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "delete", "The profile " + string + " was not unregistered.  Likely cause is that it was not found in the registry.");
        }
        if (n == 1) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "delete", "Deletion of " + string + " at " + file2.getAbsolutePath() + " failed.");
        }
        if (n == 2) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "delete", "Deletion of " + string + " at " + file2.getAbsolutePath() + " was successful, but some non-fatal config actions failed.");
        }
        if (n == 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "delete", "Deletion of " + string + " at " + file2.getAbsolutePath() + " was successful.");
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "delete", "Resetting the system properties to remove custom properties");
        SystemPropertiesUtils.resetJavaSystemPropertiesForConfigManagerProfileCreationOrDeletion(map);
        LOGGER.exiting(WSProfile.class.getName(), "delete");
        return n;
    }

    public static int edit(String string, Map map) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "edit");
        LOGGER.exiting(WSProfile.class.getName(), "edit");
        return WSProfile.edit(string, map, WSProfile.getRegistryFile());
    }

    public static int edit(String string, Map map, File file) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "edit");
        WSProfile.setReservationTicketToRegistry(string, file);
        Profile profile = WSProfile.getProfile(string, file);
        File file2 = profile.getPath();
        File file3 = profile.getTemplate();
        try {
            WSProfile.validateAProfileTemplateExistsAtTheGivenPath(file3);
            WSProfile.validateDirectoryIsWritable(file2);
        }
        catch (WSProfileException wSProfileException) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "edit", "Validation failed, unsetting reservation ticket in registry. The profile has not been modified.");
            WSProfile.unsetReservationTicketFromRegistry(string, file);
            throw wSProfileException;
        }
        SystemPropertiesUtils.setJavaSystemPropertiesForConfigManagerBasedOnActionRegistry(string, file2.getAbsolutePath(), file3.getAbsolutePath(), null, null, null, map, new File(file3.getAbsolutePath(), "editRegistry.xml"));
        int n = Launcher.mainForInProcessCMTCallers();
        if (n == 1) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "edit", "Edit of " + string + " at " + file2.getAbsolutePath() + " failed.");
        }
        if (n == 2) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "edit", "Edit of " + string + " at " + file2.getAbsolutePath() + " was successful, but some non-fatal config actions failed.");
        }
        if (n == 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "edit", "Edit of " + string + " at " + file2.getAbsolutePath() + " was successful.");
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "edit", "Resetting the system properties to remove custom properties");
        SystemPropertiesUtils.resetJavaSystemPropertiesForConfigManagerProfileCreationOrDeletion(map);
        WSProfile.unsetReservationTicketFromRegistry(string, file);
        LOGGER.exiting(WSProfile.class.getName(), "edit");
        return n;
    }

    public static int list(String string, Map map) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "list");
        LOGGER.exiting(WSProfile.class.getName(), "list");
        return WSProfile.list(string, map, WSProfile.getRegistryFile());
    }

    public static int list(String string, Map map, File file) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "list");
        Profile profile = WSProfile.getProfile(string, file);
        File file2 = profile.getPath();
        File file3 = profile.getTemplate();
        WSProfile.validateDirectoryIsWritable(file2);
        SystemPropertiesUtils.setJavaSystemPropertiesForConfigManagerBasedOnActionRegistry(string, file2.getAbsolutePath(), file3.getAbsolutePath(), null, null, null, map, new File(file3.getAbsolutePath(), "listRegistry.xml"));
        int n = Launcher.mainForInProcessCMTCallers();
        if (n == 1) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "list", "List of " + string + " details at " + file2.getAbsolutePath() + " failed.");
        }
        if (n == 2) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "list", "List of " + string + " details at " + file2.getAbsolutePath() + " was successful, but some non-fatal config actions failed.");
        }
        if (n == 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "list", "List of " + string + " details at " + file2.getAbsolutePath() + " was successful.");
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "list", "Resetting the system properties to remove custom properties");
        SystemPropertiesUtils.resetJavaSystemPropertiesForConfigManagerProfileCreationOrDeletion(map);
        LOGGER.exiting(WSProfile.class.getName(), "list");
        return n;
    }

    public static int unlock(String string, File file) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "unlock");
        int n = 0;
        try {
            WSProfile.getProfile(string, file);
            WSProfile.unsetReservationTicketFromRegistry(string, file);
        }
        catch (WSProfileException wSProfileException) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "unlock", "Failed to unset reservation ticket in registry. The profile has not been modified.");
            n = 1;
            throw wSProfileException;
        }
        if (n == 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "unlock", "Unlocking of " + string + " was successful.");
        }
        LOGGER.exiting(WSProfile.class.getName(), "unlock");
        return n;
    }

    public static int unaugment(String string, Map map) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "unaugment");
        LOGGER.exiting(WSProfile.class.getName(), "unaugment");
        return WSProfile.unaugment(string, map, WSProfile.getRegistryFile());
    }

    public static int unaugment(String string, Map map, File file) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "unaugment");
        int n = 0;
        WSProfile.setReservationTicketToRegistry(string, file);
        Profile profile = WSProfile.getProfile(string, file);
        File file2 = profile.getPath();
        try {
            WSProfile.validateDirectoryIsWritable(file2);
        }
        catch (WSProfileException wSProfileException) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "unaugment", "Validation failed, unsetting reservation ticket in registry. The profile has not been modified.");
            WSProfile.unsetReservationTicketFromRegistry(string, file);
            throw wSProfileException;
        }
        if (profile.getAugmentors().size() == 0) {
            WSProfile.unsetReservationTicketFromRegistry(string, file);
            return 0;
        }
        n = profile.getAugmentors().size() - 1;
        String string2 = (String)profile.getAugmentors().get(n);
        File file3 = new File(string2);
        int n2 = WSProfile.doUnaugment(profile, file3, map, file);
        WSProfile.unsetReservationTicketFromRegistry(string, file);
        LOGGER.exiting(WSProfile.class.getName(), "unaugment");
        return n2;
    }

    public static int unaugment(String string, File file, Map map, File file2) throws WSProfileException {
        int n;
        Object object;
        LOGGER.entering(WSProfile.class.getName(), "unaugment");
        Profile profile = WSProfile.getProfile(string, file2);
        Vector vector = FileUtils.convertStringListToFileVector(profile.getAugmentors());
        try {
            for (int i = 0; i < vector.size(); ++i) {
                object = (File)vector.get(i);
                if (!((File)object).getCanonicalFile().equals(file.getCanonicalFile())) continue;
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "unaugment", "Replacing the unaugment template path " + file + " with " + object);
                file = object;
            }
        }
        catch (IOException iOException) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "unaugment", "Failed to find the corresponding template path in the registry. Trying to use unmodified template path.");
        }
        Vector vector2 = new Vector();
        object = null;
        boolean bl = false;
        WSProfile.setReservationTicketToRegistry(string, file2);
        try {
            WSProfile.validateDirectoryIsWritable(profile.getPath());
        }
        catch (WSProfileException wSProfileException) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "unaugment", "Validation failed, unsetting reservation ticket in registry. The profile has not been modified.");
            WSProfile.unsetReservationTicketFromRegistry(string, file2);
            throw wSProfileException;
        }
        if (!vector.contains(file)) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "unaugment", file + " is not an augmentor to profile " + string + ". Profile unaugmentation cannot proceed.");
            WSProfile.unsetReservationTicketFromRegistry(string, file2);
            LOGGER.exiting(WSProfile.class.getName(), "unaugment");
            return 1;
        }
        for (n = 0; n < vector.size(); ++n) {
            try {
                object = new WSProfileTemplate((File)vector.get(n));
                if (((WSProfileTemplate)object).getPrereqTemplatePath() == null || !((WSProfileTemplate)object).getPrereqTemplatePath().getCanonicalFile().equals(file.getCanonicalFile()) || ((WSProfileTemplate)object).getProfileTemplatePath().getCanonicalFile().equals(file.getCanonicalFile())) continue;
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "unaugment", file + " is found to be a prerequisite " + "of " + ((WSProfileTemplate)object).getProfileTemplatePath() + ". Unaugmentation cannot proceed.");
                WSProfile.unsetReservationTicketFromRegistry(string, file2);
                LOGGER.exiting(WSProfile.class.getName(), "unaugment");
                return 1;
            }
            catch (IOException iOException) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "unaugment", "An IOException occured while trying to find prerequisite templates using canonical form. Trying resolve prerequisites using a standard form.");
                object = new WSProfileTemplate((File)vector.get(n));
                if (!((WSProfileTemplate)object).getPrereqTemplatePath().equals(file) || ((WSProfileTemplate)object).getProfileTemplatePath().equals(file)) continue;
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "unaugment", file + " is found to be a prerequisite " + "of " + ((WSProfileTemplate)object).getProfileTemplatePath() + ". Unaugmentation cannot proceed.");
                WSProfile.unsetReservationTicketFromRegistry(string, file2);
                LOGGER.exiting(WSProfile.class.getName(), "unaugment");
                return 1;
            }
            catch (WSProfileException wSProfileException) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "unaugment", "The augmentor " + (File)vector.get(n) + " cannot be found on the filesystem, so the prerequisite for this" + " augmentor cannot be determined. Unaugmentation cannot" + " continue with " + file);
                WSProfile.unsetReservationTicketFromRegistry(string, file2);
                LOGGER.exiting(WSProfile.class.getName(), "unaugment");
                return 1;
            }
        }
        n = WSProfile.doUnaugment(profile, file, map, file2);
        WSProfile.unsetReservationTicketFromRegistry(string, file2);
        LOGGER.exiting(WSProfile.class.getName(), "unaugment");
        return n;
    }

    private static int doUnaugment(Profile profile, File file, Map map, File file2) throws WSProfileException {
        int n;
        LOGGER.entering(WSProfile.class.getName(), "doUnaugment");
        String string = profile.getName();
        File file3 = profile.getPath();
        String string2 = file.getAbsolutePath();
        SystemPropertiesUtils.setJavaSystemPropertiesForConfigManagerBasedOnActionRegistry(string, file3.getAbsolutePath(), file.getAbsolutePath(), null, null, null, map, new File(file.getAbsolutePath(), "deleteRegistry.xml"));
        List list = profile.getAugmentors();
        profile.removeAugmentor(string2);
        List list2 = profile.getAugmentors();
        if (list.size() == list2.size() && list.size() != 0) {
            for (n = 0; n < list2.size(); ++n) {
                String string3 = (String)list2.get(n);
                if (!string2.equalsIgnoreCase(string3)) continue;
                profile.removeAugmentor(string3);
                break;
            }
        }
        if ((n = Launcher.mainForInProcessCMTCallers()) == 1) {
            WSProfile.unregister(string, file2);
            WSProfile.register(profile, file2);
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "doUnaugment", "Unaugmentation of " + string + " at " + file3.getAbsolutePath() + " failed.");
        }
        if (n == 2) {
            WSProfile.unregister(string, file2);
            WSProfile.register(profile, file2);
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "doUnaugment", "Unaugmentation of " + string + " at " + file3.getAbsolutePath() + " was successful, but some non-fatal config actions failed.");
        }
        if (n == 0) {
            WSProfile.unregister(string, file2);
            WSProfile.register(profile, file2);
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "doUnaugment", "Unaugmentation of " + string + " at " + file3.getAbsolutePath() + " was successful.");
        }
        LOGGER.exiting(WSProfile.class.getName(), "doUnaugment");
        return n;
    }

    public static int deleteAll(Map map) throws WSProfileException {
        return WSProfile.deleteAll(map, WSProfile.getRegistryFile());
    }

    public static int deleteAll(Map map, File file) throws WSProfileException {
        List list = WSProfile.listProfileNames(file);
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i).toString();
            int n2 = WSProfile.delete(string, map, file);
            if (n2 == 2 && n == 0) {
                n = 2;
            }
            if (n2 != 1 || n != 0 && n != 2) continue;
            n = 1;
        }
        return n;
    }

    public static int backup(String string, Map map) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "backup");
        LOGGER.exiting(WSProfile.class.getName(), "backup");
        return WSProfile.backup(string, map, WSProfile.getRegistryFile());
    }

    public static int backup(String string, Map map, File file) throws WSProfileException {
        File file2;
        LOGGER.entering(WSProfile.class.getName(), "backup");
        WSProfile.setReservationTicketToRegistry(string, file);
        Profile profile = WSProfile.getProfile(string, file);
        File file3 = profile.getPath();
        File file4 = profile.getTemplate();
        try {
            WSProfile.validateDirectoryIsWritable(profile.getPath());
        }
        catch (WSProfileException wSProfileException) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "backup", "Validation failed, unsetting reservation ticket in registry. The profile has not been modified.");
            WSProfile.unsetReservationTicketFromRegistry(string, file);
            throw wSProfileException;
        }
        int n = 1;
        String string2 = map.get("backupFile").toString();
        string2 = string2.substring(1, string2.length() - 1);
        File file5 = new File(string2);
        try {
            file2 = new File(file5.getParent());
        }
        catch (NullPointerException nullPointerException) {
            file2 = null;
        }
        boolean bl = false;
        if (file2 != null) {
            bl = file2.exists();
        }
        if (!bl && file2 != null) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "backup", "The path " + file2.getAbsolutePath() + " does not exist.");
            bl = file2.mkdirs();
            if (bl) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "backup", "The path " + file2.getAbsolutePath() + " was successfully created.");
            }
        }
        if (file2 == null) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "backup", "The path " + string2 + " is not valid, ensure an absolute file path is being used.");
            n = 1;
        } else if (bl) {
            ProfileRegistrySnippetMarshaller.writeProfileToRegistrySnippetFile(profile, new File(profile.getPath(), "profileRegistrySnippet.xml"));
            SystemPropertiesUtils.setJavaSystemPropertiesForConfigManagerBasedOnActionRegistry(string, file3.getAbsolutePath(), file4.getAbsolutePath(), null, null, null, map, new File(profile.getTemplate().getAbsolutePath(), "backupRegistry.xml"));
            n = Launcher.mainForInProcessCMTCallers();
        } else {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "backup", "The path " + file2.getAbsolutePath() + " could not be created.");
            n = 1;
        }
        if (n == 1) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "backup", "Backup of profile " + string + " failed.");
        }
        if (n == 2) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "backup", "Backup of profile " + string + " was succssful," + "but some non-fatal config actions failed.");
        }
        if (n == 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "backup", "Backup of profile " + string + " was succssful.");
        }
        ProfileRegistrySnippetMarshaller.deleteProfileRegistrySnippet(new File(profile.getPath(), "profileRegistrySnippet.xml"));
        WSProfile.unsetReservationTicketFromRegistry(string, file);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "backup", "Resetting the system properties to remove custom properties");
        SystemPropertiesUtils.resetJavaSystemPropertiesForConfigManagerProfileCreationOrDeletion(map);
        LOGGER.exiting(WSProfile.class.getName(), "backup");
        return n;
    }

    public static int restore(File file, Map map) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "restore");
        LOGGER.exiting(WSProfile.class.getName(), "restore");
        return WSProfile.restore(file, map, WSProfile.getRegistryFile());
    }

    public static int restore(File file, Map map, File file2) throws WSProfileException {
        InputStream inputStream;
        Object object;
        LOGGER.entering(WSProfile.class.getName(), "restore");
        try {
            object = new ZipFile(file);
            inputStream = ((ZipFile)object).getInputStream(((ZipFile)object).getEntry("profileRegistrySnippet.xml"));
        }
        catch (ZipException zipException) {
            LogUtils.logException(LOGGER, zipException);
            throw new WSProfileException(ResourceBundleUtils.getLocaleString(S_ZIP_READING_ERROR, file.getAbsolutePath()));
        }
        catch (IOException iOException) {
            LogUtils.logException(LOGGER, iOException);
            throw new WSProfileException(ResourceBundleUtils.getLocaleString(S_ZIP_READING_ERROR, file.getAbsolutePath()));
        }
        object = ProfileRegistrySnippetMarshaller.readProfileFromRegistrySnippetInputStream(inputStream);
        String string = ((Profile)object).getName();
        File file3 = ((Profile)object).getPath();
        File file4 = ((Profile)object).getTemplate();
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "restore", " The profile to be restored is: " + ((Profile)object).getName());
        ProfileRegistryMarshaller profileRegistryMarshaller = new ProfileRegistryMarshaller(file2.getAbsolutePath());
        WSProfile.validateAProfileTemplateExistsAtTheGivenPath(file4);
        WSProfile.validateDirectoryIsWritable(file3);
        WSProfile.throwExceptionIfTheGivenTargetProfilePathIsInvalidForCreate(file3);
        WSProfile.throwExceptionIfTheGivenProfileIsAlreadyRegistered(string, file3, file4, file2);
        List list = ((Profile)object).getAugmentors();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            File file5 = new File((String)iterator.next());
            WSProfile.validateAProfileTemplateExistsAtTheGivenPath(file5);
            WSProfileTemplate wSProfileTemplate = new WSProfileTemplate(file5);
        }
        ((Profile)object).setAReservationTicket(true);
        ((Profile)object).setDefault(false);
        WSProfile.register((Profile)object, file2);
        SystemPropertiesUtils.setJavaSystemPropertiesForConfigManagerBasedOnActionRegistry(string, file3.getAbsolutePath(), file4.getAbsolutePath(), null, null, null, map, new File(file4.getAbsolutePath(), "restoreRegistry.xml"));
        int n = Launcher.mainForInProcessCMTCallers();
        if (n == 1) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "restore", "Profile restore from backup file " + file.getAbsolutePath() + " failed.");
            WSProfile.unregister(string);
        }
        if (n == 2) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "restore", "Profile restore from backup file " + file.getAbsolutePath() + " was successful, " + "but some non-fatal config actions failed.");
        }
        if (n == 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "restore", "Profile restore from backup file " + file.getAbsolutePath() + " was successful. ");
        }
        ProfileRegistrySnippetMarshaller.deleteProfileRegistrySnippet(new File(file3, "profileRegistrySnippet.xml"));
        WSProfile.unsetReservationTicketFromRegistry(string, file2);
        LOGGER.exiting(WSProfile.class.getName(), "restore");
        return n;
    }

    public static boolean unregister(String string) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "unregister");
        LOGGER.exiting(WSProfile.class.getName(), "unregister");
        return WSProfile.unregister(string, WSProfile.getRegistryFile());
    }

    public static boolean unregister(String string, File file) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "unregister");
        Profile profile = WSProfile.getProfile(string, file);
        boolean bl = WSProfile.unregister(profile, file);
        LOGGER.exiting(WSProfile.class.getName(), "unregister");
        return bl;
    }

    public static boolean unregister(Profile profile, File file) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "unregister");
        ProfileRegistryMarshaller profileRegistryMarshaller = new ProfileRegistryMarshaller(file.getAbsolutePath());
        boolean bl = profileRegistryMarshaller.deleteProfileFromRegistry(profile);
        LOGGER.exiting(WSProfile.class.getName(), "unregister");
        return bl;
    }

    public static boolean unregister(String string, File file, boolean bl) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "unregister");
        Profile profile = WSProfile.getProfile(string, file, bl);
        boolean bl2 = WSProfile.unregister(profile, file);
        LOGGER.exiting(WSProfile.class.getName(), "unregister");
        return bl2;
    }

    public static void register(String string, File file, File file2) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "register");
        LOGGER.exiting(WSProfile.class.getName(), "register");
        WSProfile.register(string, file, file2, WSProfile.getRegistryFile());
    }

    public static void register(String string, File file, File file2, File file3) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "register");
        WSProfile.register(string, file, file2, file3, false);
        LOGGER.exiting(WSProfile.class.getName(), "register");
    }

    public static void register(String string, File file, File file2, File file3, boolean bl) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "register");
        Profile profile = new Profile(string, file, file2, bl);
        WSProfile.register(profile, file3);
        LOGGER.exiting(WSProfile.class.getName(), "register");
    }

    public static void register(String string, File file, File file2, File file3, boolean bl, boolean bl2) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "register");
        Profile profile = new Profile(string, file, file2, bl, bl2);
        WSProfile.register(profile, file3);
        LOGGER.exiting(WSProfile.class.getName(), "register");
    }

    public static void register(Profile profile, File file) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "register");
        WSProfile.validateAProfileTemplateExistsAtTheGivenPath(profile.getTemplate());
        ProfileRegistryMarshaller profileRegistryMarshaller = new ProfileRegistryMarshaller(file.getAbsolutePath());
        profileRegistryMarshaller.addProfileToRegistry(profile);
        LOGGER.exiting(WSProfile.class.getName(), "register");
    }

    public static void registerPreCreate(Profile profile, File file) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "registerPreCreate");
        WSProfile.validateAProfileTemplateExistsAtTheGivenPath(profile.getTemplate());
        ProfileRegistryMarshaller profileRegistryMarshaller = new ProfileRegistryMarshaller(file.getAbsolutePath());
        profileRegistryMarshaller.preCreateAddProfileToRegistry(profile);
        LOGGER.exiting(WSProfile.class.getName(), "registerPreCreate");
    }

    public static void registerPostCreate(Profile profile, File file) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "registerPostCreate");
        WSProfile.validateAProfileTemplateExistsAtTheGivenPath(profile.getTemplate());
        ProfileRegistryMarshaller profileRegistryMarshaller = new ProfileRegistryMarshaller(file.getAbsolutePath());
        profileRegistryMarshaller.postCreateAddProfileToRegistry(profile);
        LOGGER.exiting(WSProfile.class.getName(), "registerPostCreate");
    }

    public static List listAllProfileNames() throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "listAllProfileNames");
        LOGGER.exiting(WSProfile.class.getName(), "listAllProfileNames");
        return WSProfile.listAllProfileNames(WSProfile.getRegistryFile());
    }

    public static List listAllProfileNames(File file) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "listAllProfileNames");
        ProfileRegistryMarshaller profileRegistryMarshaller = new ProfileRegistryMarshaller(file.getAbsolutePath());
        List list = profileRegistryMarshaller.listAllProfilesInRegistry();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < list.size(); ++i) {
            Profile profile = (Profile)list.get(i);
            vector.add(profile.getName());
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "listAllProfileNames", "Profiles found: " + vector);
        LOGGER.exiting(WSProfile.class.getName(), "listAllProfileNames");
        return vector;
    }

    public static List listProfileNames() throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "listProfileNames");
        LOGGER.exiting(WSProfile.class.getName(), "listProfileNames");
        return WSProfile.listProfileNames(WSProfile.getRegistryFile());
    }

    public static List listProfileNames(File file) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "listProfileNames");
        ProfileRegistryMarshaller profileRegistryMarshaller = new ProfileRegistryMarshaller(file.getAbsolutePath());
        if (profileRegistryMarshaller.isProfileRegistryEmpty()) {
            return new Vector();
        }
        List list = profileRegistryMarshaller.listProfilesInRegistry();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < list.size(); ++i) {
            Profile profile = (Profile)list.get(i);
            vector.add(profile.getName());
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "listProfileNames", "Profiles found: " + vector);
        LOGGER.exiting(WSProfile.class.getName(), "listProfileNames");
        return vector;
    }

    public static List updateRegistry() throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "updateRegistry");
        LOGGER.exiting(WSProfile.class.getName(), "updateRegistry");
        return WSProfile.updateRegistry(WSProfile.getRegistryFile());
    }

    public static List updateRegistry(File file) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "updateRegistry");
        ProfileRegistryMarshaller profileRegistryMarshaller = new ProfileRegistryMarshaller(file.getAbsolutePath());
        List list = profileRegistryMarshaller.purgeInvalidEntries();
        profileRegistryMarshaller.ensureThereIsOnlyASingleDefaultProfileInTheProfileRegistry();
        LOGGER.exiting(WSProfile.class.getName(), "updateRegistry");
        return list;
    }

    public static List updateAndBackupRegistry(File file) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "updateAndBackupRegistry");
        LOGGER.exiting(WSProfile.class.getName(), "updateAndBackupRegistry");
        return WSProfile.updateAndBackupRegistry(file, WSProfile.getRegistryFile());
    }

    public static List updateAndBackupRegistry(File file, File file2) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "updateAndBackupRegistry");
        List list = WSProfile.updateRegistry(file2);
        try {
            FileUtils.copyFile(file2, file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            LogUtils.logException(LOGGER, fileNotFoundException);
            throw new WSProfileException(fileNotFoundException.getMessage(), fileNotFoundException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            LogUtils.logException(LOGGER, iOException);
            throw new WSProfileException(iOException.getMessage(), iOException.getLocalizedMessage());
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "updateAndBackupRegistry", "List of invalid profiles: " + list);
        LOGGER.exiting(WSProfile.class.getName(), "updateAndBackupRegistry");
        return list;
    }

    public static List validateRegistry() throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "validateRegistry");
        LOGGER.exiting(WSProfile.class.getName(), "validateRegistry");
        return WSProfile.validateRegistry(WSProfile.getRegistryFile());
    }

    public static List validateRegistry(File file) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "validateRegistry");
        ProfileRegistryMarshaller profileRegistryMarshaller = new ProfileRegistryMarshaller(file.getAbsolutePath());
        LOGGER.exiting(WSProfile.class.getName(), "validateRegistry");
        return profileRegistryMarshaller.getInvalidProfiles();
    }

    public static String getProfileName(File file) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getProfileName");
        LOGGER.exiting(WSProfile.class.getName(), "getProfileName");
        return WSProfile.getProfileName(file, WSProfile.getRegistryFile());
    }

    public static String getProfileName(File file, File file2) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getProfileName");
        ProfileRegistryMarshaller profileRegistryMarshaller = new ProfileRegistryMarshaller(file2.getAbsolutePath());
        LOGGER.exiting(WSProfile.class.getName(), "getProfileName");
        return profileRegistryMarshaller.getProfile(file).getName();
    }

    public static void setProfileName(String string, String string2) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "setProfileName");
        WSProfile.setProfileName(string, string2, WSProfile.getRegistryFile());
        LOGGER.exiting(WSProfile.class.getName(), "setProfileName");
    }

    public static void setProfileName(String string, String string2, File file) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "setProfileName");
        Profile profile = WSProfile.getProfile(string, file);
        WSProfile.throwExceptionIfTheGivenProfileNameIsAlreadyRegistered(string2, file);
        ProfileRegistryMarshaller profileRegistryMarshaller = new ProfileRegistryMarshaller(file.getAbsolutePath());
        profileRegistryMarshaller.deleteProfileFromRegistry(profile);
        profile.setName(string2);
        profileRegistryMarshaller.addProfileToRegistry(profile);
        LOGGER.exiting(WSProfile.class.getName(), "setProfileName");
    }

    public static File getProfileLocation(String string) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getProfileLocation");
        LOGGER.exiting(WSProfile.class.getName(), "getProfileLocation");
        return WSProfile.getProfileLocation(string, WSProfile.getRegistryFile());
    }

    public static File getProfileLocation(String string, File file) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getProfileLocation");
        LOGGER.exiting(WSProfile.class.getName(), "getProfileLocation");
        return WSProfile.getProfile(string, file).getPath();
    }

    public static void setProfileLocation(String string, File file) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "setProfileLocation");
        WSProfile.setProfileLocation(string, file, WSProfile.getRegistryFile());
        LOGGER.exiting(WSProfile.class.getName(), "setProfileLocation");
    }

    public static void setProfileLocation(String string, File file, File file2) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "setProfileLocation");
        WSProfile.validateDirectoryIsWritable(file);
        WSProfile.throwExceptionIfTheGivenTargetProfilePathIsInvalidForCreate(file);
        Profile profile = WSProfile.getProfile(string, file2);
        ProfileRegistryMarshaller profileRegistryMarshaller = new ProfileRegistryMarshaller(file2.getAbsolutePath());
        profileRegistryMarshaller.deleteProfileFromRegistry(profile);
        profile.setPath(file);
        profileRegistryMarshaller.addProfileToRegistry(profile);
        LOGGER.exiting(WSProfile.class.getName(), "setProfileLocation");
    }

    public static File getProfileTemplateLocation(String string) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getProfileTemplateLocation");
        LOGGER.exiting(WSProfile.class.getName(), "getProfileTemplateLocation");
        return WSProfile.getProfileTemplateLocation(string, WSProfile.getRegistryFile());
    }

    public static File getProfileTemplateLocation(String string, File file) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getProfileTemplateLocation");
        LOGGER.exiting(WSProfile.class.getName(), "getProfileTemplateLocation");
        return WSProfile.getProfile(string, file).getTemplate();
    }

    public static List getProfileList() throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getProfileList");
        LOGGER.exiting(WSProfile.class.getName(), "getProfileList");
        return WSProfile.getProfileList(WSProfile.getRegistryFile());
    }

    public static List getProfileList(File file) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getProfileList");
        ProfileRegistryMarshaller profileRegistryMarshaller = new ProfileRegistryMarshaller(file.getAbsolutePath());
        LOGGER.exiting(WSProfile.class.getName(), "getProfileList");
        return profileRegistryMarshaller.listProfilesInRegistry();
    }

    public static void setDefaultProfile(String string) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "setDefaultProfile");
        WSProfile.setDefaultProfile(string, WSProfile.getRegistryFile());
        LOGGER.exiting(WSProfile.class.getName(), "setDefaultProfile");
    }

    public static void setDefaultProfile(String string, File file) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "setDefaultProfile");
        Profile profile = WSProfile.getProfile(string, file);
        ProfileRegistryMarshaller profileRegistryMarshaller = new ProfileRegistryMarshaller(file.getAbsolutePath());
        profileRegistryMarshaller.markProfileDefault(profile);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "setDefaultProfile", "Default profile has been reset to: " + string);
        LOGGER.exiting(WSProfile.class.getName(), "setDefaultProfile");
    }

    public static Profile getDefaultProfile() throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getDefaultProfile");
        LOGGER.exiting(WSProfile.class.getName(), "getDefaultProfile");
        return WSProfile.getDefaultProfile(WSProfile.getRegistryFile());
    }

    public static Profile getDefaultProfile(File file) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getDefaultProfile");
        ProfileRegistryMarshaller profileRegistryMarshaller = new ProfileRegistryMarshaller(file.getAbsolutePath());
        LOGGER.exiting(WSProfile.class.getName(), "getDefaultProfile");
        return profileRegistryMarshaller.getDefaultProfile();
    }

    public static Profile getProfile(String string) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getProfile");
        LOGGER.exiting(WSProfile.class.getName(), "getProfile");
        return WSProfile.getProfile(string, WSProfile.getRegistryFile());
    }

    public static Profile getProfile(String string, File file) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getProfile");
        LOGGER.exiting(WSProfile.class.getName(), "getProfile");
        return WSProfile.getProfile(string, file, false);
    }

    public static Profile getProfile(String string, File file, boolean bl) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getProfile");
        ProfileRegistryMarshaller profileRegistryMarshaller = new ProfileRegistryMarshaller(file.getAbsolutePath());
        LOGGER.exiting(WSProfile.class.getName(), "getProfile");
        if (!bl) {
            return profileRegistryMarshaller.getProfile(string);
        }
        return profileRegistryMarshaller.getProfile(string, true);
    }

    public static File getRegistryFile() throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getRegistryFile");
        String string = null;
        string = System.getProperty("WAS_HOME");
        if (string == null) {
            string = System.getProperty("was.install.root");
        }
        LOGGER.exiting(WSProfile.class.getName(), "getRegistryFile");
        return WSProfile.getRegistryFile(string);
    }

    public static File getRegistryFile(String string) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getRegistryFile");
        WSProfileContext wSProfileContext = new WSProfileContext();
        try {
            wSProfileContext.saveCurrentContext();
            wSProfileContext.switchContext(string);
            File file = new File(new WSProfileProperties().getProperty("WS_PROFILE_REGISTRY"));
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getRegistryFile", "Return profile registry location as: " + file.getAbsolutePath());
            LOGGER.exiting(WSProfile.class.getName(), "getRegistryFile");
            File file2 = file;
            return file2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            LogUtils.logException(LOGGER, fileNotFoundException);
            throw new WSProfileException(fileNotFoundException.getMessage(), fileNotFoundException.getLocalizedMessage(), fileNotFoundException);
        }
        catch (IOException iOException) {
            LogUtils.logException(LOGGER, iOException);
            throw new WSProfileException(iOException.getMessage(), iOException.getLocalizedMessage());
        }
        finally {
            if (wSProfileContext != null) {
                wSProfileContext.restoreSavedContext();
            }
        }
    }

    public static List getAllAugmentationProfileTemplate(File file) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getAllAugmentationProfileTemplates");
        LOGGER.exiting(WSProfile.class.getName(), "getAllAugmentationProfileTemplates");
        return WSProfile.getAllAugmentationProfileTemplates(WSProfile.getProfileName(file));
    }

    public static List getAllAugmentationProfileTemplates(String string) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getAllAugmentationProfileTemplates");
        LOGGER.exiting(WSProfile.class.getName(), "getAllAugmentationProfileTemplates");
        return WSProfile.getAllAugmentationProfileTemplates(WSProfile.getProfile(string));
    }

    public static List getAllAugmentationProfileTemplates(Profile profile) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getAllAugmentationProfileTemplates");
        List list = profile.getAugmentors();
        Vector<WSProfileTemplate> vector = new Vector<WSProfileTemplate>();
        for (int i = 0; i < list.size(); ++i) {
            File file = new File((String)list.get(i));
            vector.add(new WSProfileTemplate(file));
        }
        LOGGER.exiting(WSProfile.class.getName(), "getAllAugmentationProfileTemplates");
        return vector;
    }

    public static List getAllProfileTemplates(File file) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getAllProfileTemplates");
        LOGGER.exiting(WSProfile.class.getName(), "getAllProfileTemplates");
        return WSProfile.getAllProfileTemplates(WSProfile.getProfileName(file));
    }

    public static List getAllProfileTemplates(String string) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getAllProfileTemplates");
        LOGGER.exiting(WSProfile.class.getName(), "getAllProfileTemplates");
        return WSProfile.getAllProfileTemplates(WSProfile.getProfile(string));
    }

    public static List getAllProfileTemplates(Profile profile) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getAllProfileTemplates");
        List list = WSProfile.getAllAugmentationProfileTemplates(profile);
        list.add(WSProfile.getCreateProfileTemplate(profile));
        LOGGER.exiting(WSProfile.class.getName(), "getAllProfileTemplates");
        return list;
    }

    public static WSProfileTemplate getCreateProfileTemplate(File file) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getCreateProfileTemplate");
        LOGGER.exiting(WSProfile.class.getName(), "getCreateProfileTemplate");
        return WSProfile.getCreateProfileTemplate(WSProfile.getProfileName(file));
    }

    public static WSProfileTemplate getCreateProfileTemplate(String string) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getCreateProfileTemplate");
        LOGGER.exiting(WSProfile.class.getName(), "getCreateProfileTemplate");
        return WSProfile.getCreateProfileTemplate(WSProfile.getProfile(string));
    }

    public static WSProfileTemplate getCreateProfileTemplate(Profile profile) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getCreateProfileTemplate");
        LOGGER.exiting(WSProfile.class.getName(), "getCreateProfileTemplate");
        return new WSProfileTemplate(profile.getTemplate());
    }

    private static void throwExceptionIfTheGivenTargetProfilePathIsInvalidForCreate(File file) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "throwExceptionIfTheGivenTargetProfilePathIsInvalidForCreate");
        if (file.exists()) {
            if (!file.isDirectory()) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "throwExceptionIfTheGivenTargetProfilePathIsInvalidForCreate", "Profile path " + file.toString() + " is an existing file");
                throw new WSProfileException(ResourceBundleUtils.getLocaleString(S_PATH_EXISTS_NOT_DIR_KEY, file.toString()), ResourceBundleUtils.getLocaleString(S_PATH_EXISTS_NOT_DIR_KEY, file.getPath().toString()), true);
            }
            if (file.list().length != 0) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "throwExceptionIfTheGivenTargetProfilePathIsInvalidForCreate", "Profile path " + file.toString() + " is a non-empty directory");
                throw new WSProfileException(ResourceBundleUtils.getLocaleString(S_DIR_EXISTS_NOT_EMPTY_KEY, file.toString()), ResourceBundleUtils.getLocaleString(S_DIR_EXISTS_NOT_EMPTY_KEY, file.getPath().toString()), true);
            }
        }
        LOGGER.exiting(WSProfile.class.getName(), "throwExceptionIfTheGivenTargetProfilePathIsInvalidForCreate");
    }

    private static void validateDirectoryIsWritable(File file) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "validateDirectoryIsWritable");
        if (!FileUtils.isDirectoryWritable(file)) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "validateDirectoryIsWritable", file.toString() + " is not writable");
            throw new WSProfileException(ResourceBundleUtils.getLocaleString(S_PATH_NOT_WRITABLE_KEY, file.toString()), ResourceBundleUtils.getLocaleString(S_PATH_NOT_WRITABLE_KEY, file.getPath().toString()), true);
        }
        LOGGER.exiting(WSProfile.class.getName(), "validateDirectoryIsWritable");
    }

    private static void validateAProfileTemplateExistsAtTheGivenPath(File file) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "validateProfileTemplateExists");
        if (!file.exists()) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "validateAProfileTemplateExistsAtTheGivenPath", "Profile template " + file.toString() + " does not exist");
            throw new WSProfileException(ResourceBundleUtils.getLocaleString(S_NO_PROFILE_TEMPLATE_EXISTS_AT_GIVEN_PATH_KEY, file.toString()), ResourceBundleUtils.getLocaleString(S_NO_PROFILE_TEMPLATE_EXISTS_AT_GIVEN_PATH_KEY, file.getPath().toString()), true);
        }
        File file2 = new File(file, "actionRegistry.xml");
        if (!file2.exists()) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "validateAProfileTemplateExistsAtTheGivenPath", "Profile template " + file.toString() + " is not a valid profile template");
            throw new WSProfileException(ResourceBundleUtils.getLocaleString(S_NO_PROFILE_TEMPLATE_EXISTS_AT_GIVEN_PATH_KEY, file.toString()), ResourceBundleUtils.getLocaleString(S_NO_PROFILE_TEMPLATE_EXISTS_AT_GIVEN_PATH_KEY, file.getPath().toString()), true);
        }
        LOGGER.exiting(WSProfile.class.getName(), "validateProfileTemplateExists");
    }

    private static void throwExceptionIfTheGivenProfileIsAlreadyRegistered(String string, File file, File file2, File file3) throws WSProfileException {
        ProfileRegistryMarshaller profileRegistryMarshaller = new ProfileRegistryMarshaller(file3.getAbsolutePath());
        Profile profile = new Profile(string, file, file2, false);
        profileRegistryMarshaller.throwExceptionIfTheGivenProfileIsAlreadyRegistered(profile);
    }

    private static void throwExceptionIfTheGivenProfileNameIsAlreadyRegistered(String string, File file) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "throwExceptionIfTheGivenProfileNameIsAlreadyRegistered");
        List list = WSProfile.listProfileNames(file);
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).equals(string)) continue;
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "throwExceptionIfTheGivenProfileNameIsAlreadyRegistered", "Profile name " + string + " already exists in the profile registry");
            throw new WSProfileException(ResourceBundleUtils.getLocaleString(S_PROFILE_NAME_EXISTS_KEY, string), ResourceBundleUtils.getLocaleString(S_PROFILE_NAME_EXISTS_KEY, string), true);
        }
        LOGGER.exiting(WSProfile.class.getName(), "throwExceptionIfTheGivenProfileNameIsAlreadyRegistered");
    }

    private static void setReservationTicketToRegistry(String string, File file) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "setReservationTicket");
        ProfileRegistryMarshaller profileRegistryMarshaller = new ProfileRegistryMarshaller(file.getAbsolutePath());
        if (!profileRegistryMarshaller.markProfileReservationTicket(string)) {
            throw new WSProfileException(ResourceBundleUtils.getLocaleString(S_RESERVATION_TICKET_NOT_AVAILABLE_KEY, string), ResourceBundleUtils.getLocaleString(S_RESERVATION_TICKET_NOT_AVAILABLE_KEY, string), true);
        }
        LOGGER.exiting(WSProfile.class.getName(), "setReservationTicket");
    }

    private static void unsetReservationTicketFromRegistry(String string, File file) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "unsetReservationTicket");
        ProfileRegistryMarshaller profileRegistryMarshaller = new ProfileRegistryMarshaller(file.getAbsolutePath());
        profileRegistryMarshaller.unmarkProfileReservationTicket(string);
        LOGGER.exiting(WSProfile.class.getName(), "unsetReservationTicket");
    }

    private static void validateProfileCreationTemplate(WSProfileTemplate wSProfileTemplate) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "validateProfileCreationTemplate");
        if (!wSProfileTemplate.isCreateTemplate()) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "validateProfileCreationTemplate", "The profile tmeplate " + wSProfileTemplate.getProfileTemplatePath() + " cannot be used to create a template.");
            throw new WSProfileException(ResourceBundleUtils.getLocaleString(S_INVALID_PROFILE_TEMPLATE_OPERATION_KEY, wSProfileTemplate.getProfileTemplatePath().toString()), ResourceBundleUtils.getLocaleString(S_INVALID_PROFILE_TEMPLATE_OPERATION_KEY, wSProfileTemplate.getProfileTemplatePath().toString()), true);
        }
        LOGGER.exiting(WSProfile.class.getName(), "validateProfileCreationTemplate");
    }

    private static void validateProfileAugmentationTemplate(Profile profile, WSProfileTemplate wSProfileTemplate) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "validateProfileAugmentationTemplate");
        if (!wSProfileTemplate.isAugmentTemplate()) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "validateProfileAugmentationTemplate", "The profile template " + wSProfileTemplate.getProfileTemplatePath() + " cannot be used to create a template.");
            throw new WSProfileException(ResourceBundleUtils.getLocaleString(S_INVALID_PROFILE_TEMPLATE_OPERATION_KEY, wSProfileTemplate.getProfileTemplatePath().toString()), ResourceBundleUtils.getLocaleString(S_INVALID_PROFILE_TEMPLATE_OPERATION_KEY, wSProfileTemplate.getProfileTemplatePath().toString()), true);
        }
        if (!wSProfileTemplate.isRepeatable()) {
            Vector vector = (Vector)profile.getAugmentors();
            String string = S_EMPTY;
            for (int i = 0; i < vector.size(); ++i) {
                string = (String)vector.elementAt(i);
                if (wSProfileTemplate.getProfileTemplatePath().equals(new File(string))) {
                    throw new WSProfileException(ResourceBundleUtils.getLocaleString(S_CANNOT_REPEAT_TEMPLATE_OPERATION_KEY, wSProfileTemplate.getProfileTemplatePath().toString()), ResourceBundleUtils.getLocaleString(S_CANNOT_REPEAT_TEMPLATE_OPERATION_KEY, wSProfileTemplate.getProfileTemplatePath().toString()), true);
                }
                string = S_EMPTY;
            }
        }
        LOGGER.exiting(WSProfile.class.getName(), "validateProfileAugmentationTemplate");
    }

    private static WSProfileTemplate getWSProfileTemplate(File file) throws WSProfileException {
        WSProfileTemplate wSProfileTemplate;
        LOGGER.entering(WSProfile.class.getName(), "getWSProfileTemplate");
        try {
            wSProfileTemplate = new WSProfileTemplate(file);
        }
        catch (WSProfileException wSProfileException) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "getWSProfileTemplate", wSProfileException.getMessage());
            throw new WSProfileException(ResourceBundleUtils.getLocaleString(S_INVALID_PROFILE_TEMPLATE_KEY, file.toString()), ResourceBundleUtils.getLocaleString(S_INVALID_PROFILE_TEMPLATE_KEY, file.toString()), true);
        }
        LOGGER.exiting(WSProfile.class.getName(), "getWSProfileTemplate");
        return wSProfileTemplate;
    }

    private static Map replaceTemplatePathArg(Map map, String string) {
        Hashtable hashtable = new Hashtable(map);
        Vector<String> vector = new Vector<String>();
        if (hashtable.containsKey("templatePath")) {
            vector.add(string);
            hashtable.put("templatePath", vector);
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isWasprofilePropertiesAvailable(String string) {
        LOGGER.entering(WSProfile.class.getName(), "isValidWASHome");
        boolean bl = true;
        WSProfileContext wSProfileContext = new WSProfileContext();
        try {
            wSProfileContext.saveCurrentContext();
            wSProfileContext.switchContext(string);
            new WSProfileProperties();
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "isWasprofilePropertiesAvailable", "wasprofile.properties unavailable for WAS_HOME [" + string + "]");
            LogUtils.logException(LOGGER, fileNotFoundException);
            bl = false;
        }
        catch (IOException iOException) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "isWasprofilePropertiesAvailable", "wasprofile.properties unavailable for WAS_HOME [" + string + "]");
            LogUtils.logException(LOGGER, iOException);
            bl = false;
        }
        finally {
            if (wSProfileContext != null) {
                wSProfileContext.restoreSavedContext();
            }
        }
        LOGGER.exiting(WSProfile.class.getName(), "isValidWASHome");
        return bl;
    }

    public static List getAllValidAugmentors(String string, List list, boolean bl) {
        LOGGER.entering(WSProfile.class.getName(), "getAllValidAugmentors");
        Vector<File> vector = new Vector<File>();
        try {
            for (int i = 0; i < list.size(); ++i) {
                File file = (File)list.get(i);
                if (!WSProfile.isValidAugmentor(string, file, bl)) continue;
                vector.add(file);
            }
        }
        catch (Exception exception) {
            LOGGER.exiting(WSProfile.class.getName(), "getAllValidAugmentors");
            return new Vector();
        }
        LOGGER.exiting(WSProfile.class.getName(), "getAllValidAugmentors");
        return vector;
    }

    public static List getAllValidAugmentors(String string, List list) {
        LOGGER.entering(WSProfile.class.getName(), "getAllValidAugmentors");
        LOGGER.exiting(WSProfile.class.getName(), "getAllValidAugmentors");
        return WSProfile.getAllValidAugmentors(string, list, true);
    }

    public static boolean isValidAugmentor(String string, File file, boolean bl) {
        boolean bl2;
        LOGGER.entering(WSProfile.class.getName(), "isValidAugmentor");
        try {
            WSProfileTemplate wSProfileTemplate;
            Vector vector = PrereqTemplateUtils.getTemplatesForStackAugmentation(file, WSProfile.getProfile(string));
            bl2 = bl ? (!vector.contains(wSProfileTemplate = new WSProfileTemplate(file)) ? wSProfileTemplate.isRepeatable() : true) : true;
        }
        catch (WSProfileException wSProfileException) {
            bl2 = false;
        }
        LOGGER.exiting(WSProfile.class.getName(), "isValidAugmentor");
        return bl2;
    }
}

