/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.profile;

import com.ibm.ws.install.configmanager.ConfigManagerConstants;
import com.ibm.ws.install.configmanager.launcher.ArgumentValueFetcher;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerContext;
import com.ibm.ws.install.configmanager.logging.LoggerFactoryConstants;
import com.ibm.ws.install.configmanager.utils.SystemPropertiesUtils;
import com.ibm.ws.profile.WSProfileConstants;
import com.ibm.ws.profile.bootstrap.LogInitializer;
import com.ibm.ws.profile.bootstrap.WSProfileProperties;
import com.ibm.ws.profile.cli.WSProfileCLIModeInvoker;
import com.ibm.ws.profile.cli.output.OutputStreamHandler;
import com.ibm.ws.profile.utils.CommandLineArgumentsUtils;
import com.ibm.ws.profile.utils.DefaultValueManagerUtils;
import com.ibm.ws.profile.utils.ResponseFileUtils;
import com.ibm.ws.profile.utils.VectorUtils;
import com.ibm.wsspi.profile.WSProfile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WSProfileCLI {
    private static Logger LOGGER = null;
    private static String S_CLASS_NAME = WSProfileCLI.class.getName();
    private static final String S_COMMA = ",";
    private static final String S_DASH = "-";
    private static final String S_EMPTY = "";
    private static final String S_PASSWD_PARAMETER = "winservicePassword";
    private static final String S_PASSWD_HIDE = "****************";
    private static final int I_INITIAL_INDEX = -999;
    private static final String[] A_MODES_THAT_REQUIRE_DEFAULTABLE_PROFILE_NAME = new String[]{"create"};
    private static Properties m_propertiesInitSysProps;
    private static LoggerContext m_lcSwitcher;

    public static void main(String[] stringArray) {
        WSProfileCLI.initLogger(stringArray);
        LOGGER.entering(WSProfile.class.getName(), "main");
        int n = WSProfileCLI.invokeWSProfile(stringArray);
        LOGGER.exiting(WSProfile.class.getName(), "main");
        System.exit(n);
    }

    public static int mainForInProcessCalls(String[] stringArray) {
        m_lcSwitcher = new LoggerContext();
        m_lcSwitcher.saveAndSwitchCurrentContext();
        WSProfileCLI.initLogger(stringArray);
        LOGGER.entering(WSProfile.class.getName(), "mainForInProcessCalls");
        OutputStreamHandler.init();
        int n = WSProfileCLI.invokeWSProfile(stringArray);
        m_lcSwitcher.restoreSavedContext();
        LOGGER.exiting(WSProfile.class.getName(), "mainForInProcessCalls");
        return n;
    }

    public static Hashtable getOutput() {
        LOGGER.entering(WSProfile.class.getName(), "getOutput");
        LOGGER.exiting(WSProfile.class.getName(), "getOutput");
        return OutputStreamHandler.getOutput();
    }

    private static void initLogger(String[] stringArray) {
        try {
            LOGGER = new LogInitializer(stringArray).initCMTLoggerFactory(WSProfileCLI.class);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(fileNotFoundException.getMessage());
            System.exit(1);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            System.exit(1);
        }
    }

    public static String getMode(String[] stringArray) {
        LOGGER.entering(WSProfile.class.getName(), "getMode");
        if (WSProfileCLIModeInvoker.isTheUserRequestingHelp(stringArray)) {
            LOGGER.exiting(WSProfile.class.getName(), "getMode");
            return "help";
        }
        LOGGER.exiting(WSProfile.class.getName(), "getMode");
        return WSProfileCLIModeInvoker.getModeInvoker(stringArray).getModeFlag();
    }

    private static String getModeRegistryFileName(String[] stringArray) {
        LOGGER.entering(WSProfile.class.getName(), "getModeRegistryFileName");
        if (WSProfileCLIModeInvoker.isTheUserRequestingHelp(stringArray)) {
            LOGGER.exiting(WSProfile.class.getName(), "getModeRegistryFileName");
            return null;
        }
        LOGGER.exiting(WSProfile.class.getName(), "getModeRegistryFileName");
        return WSProfileCLIModeInvoker.getModeInvoker(stringArray).getRegistryName();
    }

    private static String getArgument(String[] stringArray, String string) {
        LOGGER.entering(WSProfile.class.getName(), "getArgument");
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(S_DASH + string) || i >= stringArray.length - 1 || stringArray[i + 1].startsWith(S_DASH)) continue;
            LOGGER.exiting(WSProfile.class.getName(), "getArgument");
            return stringArray[i + 1];
        }
        LOGGER.exiting(WSProfile.class.getName(), "getArgument");
        return null;
    }

    private static boolean modeRequiresArgument(String string, String string2) {
        if (string2.equals("profileName")) {
            for (int i = 0; i < A_MODES_THAT_REQUIRE_DEFAULTABLE_PROFILE_NAME.length; ++i) {
                if (!A_MODES_THAT_REQUIRE_DEFAULTABLE_PROFILE_NAME[i].equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    private static int invokeWSProfile(String[] stringArray) {
        LOGGER.entering(WSProfileCLI.class.getName(), "invokeWSProfile");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "invokeWSProfile", "Incoming command line is: " + LogUtils.getArrayAsALoggableString(WSProfileCLI.hidePasswordArgs(stringArray)));
        int n = 1;
        String[] stringArray2 = WSProfileCLI.getIncomingCommandLine(stringArray);
        try {
            ArgumentValueFetcher.setCommandLineArguments(CommandLineArgumentsUtils.convertCommandLineToHashtable(stringArray2));
        }
        catch (Throwable throwable) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "invokeWSProfile", "Exception caching commandline args" + throwable);
        }
        if (WSProfileCLI.isEarlyDefaultingNecessary(stringArray2)) {
            stringArray2 = WSProfileCLI.addEarlyDefaults(stringArray2);
        }
        if (WSProfileCLI.isLogReInitializationNecessary(stringArray, stringArray2)) {
            WSProfileCLI.reInitializeLogger(stringArray2);
        }
        n = WSProfileCLIModeInvoker.isTheUserRequestingHelp(stringArray2) ? WSProfileCLIModeInvoker.doHelpMode(stringArray2) : WSProfileCLIModeInvoker.getModeInvoker(stringArray2).invokeWSProfile();
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "invokeWSProfile", "Returning with return code: " + WSProfileConstants.AS_RETURN_CODES[n]);
        LOGGER.exiting(WSProfileCLI.class.getName(), "invokeWSProfile");
        return n;
    }

    private static String[] getIncomingCommandLine(String[] stringArray) {
        LOGGER.entering(WSProfileCLI.class.getName(), "getIncomingCommandLine");
        List<String> list = Arrays.asList(stringArray);
        if (!list.contains("-response")) {
            return stringArray;
        }
        try {
            int n = list.indexOf("-response") + 1;
            if (WSProfileCLIModeInvoker.isTheUserRequestingHelp(stringArray) || list.size() <= n) {
                return stringArray;
            }
            String string = list.get(n).toString();
            String string2 = ResponseFileUtils.encodeResponseFile(string);
            Properties properties = new Properties();
            properties.load(new FileInputStream(string2));
            new File(string2).delete();
            String[] stringArray2 = WSProfileCLI.convertPropertiesToCommandLineArguments(properties);
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getIncomingCommandLine", "Resolved command line from response file: " + LogUtils.getArrayAsALoggableString(WSProfileCLI.hidePasswordArgs(stringArray2)));
            LOGGER.exiting(WSProfileCLI.class.getName(), "getIncomingCommandLine");
            return stringArray2;
        }
        catch (Throwable throwable) {
            LogUtils.logException(LOGGER, throwable);
            LOGGER.exiting(WSProfileCLI.class.getName(), "getIncomingCommandLine");
            return stringArray;
        }
    }

    private static String[] convertPropertiesToCommandLineArguments(Properties properties) {
        LOGGER.entering(WSProfileCLI.class.getName(), "convertPropertiesToCommandLineArguments");
        Vector<String> vector = new Vector<String>();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            vector.add(S_DASH + string);
            String string2 = properties.getProperty(string);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, S_COMMA);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken().trim();
                vector.add(string3);
            }
        }
        LOGGER.exiting(WSProfileCLI.class.getName(), "convertPropertiesToCommandLineArguments");
        return VectorUtils.convertVectorToStringArray(vector);
    }

    private static String[] hidePasswordArgs(String[] stringArray) {
        LOGGER.entering(WSProfileCLI.class.getName(), "hidePasswordArgs");
        String[] stringArray2 = new String[stringArray.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        String[] stringArray3 = WSProfileCLI.getMaskableArgs();
        if (stringArray3 == null) {
            return stringArray2;
        }
        int n = -999;
        for (int i = 0; i < stringArray2.length; ++i) {
            if (n != -999) {
                stringArray2[n] = S_PASSWD_HIDE;
            }
            for (int j = 0; j < stringArray3.length; ++j) {
                if (!stringArray2[i].equals(S_DASH + stringArray3[j])) continue;
                n = i + 1;
            }
        }
        LOGGER.exiting(WSProfileCLI.class.getName(), "hidePasswordArgs");
        return stringArray2;
    }

    private static String[] getMaskableArgs() {
        LOGGER.entering(WSProfile.class.getName(), "getMaskableArgs");
        String string = S_EMPTY;
        try {
            string = new String(new WSProfileProperties().getProperty("WS_WSPROFILE_MASKABLE_ACTION_ARGUMENTS"));
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getMaskableArgs", "No Maskable Action Arguments found in wasprofile.properties.");
        }
        catch (IOException iOException) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getMaskableArgs", "No Maskable Action Arguments found in wasprofile.properties.");
        }
        catch (NullPointerException nullPointerException) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getMaskableArgs", "No Maskable Action Arguments found in wasprofile.properties.");
        }
        if (string.indexOf(S_PASSWD_PARAMETER) == -1) {
            string = "winservicePassword;" + string;
        }
        Object[] objectArray = string.split(";");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getMaskableArgs", "Maskable Action Arguments: " + LogUtils.getArrayAsALoggableString(objectArray));
        LOGGER.exiting(WSProfile.class.getName(), "getMaskableArgs");
        return objectArray;
    }

    private static boolean isEarlyDefaultingNecessary(String[] stringArray) {
        LOGGER.entering(WSProfileCLI.class.getName(), "isEarlyDefaultingNecessary");
        String string = WSProfileCLI.getMode(stringArray);
        if (WSProfileCLI.getArgument(stringArray, "profileName") == null && WSProfileCLI.getArgument(stringArray, "templatePath") != null && WSProfileCLI.modeRequiresArgument(string, "profileName")) {
            LOGGER.exiting(WSProfileCLI.class.getName(), "isEarlyDefaultingNecessary");
            return true;
        }
        LOGGER.exiting(WSProfileCLI.class.getName(), "isEarlyDefaultingNecessary");
        return false;
    }

    private static String[] addEarlyDefaults(String[] stringArray) {
        LOGGER.entering(WSProfileCLI.class.getName(), "addEarlyDefaults");
        Properties properties = SystemPropertiesUtils.getCurrentSystemProperties();
        String string = WSProfileCLI.getArgument(stringArray, "templatePath");
        if (string != null && !string.equals(S_EMPTY)) {
            System.setProperty(ConfigManagerConstants.S_ARG_CONFIG_DIR, string);
            System.setProperty(ConfigManagerConstants.S_ARG_ACTION_REGISTRY, string + File.separator + WSProfileCLI.getModeRegistryFileName(stringArray));
            System.setProperty(WSProfileCLI.getMode(stringArray), S_EMPTY);
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("templatePath", string);
            String string2 = DefaultValueManagerUtils.getDefaultValue("profileName", hashtable);
            if (string2 != null && !string2.equals(S_EMPTY)) {
                String[] stringArray2 = new String[stringArray.length + 2];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray2[i] = stringArray[i];
                }
                stringArray2[i] = "-profileName";
                stringArray2[i + 1] = string2;
                stringArray = stringArray2;
            }
            SystemPropertiesUtils.resetSystemProperties(properties);
            return stringArray;
        }
        LOGGER.exiting(WSProfileCLI.class.getName(), "addEarlyDefaults");
        return stringArray;
    }

    private static void reInitializeLogger(String[] stringArray) {
        LOGGER.entering(WSProfileCLI.class.getName(), "addEarlyDefaults");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "reInitializeLogger", "Current command line is: " + LogUtils.getArrayAsALoggableString(WSProfileCLI.hidePasswordArgs(stringArray)));
        String string = LoggerFactoryConstants.getGlobalLogFilePath();
        try {
            String string2 = new LogInitializer(stringArray).determineLogFileName();
            String string3 = LoggerFactoryConstants.getGlobalLogDirectory();
            String string4 = new File(string3, string2).getAbsolutePath();
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "reInitializeLogger", "Switching logging to: " + string4);
            if (m_lcSwitcher != null) {
                m_lcSwitcher.saveAndSwitchCurrentContext();
            }
            WSProfileCLI.initLogger(stringArray);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            System.exit(1);
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "reInitializeLogger", "Logging continued from: " + string);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "reInitializeLogger", "Current command line is: " + LogUtils.getArrayAsALoggableString(WSProfileCLI.hidePasswordArgs(stringArray)));
        LOGGER.exiting(WSProfileCLI.class.getName(), "reInitializeLogger");
    }

    private static boolean isLogReInitializationNecessary(String[] stringArray, String[] stringArray2) {
        LOGGER.entering(WSProfileCLI.class.getName(), "isLogReInitializationNecessary");
        String string = WSProfileCLI.getCurrentProfileName(stringArray);
        String string2 = WSProfileCLI.getCurrentProfileName(stringArray2);
        String string3 = WSProfileCLI.getCurrentModeName(stringArray);
        String string4 = WSProfileCLI.getCurrentModeName(stringArray2);
        if (string == null && string2 != null || string3 == null && string2 != null || string != null && !string.equals(string2) || string3 != null && !string3.equals(string4)) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "isLogReInitializationNecessary", "Log re-initialization is necessary: true");
            LOGGER.exiting(WSProfileCLI.class.getName(), "isLogReInitializationNecessary");
            return true;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "isLogReInitializationNecessary", "Log re-initialization is necessary: false");
        LOGGER.exiting(WSProfileCLI.class.getName(), "isLogReInitializationNecessary");
        return false;
    }

    private static String getCurrentModeName(String[] stringArray) {
        LOGGER.entering(WSProfileCLI.class.getName(), "getCurrentModeName");
        List<String> list = Arrays.asList(stringArray);
        for (int i = 0; i < WSProfileConstants.AS_AVAILABLE_CLI_MODES.length; ++i) {
            if (!list.contains(S_DASH + WSProfileConstants.AS_AVAILABLE_CLI_MODES[i])) continue;
            LOGGER.exiting(WSProfileCLI.class.getName(), "getCurrentModeName");
            return WSProfileConstants.AS_AVAILABLE_CLI_MODES[i];
        }
        LOGGER.exiting(WSProfileCLI.class.getName(), "getCurrentModeName");
        return "help";
    }

    private static String getCurrentProfileName(String[] stringArray) {
        LOGGER.entering(WSProfileCLI.class.getName(), "getCurrentProfileName");
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-profileName") || i >= stringArray.length - 1 || stringArray[i + 1].startsWith(S_DASH)) continue;
            LOGGER.exiting(WSProfileCLI.class.getName(), "getCurrentProfileName");
            return stringArray[i + 1];
        }
        LOGGER.exiting(WSProfileCLI.class.getName(), "getCurrentProfileName");
        return null;
    }
}

