/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.profile;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.utils.ClassPathModifier;
import com.ibm.ws.profile.utils.FileUtils;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.wsspi.profile.WSProfileException;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WSProfileTemplate {
    private File m_fileTemplatePath = null;
    private File m_fileTemplateMetadata = null;
    private File m_fileResourceBundleJarPath = null;
    private ResourceBundle m_resourceBundle = null;
    private Date m_buildDate = null;
    private List m_listDependentTemplates = null;
    private String m_sNameKey = null;
    private String m_sShortDescriptionKey = null;
    private String m_sLongDescriptionKey = null;
    private String m_sType = null;
    private String m_sVersion = null;
    private boolean m_fIsAugmentTemplate = false;
    private boolean m_fIsCreateTemplate = false;
    private boolean m_fIsRepeatable = true;
    private int m_iSize;
    private Vector m_vNameParms = null;
    private Vector m_vShortDescriptionParms = null;
    private Vector m_vLongDescriptionParms = null;
    private File m_filePrerequisiteTemplate = null;
    private static final String S_DATE_FORMAT = "MM/dd/yy";
    private static final String S_JAR_FILE_PATTERN = "^.*\\.jar$";
    private static final int N_ONE = 1;
    private static final int N_MAX_PARMS_PER_MESSAGE_KEY = 10;
    private static final String S_WAS_HOME_REGEX_TOKEN = "\\$\\{WAS_HOME\\}";
    private static final String S_TAG_PROFILE_TEMPLATE = "profileTemplate";
    private static final String S_TAG_RESOURCE_BUNDLE = "resourceBundle";
    private static final String S_TAG_JAR_PATH = "path";
    private static final String S_TAG_RESOURCE_BUNDLE_NAME = "baseName";
    private static final String S_TAG_NAME_KEY = "name";
    private static final String S_TAG_TYPE = "type";
    private static final String S_TAG_VERSION = "version";
    private static final String S_TAG_SHORT_DESCRIPTION_KEY = "shortDescription";
    private static final String S_TAG_LONG_DESCRIPTION_KEY = "longDescription";
    private static final String S_TAG_BUILD_DATE = "buildDate";
    private static final String S_TAG_IS_CREATE_TEMPLATE = "isCreateTemplate";
    private static final String S_TAG_IS_AUGMENT_TEMPLATE = "isAugmentTemplate";
    private static final String S_TAG_IS_REPEATABLE = "isRepeatable";
    private static final String S_TAG_SIZE = "size";
    private static final String S_TAG_MSG_KEY_ARG_PREFIX = "arg";
    private static final String S_TAG_TEMPLATE_PREREQ = "prerequisiteTemplate";
    private static final String[] OPTIONAL_ARGUMENTS = new String[]{"prerequisiteTemplate"};
    private static final String S_TEMPLATE_NOT_FOUND = "Profile template not found: ";
    private static final String S_TEMPLATE_NOT_FOUND_KEY = "WSProfile.WSProfileTemplate.templateNotFound";
    private static final String S_TEMPLATE_METADATA_NOT_FOUND = "Profile template metadata not found. ";
    private static final String S_TEMPLATE_METADATA_NOT_FOUND_KEY = "WSProfile.WSProfileTemplate.templateMetadataNotFound";
    private static final String S_TEMPLATE_BUNDLE_NOT_FOUND = "Template resource bundle not found: ";
    private static final String S_TEMPLATE_BUNDLE_NOT_FOUND_KEY = "WSProfile.WSProfileTemplate.bundleNotFound";
    private static final String S_REQUIRED_ARGUMENT_NOT_FOUND = "Required argument not found: ";
    private static final String S_REQUIRED_ARGUMENT_NOT_FOUND_KEY = "WSProfile.WSProfileTemplate.requiredArgumentNotFound";
    private static final String S_DOCUMENT_READ_TAG_ERROR = "Error reading template information: ";
    private static final String S_DOCUMENT_READ_TAG_ERROR_KEY = "WSProfile.WSProfileTemplate.documentReadTagError";
    private static final String S_METADATA_PARSING_ERROR = "Error while parsing template metadata.";
    private static final String S_METADATA_PARSING_ERROR_KEY = "WSProfile.WSProfileTemplate.metadataParsingError";
    private static final String S_TEMPLATE_UNABLE_TO_LOAD_JAR = "Unable to load the specified Jar file.";
    private static final String S_TEMPLATE_UNABLE_TO_LOAD_JAR_KEY = "WSProfile.WSProfileTemplate.unableToLoadJar";
    private static final Logger LOGGER = LoggerFactory.createLogger(WSProfileTemplate.class);
    private static final String S_CLASS_NAME = WSProfileTemplate.class.getName();

    public WSProfileTemplate(File file) throws WSProfileException {
        this.m_fileTemplatePath = file;
        this.m_fileTemplateMetadata = new File(file, "templateMetadata.xml");
        this.validateProfileTemplateOnFileSystem();
        this.parseTemplateMetadata();
    }

    public WSProfileTemplate(String string) throws WSProfileException {
        this.m_fileTemplatePath = new File(string);
        this.m_fileTemplateMetadata = new File(this.m_fileTemplatePath, "templateMetadata.xml");
        this.validateProfileTemplateOnFileSystem();
        this.parseTemplateMetadata();
    }

    public String toString() {
        return this.getType();
    }

    public File getProfileTemplatePath() {
        LOGGER.entering(WSProfileTemplate.class.getName(), "getProfileTemplatePath");
        LOGGER.exiting(WSProfileTemplate.class.getName(), "getProfileTemplatePath");
        return this.m_fileTemplatePath;
    }

    public Date getBuildDate() {
        LOGGER.entering(WSProfileTemplate.class.getName(), "getBuildDate");
        LOGGER.exiting(WSProfileTemplate.class.getName(), "getBuildDate");
        return this.m_buildDate;
    }

    public String getShortDescription() {
        LOGGER.entering(WSProfileTemplate.class.getName(), "getShortDescription");
        String string = null;
        if (this.m_vShortDescriptionParms.isEmpty()) {
            string = ResourceBundleUtils.getResourceBundleLocaleString(this.m_sShortDescriptionKey, this.m_resourceBundle);
        } else {
            String[] stringArray = this.m_vShortDescriptionParms.toArray(new String[this.m_vShortDescriptionParms.size()]);
            string = ResourceBundleUtils.getResourceBundleLocaleString(this.m_sShortDescriptionKey, stringArray, this.m_resourceBundle);
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "getShortDescription");
        return string;
    }

    public String getLongDescription() {
        LOGGER.entering(WSProfileTemplate.class.getName(), "getLongDescription");
        String string = null;
        if (this.m_vLongDescriptionParms.isEmpty()) {
            string = ResourceBundleUtils.getResourceBundleLocaleString(this.m_sLongDescriptionKey, this.m_resourceBundle);
        } else {
            String[] stringArray = this.m_vLongDescriptionParms.toArray(new String[this.m_vLongDescriptionParms.size()]);
            string = ResourceBundleUtils.getResourceBundleLocaleString(this.m_sLongDescriptionKey, stringArray, this.m_resourceBundle);
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "getLongDescription");
        return string;
    }

    public String getName() {
        LOGGER.entering(WSProfileTemplate.class.getName(), "getName");
        String string = null;
        if (this.m_vNameParms.isEmpty()) {
            string = ResourceBundleUtils.getResourceBundleLocaleString(this.m_sNameKey, this.m_resourceBundle);
        } else {
            String[] stringArray = this.m_vNameParms.toArray(new String[this.m_vNameParms.size()]);
            string = ResourceBundleUtils.getResourceBundleLocaleString(this.m_sNameKey, stringArray, this.m_resourceBundle);
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "getName");
        return string;
    }

    public String getType() {
        LOGGER.entering(WSProfileTemplate.class.getName(), "getType");
        LOGGER.exiting(WSProfileTemplate.class.getName(), "getType");
        return this.m_sType;
    }

    public String getVersion() {
        LOGGER.entering(WSProfileTemplate.class.getName(), "getVersion");
        LOGGER.exiting(WSProfileTemplate.class.getName(), "getVersion");
        return this.m_sVersion;
    }

    public int getSize() {
        LOGGER.entering(WSProfileTemplate.class.getName(), "getSize");
        LOGGER.exiting(WSProfileTemplate.class.getName(), "getSize");
        return this.m_iSize;
    }

    public File getPrereqTemplatePath() {
        LOGGER.entering(WSProfileTemplate.class.getName(), "getPrereqTemplatePath");
        LOGGER.exiting(WSProfileTemplate.class.getName(), "getPrereqTemplatePath");
        return this.m_filePrerequisiteTemplate;
    }

    public boolean isAugmentTemplate() {
        LOGGER.entering(WSProfileTemplate.class.getName(), S_TAG_IS_AUGMENT_TEMPLATE);
        LOGGER.exiting(WSProfileTemplate.class.getName(), S_TAG_IS_AUGMENT_TEMPLATE);
        return this.m_fIsAugmentTemplate;
    }

    public boolean isCreateTemplate() {
        LOGGER.entering(WSProfileTemplate.class.getName(), S_TAG_IS_CREATE_TEMPLATE);
        LOGGER.exiting(WSProfileTemplate.class.getName(), S_TAG_IS_CREATE_TEMPLATE);
        return this.m_fIsCreateTemplate;
    }

    public boolean isRepeatable() {
        LOGGER.entering(WSProfileTemplate.class.getName(), S_TAG_IS_REPEATABLE);
        LOGGER.exiting(WSProfileTemplate.class.getName(), S_TAG_IS_REPEATABLE);
        return this.m_fIsRepeatable;
    }

    public String getResourceBundleClassname() {
        LOGGER.entering(WSProfileTemplate.class.getName(), "getResourceBundleClassname");
        LOGGER.exiting(WSProfileTemplate.class.getName(), "getResourceBundleClassname");
        return this.m_resourceBundle.getClass().getName();
    }

    public File getResourceBundlePath() {
        LOGGER.entering(WSProfileTemplate.class.getName(), "getResourceBundleClassname");
        LOGGER.exiting(WSProfileTemplate.class.getName(), "getResourceBundleClassname");
        return this.m_fileResourceBundleJarPath;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof WSProfileTemplate) {
            WSProfileTemplate wSProfileTemplate = (WSProfileTemplate)object;
            return this.getProfileTemplatePath().equals(wSProfileTemplate.getProfileTemplatePath());
        }
        return false;
    }

    private void parseTemplateMetadata() throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "parseTemplateMetadata");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            Document document = documentBuilderFactory.newDocumentBuilder().parse(this.m_fileTemplateMetadata);
            this.unmarshallResourceBundleMetadata(document);
            this.unmarshallNameKey(document);
            this.unmarshallType(document);
            this.unmarshallVersion(document);
            this.unmarshallShortDescriptionKey(document);
            this.unmarshallLongDescriptionKey(document);
            this.unmarshallBuildDate(document);
            this.unmarshallIsCreateTemplate(document);
            this.unmarshallIsAugmentTemplate(document);
            this.unmarshallIsRepeatable(document);
            this.unmarshallPrerequisite(document);
            this.unmarshallSize(document);
        }
        catch (IOException iOException) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "parseTemplateMetadata", "Exception caught while parsing template metadata: " + iOException.getMessage());
            throw new WSProfileException(S_METADATA_PARSING_ERROR, ResourceBundleUtils.getLocaleString(S_METADATA_PARSING_ERROR_KEY));
        }
        catch (SAXException sAXException) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "parseTemplateMetadata", "Exception caught while parsing template metadata: " + sAXException.getMessage());
            throw new WSProfileException(S_METADATA_PARSING_ERROR, ResourceBundleUtils.getLocaleString(S_METADATA_PARSING_ERROR_KEY));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "parseTemplateMetadata", "Exception caught while parsing template metadata: " + parserConfigurationException.getMessage());
            throw new WSProfileException(S_METADATA_PARSING_ERROR, ResourceBundleUtils.getLocaleString(S_METADATA_PARSING_ERROR_KEY));
        }
        catch (Exception exception) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "parseTemplateMetadata", "Unexpected exception caught!");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "parseTemplateMetadata", "Exception caught while parsing template metadata: " + exception.getMessage());
            throw new WSProfileException(S_METADATA_PARSING_ERROR, ResourceBundleUtils.getLocaleString(S_METADATA_PARSING_ERROR_KEY));
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "parseTemplateMetadata");
    }

    private String unmarshallSingleStringFromDocument(Document document, String string) throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "unmarshallSingleStringFromDocument");
        NodeList nodeList = document.getElementsByTagName(string);
        String string2 = "";
        string2 = nodeList.item(0).getChildNodes().item(0).getNodeValue();
        if (string2 == null) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "unmarshallSingleStringFromDocument", "The tag " + string + " was found to be null.");
            throw new WSProfileException(S_DOCUMENT_READ_TAG_ERROR + string, ResourceBundleUtils.getLocaleString(S_DOCUMENT_READ_TAG_ERROR_KEY, string));
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "unmarshallSingleStringFromDocument");
        return string2;
    }

    private void unmarshallResourceBundleMetadata(Document document) throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "unmarshallResourceBundleMetadata");
        this.validateProfileTemplateArgument(document, S_TAG_RESOURCE_BUNDLE);
        this.validateProfileTemplateArgument(document, S_TAG_JAR_PATH);
        this.validateProfileTemplateArgument(document, S_TAG_RESOURCE_BUNDLE_NAME);
        NodeList nodeList = document.getElementsByTagName(S_TAG_RESOURCE_BUNDLE);
        this.validateNodeListSize(nodeList, S_TAG_RESOURCE_BUNDLE);
        Element element = (Element)nodeList.item(0);
        NodeList nodeList2 = element.getElementsByTagName(S_TAG_JAR_PATH);
        this.validateNodeListSize(nodeList2, S_TAG_JAR_PATH);
        String string = nodeList2.item(0).getChildNodes().item(0).getNodeValue();
        NodeList nodeList3 = element.getElementsByTagName(S_TAG_RESOURCE_BUNDLE_NAME);
        this.validateNodeListSize(nodeList3, S_TAG_RESOURCE_BUNDLE_NAME);
        String string2 = nodeList3.item(0).getChildNodes().item(0).getNodeValue();
        this.m_fileResourceBundleJarPath = new File(this.getProfileTemplatePath(), string);
        this.addJarToClasspath(this.m_fileResourceBundleJarPath);
        try {
            this.m_resourceBundle = ResourceBundle.getBundle(string2, Locale.getDefault(), Thread.currentThread().getContextClassLoader());
        }
        catch (MissingResourceException missingResourceException) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "unmarshallResourceBundleMetadata", "Resource bundle not found: " + missingResourceException.getMessage());
            throw new WSProfileException(S_TEMPLATE_BUNDLE_NOT_FOUND, ResourceBundleUtils.getLocaleString(S_TEMPLATE_BUNDLE_NOT_FOUND_KEY, string2));
        }
        catch (NullPointerException nullPointerException) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "unmarshallResourceBundleMetadata", "Resource bundle name cannot be null: " + nullPointerException.getMessage());
            throw new WSProfileException(S_TEMPLATE_BUNDLE_NOT_FOUND, ResourceBundleUtils.getLocaleString(S_TEMPLATE_BUNDLE_NOT_FOUND_KEY, string2));
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "unmarshallResourceBundleMetadata");
    }

    private void unmarshallNameKey(Document document) throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "unmarshallNameKey");
        this.validateProfileTemplateArgument(document, S_TAG_NAME_KEY);
        if (this.isTagPresentInDocument(document, S_TAG_NAME_KEY)) {
            this.m_sNameKey = this.unmarshallSingleStringFromDocument(document, S_TAG_NAME_KEY);
            Node node = this.getNodeFromDocumentForThisTag(document, S_TAG_NAME_KEY);
            this.m_vNameParms = this.unmarshallMessageKeyParameters(node);
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "unmarshallNameKey");
    }

    private void unmarshallType(Document document) throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "unmarshallType");
        this.validateProfileTemplateArgument(document, S_TAG_TYPE);
        if (this.isTagPresentInDocument(document, S_TAG_TYPE)) {
            this.m_sType = this.unmarshallSingleStringFromDocument(document, S_TAG_TYPE);
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "unmarshallType");
    }

    private void unmarshallVersion(Document document) throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "unmarshallVersion");
        this.validateProfileTemplateArgument(document, S_TAG_VERSION);
        if (this.isTagPresentInDocument(document, S_TAG_VERSION)) {
            this.m_sVersion = this.unmarshallSingleStringFromDocument(document, S_TAG_VERSION);
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "unmarshallVersion");
    }

    private void unmarshallShortDescriptionKey(Document document) throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "unmarshallShortDescriptionKey");
        this.validateProfileTemplateArgument(document, S_TAG_SHORT_DESCRIPTION_KEY);
        if (this.isTagPresentInDocument(document, S_TAG_SHORT_DESCRIPTION_KEY)) {
            this.m_sShortDescriptionKey = this.unmarshallSingleStringFromDocument(document, S_TAG_SHORT_DESCRIPTION_KEY);
            Node node = this.getNodeFromDocumentForThisTag(document, S_TAG_SHORT_DESCRIPTION_KEY);
            this.m_vShortDescriptionParms = this.unmarshallMessageKeyParameters(node);
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "unmarshallShortDescriptionKey");
    }

    private Vector unmarshallMessageKeyParameters(Node node) throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "unmarshallMessageKeyParameters");
        NamedNodeMap namedNodeMap = node.getAttributes();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < 10; ++i) {
            Node node2 = namedNodeMap.getNamedItem(S_TAG_MSG_KEY_ARG_PREFIX + i);
            if (node2 == null) continue;
            String string = node2.getChildNodes().item(0).getNodeValue();
            vector.addElement(string);
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "unmarshallMessageKeyParameters");
        return vector;
    }

    private void unmarshallLongDescriptionKey(Document document) throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "unmarshallLongDescriptionKey");
        this.validateProfileTemplateArgument(document, S_TAG_LONG_DESCRIPTION_KEY);
        if (this.isTagPresentInDocument(document, S_TAG_LONG_DESCRIPTION_KEY)) {
            this.m_sLongDescriptionKey = this.unmarshallSingleStringFromDocument(document, S_TAG_LONG_DESCRIPTION_KEY);
            Node node = this.getNodeFromDocumentForThisTag(document, S_TAG_LONG_DESCRIPTION_KEY);
            this.m_vLongDescriptionParms = this.unmarshallMessageKeyParameters(node);
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "unmarshallLongDescriptionKey");
    }

    private void unmarshallBuildDate(Document document) throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "unmarshallBuildDate");
        this.validateProfileTemplateArgument(document, S_TAG_BUILD_DATE);
        if (this.isTagPresentInDocument(document, S_TAG_BUILD_DATE)) {
            String string = this.unmarshallSingleStringFromDocument(document, S_TAG_BUILD_DATE);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(S_DATE_FORMAT);
            try {
                this.m_buildDate = simpleDateFormat.parse(string);
            }
            catch (ParseException parseException) {
                LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "unmarshallBuildDate", "Exception caught while parsing build date:" + parseException.getMessage());
                throw new WSProfileException("Error reading template information: buildDate", ResourceBundleUtils.getLocaleString(S_DOCUMENT_READ_TAG_ERROR_KEY, S_TAG_BUILD_DATE));
            }
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "unmarshallBuildDate");
    }

    private void unmarshallIsCreateTemplate(Document document) throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "unmarshallIsCreateTemplate");
        this.validateProfileTemplateArgument(document, S_TAG_IS_CREATE_TEMPLATE);
        if (this.isTagPresentInDocument(document, S_TAG_IS_CREATE_TEMPLATE)) {
            String string = this.unmarshallSingleStringFromDocument(document, S_TAG_IS_CREATE_TEMPLATE);
            this.m_fIsCreateTemplate = Boolean.valueOf(string);
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "unmarshallIsCreateTemplate");
    }

    private void unmarshallIsAugmentTemplate(Document document) throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "unmarshallIsAugmentTemplate");
        this.validateProfileTemplateArgument(document, S_TAG_IS_AUGMENT_TEMPLATE);
        if (this.isTagPresentInDocument(document, S_TAG_IS_AUGMENT_TEMPLATE)) {
            String string = this.unmarshallSingleStringFromDocument(document, S_TAG_IS_AUGMENT_TEMPLATE);
            this.m_fIsAugmentTemplate = Boolean.valueOf(string);
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "unmarshallIsAugmentTemplate");
    }

    private void unmarshallIsRepeatable(Document document) throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "unmarshallIsRepeatable");
        this.validateProfileTemplateArgument(document, S_TAG_IS_REPEATABLE);
        if (this.isTagPresentInDocument(document, S_TAG_IS_REPEATABLE)) {
            String string = this.unmarshallSingleStringFromDocument(document, S_TAG_IS_REPEATABLE);
            this.m_fIsRepeatable = Boolean.valueOf(string);
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "unmarshallIsRepeatable");
    }

    private void unmarshallSize(Document document) throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "unmarshallSize");
        this.validateProfileTemplateArgument(document, S_TAG_SIZE);
        if (this.isTagPresentInDocument(document, S_TAG_SIZE)) {
            String string = this.unmarshallSingleStringFromDocument(document, S_TAG_SIZE);
            try {
                this.m_iSize = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                LogUtils.logException(LOGGER, numberFormatException);
                throw new WSProfileException("Error reading template information: size", ResourceBundleUtils.getLocaleString(S_DOCUMENT_READ_TAG_ERROR_KEY, S_TAG_SIZE));
            }
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "unmarshallSize");
    }

    private void unmarshallPrerequisite(Document document) throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "unmarshallPrerequisite");
        this.validateProfileTemplateArgument(document, S_TAG_TEMPLATE_PREREQ);
        if (this.isTagPresentInDocument(document, S_TAG_TEMPLATE_PREREQ)) {
            String string = this.unmarshallSingleStringFromDocument(document, S_TAG_TEMPLATE_PREREQ);
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "unmarshallPrerequisite", "Testing " + string + " as an " + "absolute or relative path.");
            File file = new File(WSProfileTemplate.replaceWASHome(string));
            File file2 = new File(this.getProfileTemplatePath(), string);
            if (WSProfileTemplate.isValidWSProfileTemplate(file)) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "unmarshallPrerequisite", string + " is a valid full profile template path.");
                this.m_filePrerequisiteTemplate = file;
            } else if (WSProfileTemplate.isValidWSProfileTemplate(file2)) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "unmarshallPrerequisite", string + " is a valid relative profile template path.");
                this.m_filePrerequisiteTemplate = file2;
            } else {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "unmarshallPrerequisite", string + " is not a valid profile template path.");
            }
            this.m_filePrerequisiteTemplate = FileUtils.getNormalizedPath(this.m_filePrerequisiteTemplate.getAbsoluteFile());
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "unmarshallPrerequisite");
    }

    private void addJarToClasspath(File file) throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "addJarToClasspath");
        try {
            if (WSProfileTemplate.isJarFile(file)) {
                ClassPathModifier.addFileToClassPath(file.getPath());
            } else {
                LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "addJarToClasspath", file + " is not a valid Jar File!");
            }
        }
        catch (IOException iOException) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "addJarToClasspath", "Unable to add JAR to classpath: " + iOException.getMessage());
            throw new WSProfileException(S_TEMPLATE_UNABLE_TO_LOAD_JAR, ResourceBundleUtils.getLocaleString(S_TEMPLATE_UNABLE_TO_LOAD_JAR_KEY, file.toString()));
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "addJarToClasspath");
    }

    private void validateProfileTemplateOnFileSystem() throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "validateProfileTEmplateOnFileSystem");
        if (!this.m_fileTemplatePath.isDirectory()) {
            throw new WSProfileException(S_TEMPLATE_NOT_FOUND + this.m_fileTemplatePath.getPath(), ResourceBundleUtils.getLocaleString(S_TEMPLATE_NOT_FOUND_KEY, this.m_fileTemplatePath.getPath()));
        }
        if (!this.m_fileTemplateMetadata.isFile()) {
            throw new WSProfileException(S_TEMPLATE_METADATA_NOT_FOUND + this.m_fileTemplateMetadata.getPath(), ResourceBundleUtils.getLocaleString(S_TEMPLATE_METADATA_NOT_FOUND_KEY, this.m_fileTemplateMetadata.getPath()));
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "validateProfileTEmplateOnFileSystem");
    }

    private void validateProfileTemplateArgument(Document document, String string) throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "validateProfileTemplateArgument");
        boolean bl = false;
        for (int i = 0; i < OPTIONAL_ARGUMENTS.length; ++i) {
            if (!string.equals(OPTIONAL_ARGUMENTS[i])) continue;
            bl = true;
            break;
        }
        if (!bl && !this.isTagPresentInDocument(document, string)) {
            throw new WSProfileException(S_REQUIRED_ARGUMENT_NOT_FOUND + string, ResourceBundleUtils.getLocaleString(S_REQUIRED_ARGUMENT_NOT_FOUND_KEY, string));
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "validateProfileTemplateArgument");
    }

    private void validateNodeListSize(NodeList nodeList, String string) throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "validateNodeListSize");
        if (nodeList.getLength() != 1) {
            throw new WSProfileException(S_DOCUMENT_READ_TAG_ERROR, ResourceBundleUtils.getLocaleString(S_DOCUMENT_READ_TAG_ERROR_KEY, string));
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "validateNodeListSize");
    }

    private Node getNodeFromDocumentForThisTag(Document document, String string) throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "getNodeFromDocumentForThisTag");
        NodeList nodeList = document.getElementsByTagName(string);
        LOGGER.exiting(WSProfileTemplate.class.getName(), "getNodeFromDocumentForThisTag");
        return nodeList.item(0);
    }

    private boolean isTagPresentInDocument(Document document, String string) {
        LOGGER.entering(WSProfileTemplate.class.getName(), "isTagPresentInDocument");
        LOGGER.exiting(WSProfileTemplate.class.getName(), "isTagPresentInDocument");
        return document.getElementsByTagName(string).getLength() != 0;
    }

    private static boolean isJarFile(File file) {
        LOGGER.entering(WSProfileTemplate.class.getName(), "isJarFile");
        LOGGER.exiting(WSProfileTemplate.class.getName(), "isJarFile");
        return file.getAbsolutePath().toLowerCase().matches(S_JAR_FILE_PATTERN);
    }

    private static String replaceWASHome(String string) {
        LOGGER.entering(WSProfileTemplate.class.getName(), "replaceWASHome");
        String string2 = null;
        string2 = System.getProperty("WAS_HOME");
        if (string2 == null) {
            string2 = System.getProperty("was.install.root");
        }
        string2 = string2.replace('\\', '/');
        String string3 = string.replaceAll(S_WAS_HOME_REGEX_TOKEN, string2);
        LOGGER.exiting(WSProfileTemplate.class.getName(), "replaceWASHome");
        return new File(string3).getPath();
    }

    private static boolean isValidWSProfileTemplate(File file) {
        LOGGER.entering(WSProfileTemplate.class.getName(), "isValidTemplate");
        LOGGER.exiting(WSProfileTemplate.class.getName(), "isValidTemplate");
        boolean bl = false;
        bl = file.isDirectory() && new File(file, "templateMetadata.xml").isFile();
        return bl;
    }
}

