/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.profile.registry;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.utils.FileUtils;
import java.io.File;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Profile {
    private String m_sProfileName = null;
    private File m_filePath = null;
    private File m_fileTemplate = null;
    private boolean m_fIsDefault = false;
    private boolean m_fIsAReservationTicket = false;
    private List m_listAugmentors = null;
    private static final String S_COLON = ":";
    private static final Logger LOGGER = LoggerFactory.createLogger(Profile.class);
    private static final String S_CLASS_NAME = Profile.class.getName();

    public Profile(String string, File file, File file2, boolean bl) {
        LOGGER.entering(this.getClass().getName(), "Profile");
        this.m_sProfileName = string;
        this.m_filePath = FileUtils.getNormalizedPath(file);
        this.m_fileTemplate = FileUtils.getNormalizedPath(file2);
        this.m_fIsDefault = bl;
        this.m_listAugmentors = new Vector();
        LOGGER.exiting(this.getClass().getName(), "Profile");
    }

    public Profile(String string, File file, File file2, boolean bl, boolean bl2) {
        this(string, file, file2, bl);
        LOGGER.entering(this.getClass().getName(), "Profile");
        this.m_fIsAReservationTicket = bl2;
        LOGGER.exiting(this.getClass().getName(), "Profile");
    }

    public String toString() {
        LOGGER.entering(this.getClass().getName(), "toString");
        LOGGER.exiting(this.getClass().getName(), "toString");
        return this.m_sProfileName + S_COLON + this.m_filePath.getAbsolutePath() + S_COLON + this.m_fIsDefault + this.m_fIsAReservationTicket;
    }

    public boolean isDefault() {
        LOGGER.entering(this.getClass().getName(), "isDefault");
        LOGGER.exiting(this.getClass().getName(), "isDefault");
        return this.m_fIsDefault;
    }

    public void setDefault(boolean bl) {
        LOGGER.entering(this.getClass().getName(), "setDefault");
        this.m_fIsDefault = bl;
        LOGGER.exiting(this.getClass().getName(), "setDefault");
    }

    public boolean isAReservationTicket() {
        LOGGER.entering(this.getClass().getName(), "isAReservationTicket");
        LOGGER.exiting(this.getClass().getName(), "isAReservationTicket");
        return this.m_fIsAReservationTicket;
    }

    public void setAReservationTicket(boolean bl) {
        LOGGER.entering(this.getClass().getName(), "setAReservationTicket");
        this.m_fIsAReservationTicket = bl;
        LOGGER.exiting(this.getClass().getName(), "setAReservationTicket");
    }

    public String getName() {
        LOGGER.entering(this.getClass().getName(), "getName");
        LOGGER.exiting(this.getClass().getName(), "getName");
        return this.m_sProfileName;
    }

    public void setName(String string) {
        LOGGER.entering(this.getClass().getName(), "setName");
        this.m_sProfileName = string;
        LOGGER.exiting(this.getClass().getName(), "setName");
    }

    public File getPath() {
        LOGGER.entering(this.getClass().getName(), "getPath");
        LOGGER.exiting(this.getClass().getName(), "getPath");
        return this.m_filePath;
    }

    public void setPath(File file) {
        LOGGER.entering(this.getClass().getName(), "setPath");
        this.m_filePath = FileUtils.getNormalizedPath(file);
        LOGGER.exiting(this.getClass().getName(), "setPath");
    }

    public List getAugmentors() {
        LOGGER.entering(this.getClass().getName(), "getAugmentors");
        LOGGER.exiting(this.getClass().getName(), "getAugmentors");
        return this.m_listAugmentors;
    }

    public void addAugmentor(String string) {
        LOGGER.entering(this.getClass().getName(), "addAugmentor");
        this.m_listAugmentors.add(FileUtils.getNormalizedPath(string));
        LOGGER.exiting(this.getClass().getName(), "addAugmentor");
    }

    public void removeAugmentor(String string) {
        LOGGER.entering(this.getClass().getName(), "removeAugmentor");
        this.m_listAugmentors.remove(FileUtils.getNormalizedPath(string));
        LOGGER.exiting(this.getClass().getName(), "removeAugmentor");
    }

    public File getTemplate() {
        LOGGER.entering(this.getClass().getName(), "getTemplate");
        LOGGER.exiting(this.getClass().getName(), "getTemplate");
        return this.m_fileTemplate;
    }

    public boolean equals(Object object) {
        Profile profile;
        LOGGER.entering(this.getClass().getName(), "equals");
        boolean bl = false;
        if (object instanceof Profile && (profile = (Profile)object).getName().equals(this.getName()) && profile.getPath().equals(this.getPath()) && profile.getTemplate().equals(this.getTemplate()) && profile.isDefault() == this.isDefault()) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "equals", this.toString() + " and " + object.toString() + " are equal");
            LOGGER.exiting(this.getClass().getName(), "equals");
            return true;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "equals", this.toString() + " and " + object.toString() + " are not equal");
        LOGGER.exiting(this.getClass().getName(), "equals");
        return false;
    }

    public int hashCode() {
        LOGGER.entering(this.getClass().getName(), "hashCode");
        int n = 1;
        n = n * 31 + this.getName().hashCode();
        n = n * 31 + this.getPath().hashCode();
        n = n * 31 + this.getTemplate().hashCode();
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "hashCode", this.toString() + ", hash code: " + n);
        LOGGER.exiting(this.getClass().getName(), "hashCode");
        return n;
    }

    public boolean isProfileValid() {
        LOGGER.entering(this.getClass().getName(), "hashCode");
        if (!this.m_filePath.exists()) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "isProfileValid", this.toString() + " is not a valid profile as it doesn't exist on the file system");
            return false;
        }
        if (!this.m_fileTemplate.exists()) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "isProfileValid", this.toString() + " is not a valid profile as its template doesn't exist on the file system");
            return false;
        }
        LOGGER.exiting(this.getClass().getName(), "hashCode");
        return true;
    }
}

