/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.rasdiag;

import com.ibm.ws.rasdiag.DiagnosticEventHelper;
import com.ibm.wsspi.rasdiag.DiagnosticCollectionCallback;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class DiagnosticConfig {
    private static final String sThisClass = DiagnosticConfig.class.getName();
    private static Logger sDiagnosticConfigLogger = DiagnosticEventHelper.getLogger(sThisClass, "com.ibm.ws.rasdiag.resources.RasDiagMessages");
    private ArrayList callBacks = new ArrayList(8);
    private String iDPName;
    private String[] iCollectionSpec = null;
    private Pattern[] iCollectionPattern = null;
    private boolean[] iCollectionBool = null;

    DiagnosticConfig(String string, String[] stringArray, boolean[] blArray) {
        if (stringArray == null || blArray == null) {
            sDiagnosticConfigLogger.logp(Level.WARNING, sThisClass, "constructor", "RasDiag.All.NullParm");
            return;
        }
        this.iDPName = string;
        this.setStateCollectionSpec(stringArray, blArray);
        sDiagnosticConfigLogger.logp(Level.FINE, sThisClass, "DiagnosticConfig", "TraceSpec for DPName: " + this.iDPName + " constructor: " + stringArray);
    }

    String getDiagnosticProviderName() {
        return this.iDPName;
    }

    void setStateCollectionSpec(String[] stringArray, boolean[] blArray) {
        int n;
        if (stringArray == null || blArray == null) {
            sDiagnosticConfigLogger.logp(Level.WARNING, sThisClass, "setStateCollectionSpec", "RasDiag.All.NullParm");
            return;
        }
        if (blArray.length != stringArray.length) {
            sDiagnosticConfigLogger.logp(Level.WARNING, sThisClass, "setStateCollectionSpec", "RasDiag.All.InvalidParm", "Arrays wrong lengths");
            return;
        }
        boolean bl = true;
        if (this.iCollectionSpec != null && this.iCollectionSpec.length == stringArray.length) {
            bl = false;
            for (n = 0; n < stringArray.length; ++n) {
                if (this.iCollectionSpec[n].equals(stringArray[n]) && this.iCollectionBool[n] == blArray[n]) continue;
                bl = true;
            }
        }
        if (bl) {
            this.iCollectionSpec = stringArray;
            this.iCollectionBool = blArray;
            this.iCollectionPattern = new Pattern[this.iCollectionSpec.length];
            for (n = 0; n < this.iCollectionSpec.length; ++n) {
                try {
                    this.iCollectionPattern[n] = Pattern.compile(this.iCollectionSpec[n]);
                    continue;
                }
                catch (Exception exception) {
                    sDiagnosticConfigLogger.logp(Level.WARNING, sThisClass, "setStateCollectionSpec", "RasDiag.RegEx.InvString", this.iCollectionSpec[n]);
                    sDiagnosticConfigLogger.logp(Level.WARNING, sThisClass, "setStateCollectionSpec", "RasDiag.RegEx.InvString", exception);
                }
            }
            sDiagnosticConfigLogger.logp(Level.FINE, sThisClass, "setStateCollectionSpec", "TraceSpec for DPName: " + this.iDPName + " Sent to: " + this.callBacks.size() + " DPs and final setStateCollectionSpec: " + stringArray);
            for (n = 0; n < this.callBacks.size(); ++n) {
                ((DiagnosticCollectionCallback)this.callBacks.get(n)).notifyStateCollectionSpecDelta(this.iDPName, this.iCollectionSpec, this.iCollectionBool);
            }
        }
    }

    public void registerCallback(DiagnosticCollectionCallback diagnosticCollectionCallback) {
        if (diagnosticCollectionCallback == null) {
            sDiagnosticConfigLogger.logp(Level.WARNING, sThisClass, "registerCallback", "RasDiag.All.NullParm");
            return;
        }
        this.callBacks.remove(diagnosticCollectionCallback);
        this.callBacks.add(diagnosticCollectionCallback);
    }

    public boolean deRegisterCallback(DiagnosticCollectionCallback diagnosticCollectionCallback) {
        if (diagnosticCollectionCallback == null) {
            sDiagnosticConfigLogger.logp(Level.WARNING, sThisClass, "deRegisterCallback", "RasDiag.All.NullParm");
            return false;
        }
        return this.callBacks.remove(diagnosticCollectionCallback);
    }

    public boolean isEnabled(String string) {
        if (string == null) {
            sDiagnosticConfigLogger.logp(Level.WARNING, sThisClass, "isEnabled", "RasDiag.All.NullParm");
            return false;
        }
        for (int i = this.iCollectionPattern.length - 1; i > -1; --i) {
            if (!this.iCollectionPattern[i].matcher(string).matches()) continue;
            return this.iCollectionBool[i];
        }
        return false;
    }

    public boolean isAnythingEnabled() {
        return this.iCollectionPattern != null && this.iCollectionPattern.length != 0;
    }
}

