/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.rasdiag;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.logging.LoggerHelper;
import com.ibm.ws.rasdiag.DiagnosticEventHelper;
import com.ibm.ws.rasdiag.DiagnosticProviderHelperSaxHandler;
import com.ibm.ws.rasdiag.DiagnosticProviderRegistry;
import com.ibm.wsspi.rasdiag.diagnosticProviderRegistration.AttributeInfo;
import com.ibm.wsspi.rasdiag.diagnosticProviderRegistration.DiagnosticProviderInfo;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class DiagnosticProviderHelper {
    private static final String sThisClass = DiagnosticProviderHelper.class.getName();
    private static Logger sDiagnosticProviderHelperLogger = DiagnosticEventHelper.getLogger(sThisClass, "com.ibm.ws.rasdiag.resources.RasDiagMessages");

    public static String[] localize(ResourceBundle resourceBundle, String[] stringArray) {
        if (resourceBundle == null || stringArray == null) {
            sDiagnosticProviderHelperLogger.logp(Level.WARNING, sThisClass, "localize", "RasDiag.All.NullParm");
            return null;
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) {
                stringArray2[i] = null;
                continue;
            }
            try {
                stringArray2[i] = resourceBundle.getString(stringArray[i]);
                continue;
            }
            catch (MissingResourceException missingResourceException) {
                stringArray2[i] = stringArray[i];
            }
        }
        return stringArray2;
    }

    public static String[] localize(String string, String[] stringArray, Locale locale) {
        if (string == null || stringArray == null || locale == null) {
            sDiagnosticProviderHelperLogger.logp(Level.WARNING, sThisClass, "localize", "RasDiag.All.NullParm");
            return null;
        }
        ResourceBundle resourceBundle = TraceNLS.getResourceBundle(string, locale);
        if (resourceBundle == null) {
            sDiagnosticProviderHelperLogger.logp(Level.WARNING, sThisClass, "localize", "RasDiag.All.InvalidParm", string);
            return null;
        }
        return DiagnosticProviderHelper.localize(resourceBundle, stringArray);
    }

    public static void registerMBeanWithDiagnosticService(String string, ObjectName objectName) {
        if (string == null || objectName == null) {
            sDiagnosticProviderHelperLogger.logp(Level.WARNING, sThisClass, "registerMBeanWithDiagnosticService", "RasDiag.All.NullParm");
        }
        DiagnosticProviderRegistry.register(string, objectName);
    }

    public static void deregisterMBeanFromDiagnosticService(String string, ObjectName objectName, boolean bl) {
        if (string == null && objectName == null) {
            sDiagnosticProviderHelperLogger.logp(Level.WARNING, sThisClass, "deregisterMBeanWithDiagnosticService", "RasDiag.All.NullParm");
        }
        DiagnosticProviderRegistry.deregister(string, objectName, bl);
    }

    public static ObjectName getDiagnosticService(AdminService adminService) {
        Object object;
        if (adminService == null) {
            adminService = AdminServiceFactory.getAdminService();
        }
        if (adminService == null) {
            sDiagnosticProviderHelperLogger.logp(Level.WARNING, sThisClass, "getDiagnosticService", "RasDiag.SDPI.NullAdminSvc");
            return null;
        }
        Set set = null;
        try {
            object = new ObjectName("WebSphere:process=" + adminService.getProcessName() + ",name=DiagnosticService,*");
            set = adminService.queryNames((ObjectName)object, null);
            if (set == null || set.size() < 1) {
                sDiagnosticProviderHelperLogger.logp(Level.WARNING, sThisClass, "getDiagnosticService", "RasDiag.All.JmxInfo", "No diagnosticService objects found");
                return null;
            }
            if (set.size() > 1) {
                sDiagnosticProviderHelperLogger.logp(Level.WARNING, sThisClass, "getDiagnosticService", "RasDiag.SDPI.MultiDiagService", new Integer(set.size()));
            }
        }
        catch (Exception exception) {
            sDiagnosticProviderHelperLogger.logp(Level.WARNING, sThisClass, "getDiagnosticService", "RasDiag.DS.JMXCallIssue", exception);
            return null;
        }
        object = set.iterator();
        return (ObjectName)object.next();
    }

    public static DiagnosticProviderInfo loadRegistry(File file, String string) {
        if (file == null) {
            sDiagnosticProviderHelperLogger.logp(Level.WARNING, sThisClass, "loadRegistry-File", "RasDiag.All.NullParm", "DPNm: " + string);
            return null;
        }
        return DiagnosticProviderHelper.loadRegistryInternal(file, null, string);
    }

    public static DiagnosticProviderInfo loadRegistry(InputStream inputStream, String string) {
        if (inputStream == null) {
            sDiagnosticProviderHelperLogger.logp(Level.WARNING, sThisClass, "loadRegistry-Stream", "RasDiag.All.NullParm", "DPNm: " + string);
            return null;
        }
        return DiagnosticProviderHelper.loadRegistryInternal(null, inputStream, string);
    }

    private static DiagnosticProviderInfo loadRegistryInternal(File file, InputStream inputStream, String string) {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        DiagnosticProviderInfo diagnosticProviderInfo = new DiagnosticProviderInfo();
        DiagnosticProviderHelperSaxHandler diagnosticProviderHelperSaxHandler = new DiagnosticProviderHelperSaxHandler(diagnosticProviderInfo);
        try {
            if (sDiagnosticProviderHelperLogger.isLoggable(Level.FINER)) {
                sAXParserFactory.setValidating(true);
            }
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.getXMLReader().setEntityResolver(diagnosticProviderHelperSaxHandler);
            sDiagnosticProviderHelperLogger.logp(Level.FINER, sThisClass, "loadRegistryInternal", "SAX2 Parsing of DiagnosticProviderInfo XML with verification: " + sAXParser.isValidating());
            if (inputStream != null) {
                sAXParser.parse(inputStream, (DefaultHandler)diagnosticProviderHelperSaxHandler);
            } else {
                sAXParser.parse(file, (DefaultHandler)diagnosticProviderHelperSaxHandler);
            }
        }
        catch (Throwable throwable) {
            sDiagnosticProviderHelperLogger.logp(Level.WARNING, sThisClass, "loadRegistry", "RasDiag.DPHS.XMLDTD1", throwable);
        }
        return diagnosticProviderInfo;
    }

    public static void addDiagnosticProviderIDtoLogger(Logger logger, String string) {
        LoggerHelper.addExtension(logger, "DiagnosticProvider", string);
    }

    public static Object callJmxServer(AdminService adminService, ObjectName objectName, String string, Object[] objectArray, String[] stringArray) {
        try {
            return adminService.invoke(objectName, string, objectArray, stringArray);
        }
        catch (Exception exception) {
            sDiagnosticProviderHelperLogger.logp(Level.WARNING, sThisClass, "callJmxServer", "RasDiag.DS.JMXCallIssue", exception);
            return null;
        }
    }

    public static Object getJmxAttrib(AdminService adminService, ObjectName objectName, String string) {
        try {
            return adminService.getAttribute(objectName, string);
        }
        catch (Exception exception) {
            sDiagnosticProviderHelperLogger.logp(Level.WARNING, sThisClass, "getJmxAttrib", "RasDiag.DS.JMXCallIssue", exception);
            return null;
        }
    }

    public static boolean isPropertyReportable(String string, AttributeInfo[] attributeInfoArray, String string2, boolean bl) {
        if (string2.matches(string)) {
            if (!bl) {
                return true;
            }
            for (int i = 0; i < attributeInfoArray.length; ++i) {
                if (attributeInfoArray[i].compiledId == null) {
                    attributeInfoArray[i].compiledId = Pattern.compile(attributeInfoArray[i].id);
                }
                if (!attributeInfoArray[i].compiledId.matcher(string2).matches()) continue;
                return true;
            }
        }
        return false;
    }

    public static AttributeInfo[] queryMatchingDPInfoAttributes(String string, AttributeInfo[] attributeInfoArray, String[] stringArray, boolean bl) {
        Object object;
        if (string == null || attributeInfoArray == null || stringArray == null) {
            sDiagnosticProviderHelperLogger.logp(Level.WARNING, sThisClass, "queryMatchingDPInfoAttributes", "RasDiag.All.NullParm");
        }
        if (sDiagnosticProviderHelperLogger.isLoggable(Level.FINER)) {
            int n;
            object = "QMDPI in DPH:QMDIA Locid: " + string + " Regd: " + bl + "AttrList: ";
            for (n = 0; n < attributeInfoArray.length; ++n) {
                object = (String)object + " inAttrs[" + n + "].id: " + attributeInfoArray[n].id;
            }
            object = (String)object + "  Names2Ck: ";
            for (n = 0; n < stringArray.length; ++n) {
                object = (String)object + " namesToCheck[" + n + "]: " + stringArray[n];
            }
            sDiagnosticProviderHelperLogger.logp(Level.WARNING, sThisClass, "qmdia", "RasDiag.All.InvalidParm", object);
        }
        object = new ArrayList(stringArray.length);
        Pattern pattern = Pattern.compile(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!pattern.matcher(stringArray[i]).matches()) continue;
            int n = DiagnosticProviderHelper.findAttrib(stringArray[i], attributeInfoArray);
            if (n > -1) {
                ((ArrayList)object).add(new AttributeInfo(stringArray[i], attributeInfoArray[n].descriptionKey, attributeInfoArray[n].registered));
                continue;
            }
            if (bl) continue;
            ((ArrayList)object).add(new AttributeInfo(stringArray[i], stringArray[i] + ".descriptionKey", false));
        }
        AttributeInfo[] attributeInfoArray2 = new AttributeInfo[((ArrayList)object).size()];
        attributeInfoArray2 = ((ArrayList)object).toArray(attributeInfoArray2);
        return attributeInfoArray2;
    }

    public static AttributeInfo queryMatchingDPInfoAttributes(String string, AttributeInfo[] attributeInfoArray, String string2, boolean bl) {
        AttributeInfo[] attributeInfoArray2 = DiagnosticProviderHelper.queryMatchingDPInfoAttributes(string, attributeInfoArray, new String[]{string2}, bl);
        return attributeInfoArray2 == null ? null : attributeInfoArray2[0];
    }

    public static void filterEventPayload(String string, HashMap hashMap) {
        if (string == null || hashMap == null) {
            sDiagnosticProviderHelperLogger.logp(Level.WARNING, sThisClass, "filterEventPayload", "RasDiag.All.NullParm");
        }
        Pattern pattern = Pattern.compile(string);
        DiagnosticProviderHelper.iterativeHashFilter(pattern, "", hashMap);
    }

    private static void iterativeHashFilter(Pattern pattern, String string, HashMap hashMap) {
        Set set = hashMap.keySet();
        ArrayList<String> arrayList = new ArrayList<String>(hashMap.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Object v = hashMap.get(string2);
            String string3 = string + string2;
            if (v instanceof HashMap) {
                DiagnosticProviderHelper.iterativeHashFilter(pattern, string3 + "-", (HashMap)v);
                continue;
            }
            if (string2 == null || pattern.matcher(string3).matches()) continue;
            arrayList.add(string2);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            hashMap.remove(arrayList.get(i));
        }
    }

    public static int findAttrib(String string, AttributeInfo[] attributeInfoArray) {
        for (int i = 0; i < attributeInfoArray.length; ++i) {
            if (attributeInfoArray[i].compiledId == null) {
                attributeInfoArray[i].compiledId = Pattern.compile(attributeInfoArray[i].id);
            }
            if (!attributeInfoArray[i].compiledId.matcher(string).matches()) continue;
            return i;
        }
        return -1;
    }

    public static Iterator resolveObjNm(AdminService adminService, ObjectName objectName) {
        if (adminService == null) {
            adminService = AdminServiceFactory.getAdminService();
        }
        if (adminService == null) {
            sDiagnosticProviderHelperLogger.logp(Level.WARNING, sThisClass, "registerMBeanWithDiagnosticService", "RasDiag.SDPI.NullAdminSvc");
            return null;
        }
        Set set = null;
        try {
            set = adminService.queryNames(objectName, null);
        }
        catch (Exception exception) {
            sDiagnosticProviderHelperLogger.logp(Level.WARNING, sThisClass, "getSet", "RasDiag.DS.ObjNmJmxIssue", exception);
            return null;
        }
        if (set == null || set.size() < 1) {
            return null;
        }
        return set.iterator();
    }
}

