/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.rasdiag.diagnosticProviderRegistration;

import com.ibm.ws.rasdiag.DiagnosticEventHelper;
import com.ibm.wsspi.rasdiag.DiagnosticProviderHelper;
import com.ibm.wsspi.rasdiag.DiagnosticTypedValue;
import com.ibm.wsspi.rasdiag.diagnosticProviderRegistration.AttributeInfo;
import com.ibm.wsspi.rasdiag.diagnosticProviderRegistration.DiagnosticProviderInfo;
import com.ibm.wsspi.rasdiag.diagnosticProviderRegistration.TestInfo;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AttributeBeanInfo {
    private static final String sThisClass = AttributeBeanInfo.class.getName();
    private static Logger sAttributeBeanInfoLogger = DiagnosticEventHelper.getLogger(sThisClass, "com.ibm.ws.rasdiag.resources.RasDiagMessages");
    private Object configBean;
    private Object stateBean;
    private Object testBean;
    private Method[] configMethods = null;
    private Method[] stateMethods = null;
    private Method[] testMethods = null;
    String[] configAttribNames = null;
    String[] stateAttribNames = null;
    String[] testAttribNames = null;
    private String DPName = null;
    private DiagnosticProviderInfo dpInfo = null;

    public AttributeBeanInfo(Object object, Object object2, Object object3, DiagnosticProviderInfo diagnosticProviderInfo, String string) {
        if (object == null && object2 == null && object3 == null || diagnosticProviderInfo == null) {
            sAttributeBeanInfoLogger.logp(Level.WARNING, sThisClass, "constructor", "RasDiag.All.NullParm");
            return;
        }
        this.configBean = object;
        this.stateBean = object2;
        this.testBean = object3;
        this.DPName = string;
        this.dpInfo = diagnosticProviderInfo;
        boolean bl = false;
        this.configMethods = this.getMethods(this.configBean, "configDump");
        this.configAttribNames = this.getAttribs(this.configMethods);
        this.stateMethods = this.getMethods(this.stateBean, "stateDump");
        this.stateAttribNames = this.getAttribs(this.stateMethods);
        this.testMethods = this.getMethods(this.testBean, "selfDiagnostic");
        this.testAttribNames = this.getAttribs(this.testMethods);
    }

    public void populateMap(String string, HashMap hashMap, boolean bl, String string2) {
        TestInfo[] testInfoArray;
        if (string == null || hashMap == null) {
            testInfoArray = string == null ? "Attrib" : "PayLoad";
            sAttributeBeanInfoLogger.logp(Level.WARNING, sThisClass, "populateMap", "RasDiag.All.NullParm", (Object)testInfoArray);
        }
        if (string2.equals("configDump")) {
            if (this.dpInfo.configInfo == null || this.configBean == null || this.configMethods == null) {
                return;
            }
            this.populateInternal(string, hashMap, bl, this.configAttribNames, this.configMethods, this.dpInfo.configInfo.attributeInfo, this.configBean);
        } else if (string2.equals("selfDiagnostic")) {
            if (this.dpInfo.selfDiagnosticInfo == null || this.dpInfo.selfDiagnosticInfo.testInfo == null || this.testBean == null || this.testMethods == null) {
                return;
            }
            testInfoArray = this.dpInfo.selfDiagnosticInfo.testInfo;
            int n = 0;
            for (int i = 0; i < testInfoArray.length; ++i) {
                n += testInfoArray[i].attributeInfo.length;
            }
            AttributeInfo[] attributeInfoArray = new AttributeInfo[n];
            n = 0;
            for (int i = 0; i < testInfoArray.length; ++i) {
                System.arraycopy(testInfoArray[i].attributeInfo, 0, attributeInfoArray, n, testInfoArray[i].attributeInfo.length);
                n += testInfoArray[i].attributeInfo.length;
            }
            this.populateInternal(string, hashMap, bl, this.testAttribNames, this.testMethods, attributeInfoArray, this.testBean);
        } else {
            if (this.dpInfo.stateInfo == null || this.stateBean == null || this.stateMethods == null) {
                return;
            }
            this.populateInternal(string, hashMap, bl, this.stateAttribNames, this.stateMethods, this.dpInfo.stateInfo.attributeInfo, this.stateBean);
        }
    }

    private Method[] getMethods(Object object, String string) {
        if (object == null) {
            return null;
        }
        ArrayList<Method> arrayList = new ArrayList<Method>(16);
        Class<?> clazz = object.getClass();
        Method[] methodArray = clazz.getMethods();
        if (methodArray == null) {
            sAttributeBeanInfoLogger.logp(Level.WARNING, sThisClass, "getMethods", "RasDiag.Abi.Nogotz", new Object[]{this.DPName, clazz.getName()});
            return null;
        }
        for (int i = 0; i < methodArray.length; ++i) {
            String string2 = methodArray[i].getName();
            if (!string2.startsWith("get") || string2.equals("getClass")) continue;
            arrayList.add(methodArray[i]);
            sAttributeBeanInfoLogger.logp(Level.FINE, sThisClass, "constructor", "  ABI: Type: " + string + " Meth: " + string2);
        }
        Method[] methodArray2 = new Method[arrayList.size()];
        methodArray2 = arrayList.toArray(methodArray2);
        return methodArray2;
    }

    private String[] getAttribs(Method[] methodArray) {
        if (methodArray == null) {
            return null;
        }
        String[] stringArray = new String[methodArray.length];
        for (int i = 0; i < methodArray.length; ++i) {
            stringArray[i] = methodArray[i].getName().substring(3).replace('_', '-');
        }
        return stringArray;
    }

    private void populateInternal(String string, HashMap hashMap, boolean bl, String[] stringArray, Method[] methodArray, AttributeInfo[] attributeInfoArray, Object object) {
        AttributeInfo[] attributeInfoArray2 = DiagnosticProviderHelper.queryMatchingDPInfoAttributes(string, attributeInfoArray, stringArray, bl);
        if (sAttributeBeanInfoLogger.isLoggable(Level.FINE)) {
            int n;
            sAttributeBeanInfoLogger.logp(Level.FINE, sThisClass, "populateInternal", "AttrSpec: " + string + " Payload: " + hashMap.toString() + "RegdOnly: " + bl);
            for (n = 0; n < stringArray.length; ++n) {
                sAttributeBeanInfoLogger.logp(Level.FINE, sThisClass, "populateInternal", n + " fieldNm: " + stringArray[n]);
            }
            for (n = 0; n < attributeInfoArray.length; ++n) {
                sAttributeBeanInfoLogger.logp(Level.FINE, sThisClass, "populateInternal", n + " attribNm: " + attributeInfoArray[n].id);
            }
        }
        Object object2 = null;
        String string2 = null;
        for (int i = 0; i < attributeInfoArray2.length; ++i) {
            boolean bl2 = false;
            for (int j = 0; j < stringArray.length && !bl2; ++j) {
                if (!attributeInfoArray2[i].id.equals(stringArray[j])) continue;
                bl2 = true;
                try {
                    object2 = methodArray[j].invoke(object, (Object[])null);
                    string2 = object2 != null ? object2.toString() : "No Value";
                }
                catch (Exception exception) {
                    sAttributeBeanInfoLogger.logp(Level.WARNING, sThisClass, "populateMap", "RasDiag.Abi.FailedInvoke1", methodArray[j].getName());
                    sAttributeBeanInfoLogger.logp(Level.WARNING, sThisClass, "populateMap", "RasDiag.Abi.FailedInvoke2", exception);
                    string2 = "NULL";
                }
                if (sAttributeBeanInfoLogger.isLoggable(Level.FINE)) {
                    sAttributeBeanInfoLogger.logp(Level.FINE, sThisClass, "populateInternal", "  ABI: Name: " + stringArray[j] + " Val: " + string2);
                }
                hashMap.put(stringArray[j], new DiagnosticTypedValue(string2, attributeInfoArray2[i].descriptionKey));
            }
        }
    }
}

