/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.security.common.auth.module;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.CertificateMapFailedException;
import com.ibm.websphere.security.CertificateMapNotSupportedException;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class IdentityAssertionLoginModule
implements LoginModule {
    protected boolean debug = true;
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private ContextManager contextManager = ContextManagerFactory.getInstance();
    private static final WebSphereRuntimePermission IDENTITY_ASSERTION_INITIALIZE = new WebSphereRuntimePermission("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.initialize");
    private static final WebSphereRuntimePermission IDENTITY_ASSERTION_LOGIN = new WebSphereRuntimePermission("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.login");
    private static final TraceComponent tc = Tr.register(IdentityAssertionLoginModule.class, null, "com.ibm.ejs.resources.security");

    public IdentityAssertionLoginModule() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "IdentityAssertionLoginModule()");
            Tr.exit(tc, "IdentityAssertionLoginModule()");
        }
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(subject = \"" + subject.toString() + "\", callbackHandler = \"" + callbackHandler == null ? "null" : callbackHandler.toString() + "\", sharedState = \"" + map.toString() + "\", options = \"" + map2.toString() + "\")");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check");
                Tr.debug(tc, "Expecting : " + IDENTITY_ASSERTION_INITIALIZE.toString());
            }
            securityManager.checkPermission(IDENTITY_ASSERTION_INITIALIZE);
        }
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = map;
        this.options = map2;
        this.debug = "true".equalsIgnoreCase((String)this.options.get("debug"));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "IdentityAssertionLoginModule");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(subject, callbackHandler, sharedState, options)");
        }
    }

    public boolean login() throws WSLoginFailedException {
        Map map;
        SecurityManager securityManager;
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check");
                Tr.debug(tc, "Expecting : " + IDENTITY_ASSERTION_LOGIN.toString());
            }
            securityManager.checkPermission(IDENTITY_ASSERTION_LOGIN);
        }
        Boolean bl = null;
        Subject subject = null;
        String string = this.contextManager.getDefaultRealm();
        UserRegistry userRegistry = this.contextManager.getRegistry(string);
        this.succeeded = false;
        if (this.commitSucceeded) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "This login module is in a funny state, cleanup before starting a new login process.");
            }
            this.cleanup();
        }
        if ((map = (Map)this.sharedState.get("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.state")) == null) {
            Tr.error(tc, "security.jaas.IdentityAssertion.state");
            WSLoginFailedException wSLoginFailedException = new WSLoginFailedException("No Trust information for trust validation.");
            throw wSLoginFailedException;
        }
        Tr.debug(tc, "We do have state information");
        bl = (Boolean)map.get("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.trusted");
        if (bl == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Missing a trust key");
            }
            WSLoginFailedException wSLoginFailedException = new WSLoginFailedException("No Trust Validator configured for trust validation, identity assertion is disabled.");
            throw wSLoginFailedException;
        }
        if (!bl.booleanValue()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "trust is false");
            }
            WSLoginFailedException wSLoginFailedException = new WSLoginFailedException("No Trust established for trust validation, identity assertion is disabled.");
            throw wSLoginFailedException;
        }
        if (bl.booleanValue()) {
            String string2;
            Principal principal = (Principal)map.get("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.principal");
            X509Certificate[] x509CertificateArray = (X509Certificate[])map.get("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.certificates");
            if (principal == null && x509CertificateArray == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No principal or certificate recieved from shared state.");
                }
                Tr.error(tc, "security.jaas.IdentityAssertion.stat");
                WSLoginFailedException wSLoginFailedException = new WSLoginFailedException("No principal or X509Certificate provided to login new user with.");
                throw wSLoginFailedException;
            }
            if (principal != null) {
                int n;
                string2 = null;
                string2 = principal.getName();
                if (string2 != null && (n = string2.lastIndexOf("/")) >= 0) {
                    string2 = string2.substring(n + 1);
                }
                try {
                    subject = this.contextManager.login(string, string2);
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception when calling contextManager.login");
                    }
                    WSLoginFailedException wSLoginFailedException = new WSLoginFailedException(exception.getMessage(), exception);
                    throw wSLoginFailedException;
                }
            }
            if (x509CertificateArray != null) {
                if (principal != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "There is a principal and a certificate, the principal will be used.");
                    }
                    Tr.warning(tc, "security.jaas.IdentityAssertion.context");
                } else {
                    try {
                        string2 = userRegistry.mapCertificate(x509CertificateArray);
                        subject = this.contextManager.login(string, string2);
                    }
                    catch (CertificateMapFailedException certificateMapFailedException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception when calling contextManager.login");
                        }
                        WSLoginFailedException wSLoginFailedException = new WSLoginFailedException(certificateMapFailedException.getMessage(), certificateMapFailedException);
                        throw wSLoginFailedException;
                    }
                    catch (CertificateMapNotSupportedException certificateMapNotSupportedException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception when calling contextManager.login");
                        }
                        WSLoginFailedException wSLoginFailedException = new WSLoginFailedException(certificateMapNotSupportedException.getMessage(), certificateMapNotSupportedException);
                        throw wSLoginFailedException;
                    }
                    catch (CustomRegistryException customRegistryException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception when calling contextManager.login");
                        }
                        WSLoginFailedException wSLoginFailedException = new WSLoginFailedException(customRegistryException.getMessage(), customRegistryException);
                        throw wSLoginFailedException;
                    }
                    catch (RemoteException remoteException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception when calling contextManager.login");
                        }
                        WSLoginFailedException wSLoginFailedException = new WSLoginFailedException(remoteException.getMessage(), remoteException);
                        throw wSLoginFailedException;
                    }
                    catch (WSLoginFailedException wSLoginFailedException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception when calling contextManager.login");
                        }
                        WSLoginFailedException wSLoginFailedException2 = new WSLoginFailedException(wSLoginFailedException.getMessage(), wSLoginFailedException);
                        throw wSLoginFailedException2;
                    }
                }
            }
            if (subject != null) {
                try {
                    string2 = subject;
                    AccessController.doPrivileged(new PrivilegedExceptionAction((Subject)((Object)string2)){
                        private final /* synthetic */ Subject val$subjectPriv;
                        {
                            this.val$subjectPriv = subject;
                        }

                        public Object run() {
                            Set<Principal> set;
                            Set<Object> set2;
                            Set<Object> set3 = this.val$subjectPriv.getPublicCredentials();
                            if (set3.size() > 0 && !IdentityAssertionLoginModule.this.sharedState.containsValue("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.PublicCredentials")) {
                                IdentityAssertionLoginModule.this.sharedState.put("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.PublicCredentials", set3);
                            }
                            if ((set2 = this.val$subjectPriv.getPrivateCredentials()).size() > 0 && !IdentityAssertionLoginModule.this.sharedState.containsValue("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.PrivateCredentials")) {
                                IdentityAssertionLoginModule.this.sharedState.put("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.PrivateCredentials", set2);
                            }
                            if ((set = this.val$subjectPriv.getPrincipals()).size() > 0 && !IdentityAssertionLoginModule.this.sharedState.containsValue("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.PrivateCredentials")) {
                                IdentityAssertionLoginModule.this.sharedState.put("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.Principals", set);
                            }
                            return null;
                        }
                    });
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Context login succeeded and information stored in shared state.  Shared state: " + this.sharedState);
                    }
                }
                catch (PrivilegedActionException privilegedActionException) {
                    this.contextManager.setRootException(privilegedActionException.getException());
                    throw new WSLoginFailedException(privilegedActionException.getException().getMessage(), privilegedActionException.getException());
                }
                this.succeeded = true;
            }
        }
        return this.succeeded;
    }

    public boolean commit() throws WSLoginFailedException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        boolean bl = false;
        if (!this.succeeded) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Do not commit because of authentication failed.");
            }
            bl = false;
        } else {
            if (!this.commitSucceeded) {
                try {
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "Start committing the changes to the Subject ...");
                    }
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() {
                                Object e2;
                                Iterator iterator;
                                Set set;
                                try {
                                    set = (Set)IdentityAssertionLoginModule.this.sharedState.get("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.Principals");
                                    if (set != null && set.size() > 0) {
                                        iterator = set.iterator();
                                        while (iterator.hasNext()) {
                                            e2 = iterator.next();
                                            if (e2 == null || IdentityAssertionLoginModule.this.subject.getPrincipals().contains(e2)) continue;
                                            IdentityAssertionLoginModule.this.subject.getPrincipals().add((Principal)e2);
                                        }
                                    }
                                }
                                catch (Exception exception) {
                                    Tr.error(tc, "security.jaas.removePrinException", new Object[]{this.getClass().getName(), exception});
                                }
                                try {
                                    set = (Set)IdentityAssertionLoginModule.this.sharedState.get("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.PrivateCredentials");
                                    if (set != null && set.size() > 0) {
                                        iterator = set.iterator();
                                        while (iterator.hasNext()) {
                                            e2 = iterator.next();
                                            if (e2 == null || IdentityAssertionLoginModule.this.subject.getPrivateCredentials().contains(e2)) continue;
                                            IdentityAssertionLoginModule.this.subject.getPrivateCredentials().add(e2);
                                        }
                                    }
                                }
                                catch (Exception exception) {
                                    Tr.error(tc, "security.jaas.removeCredException", new Object[]{this.getClass().getName(), exception});
                                }
                                try {
                                    set = (Set)IdentityAssertionLoginModule.this.sharedState.get("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.PublicCredentials");
                                    if (set != null && set.size() > 0) {
                                        iterator = set.iterator();
                                        while (iterator.hasNext()) {
                                            e2 = iterator.next();
                                            if (e2 == null || IdentityAssertionLoginModule.this.subject.getPublicCredentials().contains(e2)) continue;
                                            IdentityAssertionLoginModule.this.subject.getPublicCredentials().add(e2);
                                        }
                                    }
                                }
                                catch (Exception exception) {
                                    Tr.error(tc, "security.jaas.removeCredExecption", new Object[]{this.getClass().getName(), exception});
                                }
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        this.contextManager.setRootException(privilegedActionException.getException());
                        throw new WSLoginFailedException(privilegedActionException.getException().getMessage(), privilegedActionException.getException());
                    }
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "Change committed!");
                    }
                    this.commitSucceeded = true;
                }
                catch (Exception exception) {
                    Tr.error(tc, "security.jaas.LoginModuleCommitError", new Object[]{this.getClass().getName(), exception});
                    this.cleanup();
                    this.commitSucceeded = false;
                }
            } else if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "It has been committed prior this call, nothing is done.");
            }
            bl = this.commitSucceeded;
        }
        return bl;
    }

    public boolean abort() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup the Subject, removes principals, private credentials, and public credentials from the Subject, reset all internal variables.");
            Tr.debug(tc, "Start cleanup ...");
        }
        this.cleanup();
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup done.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        this.cleanupSharedState();
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return true;
    }

    private void cleanup() {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanup()");
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Start removing the principal set, private credential set, and public credential set from the Subject.");
            Tr.debug(tc, "Start removing ...");
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Object e2;
                Iterator iterator;
                Set set;
                try {
                    set = (Set)IdentityAssertionLoginModule.this.sharedState.get("com.ibm.wsspi.common.auth.module.IdentityAssertionLoginModule.Principals");
                    if (set != null && set.size() > 0) {
                        iterator = set.iterator();
                        while (iterator.hasNext()) {
                            e2 = iterator.next();
                            if (e2 == null || !IdentityAssertionLoginModule.this.subject.getPrincipals().contains(e2)) continue;
                            IdentityAssertionLoginModule.this.subject.getPrincipals().remove(e2);
                        }
                    }
                }
                catch (Exception exception) {
                    Tr.error(tc, "security.jaas.removeCredException", new Object[]{this.getClass().getName(), exception});
                }
                try {
                    set = (Set)IdentityAssertionLoginModule.this.sharedState.get("com.ibm.wsspi.common.auth.module.IdenityAssertionLoginModule.PrivateCredentials");
                    if (set != null && set.size() > 0) {
                        iterator = set.iterator();
                        while (iterator.hasNext()) {
                            e2 = iterator.next();
                            if (e2 == null || !IdentityAssertionLoginModule.this.subject.getPrivateCredentials().contains(e2)) continue;
                            IdentityAssertionLoginModule.this.subject.getPrivateCredentials().remove(e2);
                        }
                    }
                }
                catch (Exception exception) {
                    Tr.error(tc, "security.jaas.removeCredException", new Object[]{this.getClass().getName(), exception});
                }
                try {
                    set = (Set)IdentityAssertionLoginModule.this.sharedState.get("com.ibm.wsspi.common.auth.module.IdentityAssertionLoginModule.publicCredentials");
                    if (set != null && set.size() > 0) {
                        iterator = set.iterator();
                        while (iterator.hasNext()) {
                            e2 = iterator.next();
                            if (e2 == null || !IdentityAssertionLoginModule.this.subject.getPublicCredentials().contains(e2)) continue;
                            IdentityAssertionLoginModule.this.subject.getPublicCredentials().remove(e2);
                        }
                    }
                }
                catch (Exception exception) {
                    Tr.error(tc, "security.jaas.removeCredExecption", new Object[]{this.getClass().getName(), exception});
                }
                return null;
            }
        });
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Removed principals and creds.");
        }
        this.cleanupSharedState();
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanup()");
        }
    }

    private void cleanupSharedState() {
        Set set;
        Set set2;
        Set set3;
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanupSharedState()");
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Start removing principalSet, privateSet and publicSet from the shared state.");
        }
        if ((set3 = (Set)this.sharedState.get("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.Principals")) != null) {
            this.sharedState.remove("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.Principals");
        }
        if ((set2 = (Set)this.sharedState.get("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.PrivateCredentials")) != null) {
            this.sharedState.remove("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.PrivateCredentials");
        }
        if ((set = (Set)this.sharedState.get("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.PublicCredentials")) != null) {
            this.sharedState.remove("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.PublicCredentials");
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Removed.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanupSharedState()");
        }
    }
}

