/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.sip.channel;

import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.genericbnf.GenericMessage;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import com.ibm.wsspi.http.channel.values.StatusCodes;
import com.ibm.wsspi.sip.channelutils.BNFHeaderKeys;
import com.ibm.wsspi.sip.channelutils.ContentEncodingValues;
import com.ibm.wsspi.sip.channelutils.EncodingValues;
import com.ibm.wsspi.sip.channelutils.MethodValue;
import com.ibm.wsspi.sip.channelutils.SchemeValues;
import com.ibm.wsspi.sip.channelutils.VersionValues;
import java.io.IOException;
import java.net.InetSocketAddress;

public interface SIPMessage
extends GenericMessage {
    public static final boolean useCompactHeaders = false;
    public static final int NUM_VERSIONS = 2;
    public static final VersionValues SIP_VERSION_10 = new VersionValues("SIP/1.0", 2);
    public static final VersionValues SIP_VERSION_20 = new VersionValues("SIP/2.0", 2);
    public static final int NUM_METHODS = 17;
    public static final MethodValue METHOD_MESSAGE = new MethodValue("MESSAGE", 17);
    public static final MethodValue METHOD_PUBLISH = new MethodValue("PUBLISH", 17);
    public static final MethodValue METHOD_INVITE = new MethodValue("INVITE", 17);
    public static final MethodValue METHOD_ACK = new MethodValue("ACK", 17);
    public static final MethodValue METHOD_BYE = new MethodValue("BYE", 17);
    public static final MethodValue METHOD_CANCEL = new MethodValue("CANCEL", 17);
    public static final MethodValue METHOD_REGISTER = new MethodValue("REGISTER", 17);
    public static final MethodValue METHOD_OPTIONS = new MethodValue("OPTIONS", 17);
    public static final MethodValue METHOD_INFO = new MethodValue("INFO", 17);
    public static final MethodValue METHOD_PRACK = new MethodValue("PRACK", 17);
    public static final MethodValue METHOD_COMET = new MethodValue("COMET", 17);
    public static final MethodValue METHOD_REFER = new MethodValue("REFER", 17);
    public static final MethodValue METHOD_SUBSCRIBE = new MethodValue("SUBSCRIBE", 17);
    public static final MethodValue METHOD_UNSUBSCRIBE = new MethodValue("UNSUBSCRIBE", 17);
    public static final MethodValue METHOD_NOTIFY = new MethodValue("NOTIFY", 17);
    public static final MethodValue METHOD_KEEPALIVE = new MethodValue("KEEPALIVE", 17);
    public static final MethodValue METHOD_STARTUP = new MethodValue("STARTUP", 17);
    public static final int NUM_SCHEMES = 2;
    public static final SchemeValues SCHEME_SIP = new SchemeValues("sip", 2);
    public static final SchemeValues SCHEME_SIPS = new SchemeValues("sips", 2);
    public static final StatusCodes STATUS_TRYING = new StatusCodes(100, "Trying", false);
    public static final StatusCodes STATUS_RINGING = new StatusCodes(180, "Ringing", false);
    public static final StatusCodes STATUS_CALL_IS_BEING_FORWARDED = new StatusCodes(181, "Call Is Being Forwarded", false);
    public static final StatusCodes STATUS_QUEUED = new StatusCodes(182, "Queued", false);
    public static final StatusCodes STATUS_SESSION_PROGRESS = new StatusCodes(183, "Session Progress", false);
    public static final StatusCodes STATUS_OK = new StatusCodes(200, "OK", false);
    public static final StatusCodes STATUS_MULTIPLE_CHOICES = new StatusCodes(300, "Multiple Choices", false);
    public static final StatusCodes STATUS_MOVED_PERMANENTLY = new StatusCodes(301, "Moved Permanently", false);
    public static final StatusCodes STATUS_MOVED_TEMPORARILY = new StatusCodes(302, "Moved Temporarily", false);
    public static final StatusCodes STATUS_USE_PROXY = new StatusCodes(305, "Use Proxy", false);
    public static final StatusCodes STATUS_ALTERNATE_SERVICE = new StatusCodes(380, "Alternate Service", false);
    public static final StatusCodes STATUS_BAD_REQUEST = new StatusCodes(400, "Bad Request", true);
    public static final StatusCodes STATUS_UNAUTHORIZED = new StatusCodes(401, "Unauthorized", false);
    public static final StatusCodes STATUS_PAYMENT_REQUIRED = new StatusCodes(402, "Payment Required", false);
    public static final StatusCodes STATUS_FORBIDDEN = new StatusCodes(403, "Forbidden", true);
    public static final StatusCodes STATUS_NOT_FOUND = new StatusCodes(404, "Not Found", true);
    public static final StatusCodes STATUS_METHOD_NOT_ALLOWED = new StatusCodes(405, "Method Not Allowed", true);
    public static final StatusCodes STATUS_NOT_ACCEPTABLE = new StatusCodes(406, "Not Acceptable", true);
    public static final StatusCodes STATUS_PROXY_AUTHENTICATION_REQUIRED = new StatusCodes(407, "Proxy Authentication Required", false);
    public static final StatusCodes STATUS_REQUEST_TIMEOUT = new StatusCodes(408, "Request Timeout", true);
    public static final StatusCodes STATUS_GONE = new StatusCodes(410, "Gone", true);
    public static final StatusCodes STATUS_REQUEST_ENTITY_TOO_LARGE = new StatusCodes(413, "Request Entity Too Large", true);
    public static final StatusCodes STATUS_REQUEST_URI_TOO_LONG = new StatusCodes(414, "Request-URI Too Long", true);
    public static final StatusCodes STATUS_UNSUPPORTED_MEDIA_TYPE = new StatusCodes(415, "Unsupported Media Type", true);
    public static final StatusCodes STATUS_REQUEST_BAD_EXTENSION = new StatusCodes(420, "Bad Extension", true);
    public static final StatusCodes STATUS_REQUEST_EXTENSION_REQUIRED = new StatusCodes(421, "Extension Required", true);
    public static final StatusCodes STATUS_REQUEST_INTERVAL_TOO_BRIEF = new StatusCodes(423, "Interval Too Brief", true);
    public static final StatusCodes STATUS_REQUEST_TEMPORARILY_UNAVAILABLE = new StatusCodes(480, "Temporarily Unavailable", true);
    public static final StatusCodes STATUS_REQUEST_CALL_TRANSACTION_DOES_NOT_EXIST = new StatusCodes(481, "Call/Transaction Does Not Exist", true);
    public static final StatusCodes STATUS_REQUEST_LOOP_DETECTED = new StatusCodes(482, "Loop Detected", true);
    public static final StatusCodes STATUS_REQUEST_TOO_MANY_HOPS = new StatusCodes(483, "Too Many Hops", true);
    public static final StatusCodes STATUS_ADDRESS_INCOMPLETE = new StatusCodes(484, "Address Incomplete", true);
    public static final StatusCodes STATUS_AMBIGUOUS = new StatusCodes(485, "Ambiguous", true);
    public static final StatusCodes STATUS_BUSY_HERE = new StatusCodes(486, "Busy Here", true);
    public static final StatusCodes STATUS_REQUEST_TERMINATED = new StatusCodes(487, "Request Terminated", true);
    public static final StatusCodes STATUS_NOT_ACCEPTED_HERE = new StatusCodes(488, "Not Accepted Here", true);
    public static final StatusCodes STATUS_REQUEST_PENDING = new StatusCodes(491, "Request Pending", true);
    public static final StatusCodes STATUS_UNDECIPHERABLE = new StatusCodes(493, "Undecipherable", true);
    public static final StatusCodes STATUS_INTERNAL_ERROR = new StatusCodes(500, "Internal Server Error", true);
    public static final StatusCodes STATUS_NOT_IMPLEMENTED = new StatusCodes(501, "Not Implemented", true);
    public static final StatusCodes STATUS_BAD_GATEWAY = new StatusCodes(502, "Bad Gateway", true);
    public static final StatusCodes STATUS_UNAVAILABLE = new StatusCodes(503, "Service Unavailable", true);
    public static final StatusCodes STATUS_SERVER_TIMEOUT = new StatusCodes(504, "Server Time-out", true);
    public static final StatusCodes STATUS_VERSION = new StatusCodes(505, "Version Not Supported", true);
    public static final StatusCodes STATUS_MESSAGE_TOO_LARGE = new StatusCodes(513, "Message Too Large", true);
    public static final StatusCodes STATUS_BUSY_EVERYWHERE = new StatusCodes(600, "Busy Everywhere", true);
    public static final StatusCodes STATUS_DECLINE = new StatusCodes(603, "Decline", true);
    public static final StatusCodes STATUS_DOES_NOT_EXIST_ANYWHERE = new StatusCodes(604, "Does Not Exist Anywhere", true);
    public static final StatusCodes STATUS_SD_NOT_ACCEPTABLE = new StatusCodes(606, "Not Acceptable", true);
    public static final int NUM_HEADERS = 52;
    public static final BNFHeaderKeys HDR_ACCEPT = new BNFHeaderKeys("Accept", 52);
    public static final BNFHeaderKeys HDR_ACCEPT_ENCODING = new BNFHeaderKeys("Accept-Encoding", 52);
    public static final BNFHeaderKeys HDR_ACCEPT_LANGUAGE = new BNFHeaderKeys("Accept-Language", 52);
    public static final BNFHeaderKeys HDR_ALERT_INFO = new BNFHeaderKeys("Alert-Info", 52);
    public static final BNFHeaderKeys HDR_ALLOW = new BNFHeaderKeys("Allow", 52);
    public static final BNFHeaderKeys HDR_AUTHENTICATION_INFO = new BNFHeaderKeys("Authentication-Info", 52);
    public static final BNFHeaderKeys HDR_AUTHORIZATION = new BNFHeaderKeys("Authorization", 52);
    public static final BNFHeaderKeys HDR_CALL_ID = new BNFHeaderKeys("Call-ID", "i", 52);
    public static final BNFHeaderKeys HDR_CALL_INFO = new BNFHeaderKeys("Call-Info", 52);
    public static final BNFHeaderKeys HDR_CONTACT = new BNFHeaderKeys("Contact", "m", 52);
    public static final BNFHeaderKeys HDR_CONTENT_DISPOSITION = new BNFHeaderKeys("Content-Disposition", 52);
    public static final BNFHeaderKeys HDR_CONTENT_ENCODING = new BNFHeaderKeys("Content-Encoding", "e", 52);
    public static final BNFHeaderKeys HDR_CONTENT_LANGUAGE = new BNFHeaderKeys("Content-Language", 52);
    public static final BNFHeaderKeys HDR_CONTENT_LENGTH = new BNFHeaderKeys("Content-Length", "l", 52);
    public static final BNFHeaderKeys HDR_CONTENT_TYPE = new BNFHeaderKeys("Content-Type", "c", 52);
    public static final BNFHeaderKeys HDR_CSEQ = new BNFHeaderKeys("CSeq", 52);
    public static final BNFHeaderKeys HDR_DATE = new BNFHeaderKeys("Date", 52);
    public static final BNFHeaderKeys HDR_ERROR_INFO = new BNFHeaderKeys("Error-Info", 52);
    public static final BNFHeaderKeys HDR_EXPIRES = new BNFHeaderKeys("Expires", 52);
    public static final BNFHeaderKeys HDR_FROM = new BNFHeaderKeys("From", "f", 52);
    public static final BNFHeaderKeys HDR_IN_REPLY_TO = new BNFHeaderKeys("In-Reply-To", 52);
    public static final BNFHeaderKeys HDR_MAX_FORWARDS = new BNFHeaderKeys("Max-Forwards", 52);
    public static final BNFHeaderKeys HDR_MIN_EXPIRES = new BNFHeaderKeys("Min-Expires", 52);
    public static final BNFHeaderKeys HDR_MIME_VERSION = new BNFHeaderKeys("MIME-Version", 52);
    public static final BNFHeaderKeys HDR_ORGANIZATION = new BNFHeaderKeys("Organization", 52);
    public static final BNFHeaderKeys HDR_PRIORITY = new BNFHeaderKeys("Priority", 52);
    public static final BNFHeaderKeys HDR_PROXY_AUTHENTICATE = new BNFHeaderKeys("Proxy-Authenticate", 52);
    public static final BNFHeaderKeys HDR_PROXY_AUTHORIZATION = new BNFHeaderKeys("Proxy-Authorization", 52);
    public static final BNFHeaderKeys HDR_PROXY_REQUIRE = new BNFHeaderKeys("Proxy-Require", 52);
    public static final BNFHeaderKeys HDR_RECORD_ROUTE = new BNFHeaderKeys("Record-Route", 52);
    public static final BNFHeaderKeys HDR_REFER_TO = new BNFHeaderKeys("Refer-To", "r", 52);
    public static final BNFHeaderKeys HDR_REPLY_TO = new BNFHeaderKeys("Reply-To", 52);
    public static final BNFHeaderKeys HDR_REQUIRE = new BNFHeaderKeys("Require", 52);
    public static final BNFHeaderKeys HDR_RETRY_AFTER = new BNFHeaderKeys("Retry-After", 52);
    public static final BNFHeaderKeys HDR_ROUTE = new BNFHeaderKeys("Route", 52);
    public static final BNFHeaderKeys HDR_SERVER = new BNFHeaderKeys("Server", 52);
    public static final BNFHeaderKeys HDR_SUBJECT = new BNFHeaderKeys("Subject", "s", 52);
    public static final BNFHeaderKeys HDR_SUPPORTED = new BNFHeaderKeys("Supported", "k", 52);
    public static final BNFHeaderKeys HDR_TIMESTAMP = new BNFHeaderKeys("Timestamp", 52);
    public static final BNFHeaderKeys HDR_TO = new BNFHeaderKeys("To", "t", 52);
    public static final BNFHeaderKeys HDR_UNSUPPORTED = new BNFHeaderKeys("Unsupported", 52);
    public static final BNFHeaderKeys HDR_USER_AGENT = new BNFHeaderKeys("User-Agent", 52);
    public static final BNFHeaderKeys HDR_VIA = new BNFHeaderKeys("Via", "v", 52);
    public static final BNFHeaderKeys HDR_WARNING = new BNFHeaderKeys("Warning", 52);
    public static final BNFHeaderKeys HDR_WWW_AUTHENTICATE = new BNFHeaderKeys("WWW-Authenticate", 52);
    public static final BNFHeaderKeys HDR_COOKIE = new BNFHeaderKeys("Cookie", 52);
    public static final BNFHeaderKeys HDR_EVENT = new BNFHeaderKeys("Event", 52);
    public static final BNFHeaderKeys HDR_LWP_SESSION_ID = new BNFHeaderKeys("LWP-Session-Id", 52);
    public static final BNFHeaderKeys HDR_ALLOW_EVENTS = new BNFHeaderKeys("Allow-Events", 52);
    public static final BNFHeaderKeys HDR_IDENTITY_ASSERTED = new BNFHeaderKeys("P-Asserted-Identity", 52);
    public static final BNFHeaderKeys HDR_PREFFERED_IDENTITY = new BNFHeaderKeys("P-Preferred-Identity", 52);
    public static final BNFHeaderKeys HDR_CLIENT_ADDRESS = new BNFHeaderKeys("IBM-Client-Address", 52);
    public static final int NUM_CONTENT_ENCODING_VALUES = 5;
    public static final ContentEncodingValues CONTENT_ENCODING_GZIP = new ContentEncodingValues("gzip", 5);
    public static final ContentEncodingValues CONTENT_ENCODING_CHUNKED = new ContentEncodingValues("chunked", 5);
    public static final ContentEncodingValues CONTENT_ENCODING_IDENTITY = new ContentEncodingValues("identity", 5);
    public static final ContentEncodingValues CONTENT_ENCODING_COMPRESS = new ContentEncodingValues("compress", 5);
    public static final ContentEncodingValues CONTENT_ENCODING_DEFLATE = new ContentEncodingValues("deflate", 5);
    public static final EncodingValues ENCODING_GZIP = new EncodingValues("gzip");
    public static final EncodingValues ENCODING_COMPRESS = new EncodingValues("compress");
    public static final EncodingValues ENCODING_DEFLATE = new EncodingValues("deflate");
    public static final EncodingValues ENCODING_IDENTITY = new EncodingValues("identity");
    public static final EncodingValues ENCODING_CHUNKED = new EncodingValues("chunked");

    public boolean isRequest();

    public SIPMessage getDuplicate();

    public String getTo();

    public void setTo(String var1);

    public String getFrom();

    public void setFrom(String var1);

    public void setRequest(boolean var1);

    public String getRequestUri();

    public void setRequestUri(String var1);

    public MethodValue getRequestMethod();

    public void setRequestMethod(MethodValue var1);

    public int getResultCode();

    public void setResultCode(int var1);

    public String getHeaderValue(String var1);

    public void setHeaderValue(String var1, String var2);

    public void setHeaderValue(BNFHeaderKeys var1, String var2);

    public String getHeaderValue(BNFHeaderKeys var1);

    public void setBodyBuffer(WsByteBuffer var1) throws IOException;

    public WsByteBuffer getBodyBuffer() throws IOException;

    public void destroy();

    public void clear();

    public WsByteBuffer[] getMarshalledHeaders() throws MessageSentException;

    public String retrieveHeaderInUTF8Format(BNFHeaderKeys var1, int var2);

    public boolean parseMessage(WsByteBuffer var1) throws Exception;

    public WsByteBuffer[] marshallMessage() throws MessageSentException;

    public Object getOpaqueData();

    public void setOpaqueData(Object var1);

    public void printMessage();

    public void setMethod(String var1);

    public String getMethod();

    public byte[] getStartLine();

    public void setStartLine(byte[] var1);

    public InetSocketAddress getLocalAddress();

    public InetSocketAddress getRemoteAddress();

    public void setLocalAddress(InetSocketAddress var1);

    public void setRemoteAddress(InetSocketAddress var1);

    public void convertToResponse(StatusCodes var1);

    public String getStringRepresentation();

    public void setFirstToken(byte[] var1);

    public byte[] getFirstToken();

    public String getFirstTokenAsString();

    public void setSecondToken(byte[] var1);

    public byte[] getSecondToken();

    public String getSecondTokenAsString();

    public void setThirdToken(byte[] var1);

    public byte[] getThirdToken();

    public String getThirdTokenAsString();

    public void release();

    public void lookForDuplicateHeaderValues(BNFHeaderKeys var1);
}

