/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.sip.channel.protocol;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.sip.channelutils.MethodMatcher;
import com.ibm.wsspi.sip.channelutils.MethodValue;
import com.ibm.wsspi.sip.channelutils.impl.MethodMatcherImpl;
import java.util.StringTokenizer;

public class CSeqHeader {
    protected MethodMatcher methodMatcher = MethodMatcherImpl.getRef();
    String sequenceNumber = null;
    MethodValue method = null;
    private static TraceComponent tc = Tr.register(CSeqHeader.class, "WebSphere SIP Channel", "com.ibm.ws.sip.channel.resources.sipchannel");

    public static CSeqHeader parseCSeqHeader(String string) {
        CSeqHeader cSeqHeader = null;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            if (stringTokenizer.countTokens() == 2) {
                cSeqHeader = new CSeqHeader();
                cSeqHeader.setSequenceNumber(stringTokenizer.nextToken());
                cSeqHeader.setMethod(stringTokenizer.nextToken());
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parseCSeqHeader: Caught Exception " + exception.getMessage());
            }
            cSeqHeader = null;
        }
        return cSeqHeader;
    }

    public String getSequenceNumber() {
        return this.sequenceNumber;
    }

    public MethodValue getMethod() {
        return this.method;
    }

    public boolean hasSequenceNumber() {
        return this.sequenceNumber != null;
    }

    public boolean hasMethod() {
        return this.method != null;
    }

    public void setSequenceNumber(String string) {
        this.sequenceNumber = string;
    }

    public void setMethod(String string) {
        this.method = this.methodMatcher.matchMethod(string);
    }
}

