/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.sip.channel.protocol;

import com.ibm.wsspi.sip.channel.protocol.SIPUri;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class MeetingUri
extends SIPUri {
    private static final String DELIMITER = "-";
    private static final String defaultMeetingPrefix;
    private static final String defaultNWayPrefix;
    private String meetingIdPrefix;
    private String meetingId;

    public MeetingUri() {
        this.init();
    }

    public MeetingUri(String string) {
        super.setURI(string);
        this.init();
        this.parseMeetingUri();
    }

    private void init() {
        this.setMeetingIdPrefix("");
        this.setMeetingId("");
    }

    private static String[] constructDefaultPrefixes() {
        String string = "";
        String string2 = "";
        Properties properties = new Properties();
        try {
            InputStream inputStream = MeetingUri.class.getClassLoader().getResourceAsStream("sip-prefix-config.properties");
            if (inputStream != null) {
                properties.load(MeetingUri.class.getClassLoader().getResourceAsStream("sip-prefix-config.properties"));
                if (properties.getProperty("scheduled_conference_prefix") != null) {
                    string = properties.getProperty("scheduled_conference_prefix");
                }
                if (properties.getProperty("nway_conference_prefix") != null) {
                    string2 = properties.getProperty("nway_conference_prefix");
                }
            } else {
                System.err.println("Did not find the file sip-prefix-config.properties -- using defaults");
            }
        }
        catch (IOException iOException) {
            System.err.println("Did not find the file sip-prefix-config.properties -- using defaults");
        }
        return new String[]{string, string2};
    }

    public String getMeetingId() {
        return this.meetingId;
    }

    public void setMeetingId(String string) {
        this.meetingId = string;
        this.updateUserInfo();
    }

    public String getMeetingIdPrefix() {
        return this.meetingIdPrefix;
    }

    public void setMeetingIdPrefix(String string) {
        this.meetingIdPrefix = string;
        this.updateUserInfo();
    }

    private void parseMeetingUri() {
        int n;
        String string = this.getUserInfo();
        if (string != null && (n = string.indexOf(DELIMITER)) != -1) {
            this.meetingIdPrefix = string.substring(0, n);
            this.meetingId = string.substring(n + 1);
        }
    }

    private void updateUserInfo() {
        this.setUserInfo(this.getMeetingIdPrefix() + MeetingUri.getDelimiter() + this.getMeetingId());
    }

    public String getDefaultMeetingPrefix() {
        return defaultMeetingPrefix;
    }

    public String getDefaultNWayPrefix() {
        return defaultNWayPrefix;
    }

    public static String getDelimiter() {
        return DELIMITER;
    }

    static {
        String[] stringArray = MeetingUri.constructDefaultPrefixes();
        defaultMeetingPrefix = stringArray[0];
        defaultNWayPrefix = stringArray[1];
    }
}

