/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.sip.channel.protocol;

import com.ibm.wsspi.sip.channel.exception.InvalidSIPNameAddrException;
import com.ibm.wsspi.sip.channel.protocol.SIPUri;

public class NameAddr
extends SIPUri {
    public static final String SIP_SCHEME = "sip:";
    public static final String SIPS_SCHEME = "sips:";
    public static final String LAQUOT = "<";
    public static final String RAQUOT = ">";
    public static final String SEMI = ";";
    public static final String AT_SIGN = "@";
    public static final String COLON = ":";
    public static final String EXPIRES = "expires=";
    public static final String TAG = "tag=";
    protected String displayName = "";
    public String additionalNameAddrParms = "";
    public boolean parsed = false;

    public void parseHeader(String string) throws InvalidSIPNameAddrException {
        int n;
        int n2;
        int n3;
        int n4 = string.indexOf(LAQUOT);
        if (n4 == -1) {
            this.setURI(string);
            this.parseUri();
            return;
        }
        this.parsed = true;
        if (n4 != 0) {
            this.displayName = string.substring(0, n4);
        }
        if ((n3 = string.indexOf(SIP_SCHEME, n4)) == -1) {
            n3 = string.indexOf(SIPS_SCHEME, n4);
        }
        if (n3 != -1) {
            n2 = string.indexOf(SEMI, n3);
            n = string.indexOf(RAQUOT, n3);
            if (n == -1) {
                throw new InvalidSIPNameAddrException("No ending to name-addr value for sip:");
            }
            if (n2 == -1 || n2 > n) {
                n2 = n;
            }
        } else {
            throw new InvalidSIPNameAddrException("Bad URI Scheme");
        }
        this.setURI(string.substring(n3, n));
        this.additionalNameAddrParms = string.substring(n2 + 1);
    }

    public String marshall() throws InvalidSIPNameAddrException {
        String string = "";
        if (this.displayName != "") {
            string = string + this.displayName;
        }
        string = string + LAQUOT;
        string = string + this.getURI();
        string = string + RAQUOT;
        return string;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getExpiresParameter() {
        int n = -1;
        String string = null;
        string = this.additionalNameAddrParms.length() == 0 ? this.getAdditionalParms() : this.additionalNameAddrParms;
        int n2 = string.indexOf(EXPIRES);
        if (n2 != -1) {
            String string2 = string.substring(n2 + EXPIRES.length());
            n = Integer.parseInt(string2);
        }
        return n;
    }

    public String getTagParameter() {
        String string = "";
        String string2 = null;
        string2 = this.additionalNameAddrParms.length() == 0 ? this.getAdditionalParms() : this.additionalNameAddrParms;
        int n = string2.indexOf(TAG);
        if (n != -1) {
            string = string2.substring(n + TAG.length());
        }
        return string;
    }
}

