/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.sip.channel.protocol;

import com.ibm.wsspi.sip.channel.exception.InvalidSIPRecordRouteHeaderException;
import com.ibm.wsspi.sip.channel.protocol.ViaHeader;
import java.util.StringTokenizer;

public class RecordRouteHeader {
    public static final String DEFAULT_SENT_PROTOCOL_TCP = "SIP/2.0/TCP";
    public static final String DEFAULT_SENT_PROTOCOL_UDP = "SIP/2.0/UDP";
    private static final String TTL = "ttl";
    private static final String MADDR = "maddr";
    private static final String RECEIVED = "received";
    private static final String BRANCH = "branch";
    String protocol = null;
    String protocolVersion = null;
    String sentBy = null;
    String ttl = null;
    String mAddr = null;
    String received = null;
    String branchId = null;

    public static ViaHeader parseViaHeader(String string) throws InvalidSIPRecordRouteHeaderException {
        ViaHeader viaHeader = new ViaHeader();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            if (stringTokenizer.countTokens() > 0) {
                viaHeader.setProtocol(stringTokenizer.nextToken());
            }
            if (stringTokenizer.countTokens() > 0) {
                String string2 = null;
                while (stringTokenizer.countTokens() > 0) {
                    string2 = string2 + stringTokenizer.nextToken();
                }
                stringTokenizer = new StringTokenizer(string2, ";");
                viaHeader.setSentBy(stringTokenizer.nextToken());
                while (stringTokenizer.countTokens() > 0) {
                    StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "=");
                    if (stringTokenizer2.countTokens() == 2) {
                        String string3 = stringTokenizer2.nextToken();
                        String string4 = stringTokenizer2.nextToken();
                        if (string3.equals(TTL)) {
                            viaHeader.setTtl(string4);
                            continue;
                        }
                        if (string3.equals(MADDR)) {
                            viaHeader.setMAddr(string4);
                            continue;
                        }
                        if (string3.equals(RECEIVED)) {
                            viaHeader.setReceived(string4);
                            continue;
                        }
                        if (!string3.equals(BRANCH)) continue;
                        viaHeader.setBranchId(string4);
                        continue;
                    }
                    throw new InvalidSIPRecordRouteHeaderException("Bad token count");
                }
            }
        }
        catch (Exception exception) {
            throw new InvalidSIPRecordRouteHeaderException(exception.getMessage());
        }
        return viaHeader;
    }

    public String marshallHeader() throws InvalidSIPRecordRouteHeaderException {
        if (!this.hasProtocol() || !this.hasSentBy()) {
            throw new InvalidSIPRecordRouteHeaderException("No protocol or sent by values");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getProtocol() + " ");
        stringBuffer.append(this.getSentBy());
        if (this.hasTtl()) {
            stringBuffer.append(";ttl=" + this.getTtl());
        }
        if (this.hasMAddr()) {
            stringBuffer.append(";maddr=" + this.getMAddr());
        }
        if (this.hasReceived()) {
            stringBuffer.append(";received=" + this.getReceived());
        }
        if (this.hasBranchId()) {
            stringBuffer.append(";branch=" + this.getBranchId());
        }
        return stringBuffer.toString();
    }

    public String getBranchId() {
        return this.branchId;
    }

    public String getMAddr() {
        return this.mAddr;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getReceived() {
        return this.received;
    }

    public String getSentBy() {
        return this.sentBy;
    }

    public String getTtl() {
        return this.ttl;
    }

    public boolean hasBranchId() {
        return this.branchId != null;
    }

    public boolean hasMAddr() {
        return this.mAddr != null;
    }

    public boolean hasProtocol() {
        return this.protocol != null;
    }

    public boolean hasReceived() {
        return this.received != null;
    }

    public boolean hasSentBy() {
        return this.sentBy != null;
    }

    public boolean hasTtl() {
        return this.ttl != null;
    }

    public void setBranchId(String string) {
        this.branchId = string;
    }

    public void setMAddr(String string) {
        this.mAddr = string;
    }

    public void setProtocol(String string) {
        this.protocol = string;
    }

    public void setReceived(String string) {
        this.received = string;
    }

    public void setSentBy(String string) {
        this.sentBy = string;
    }

    public void setTtl(String string) {
        this.ttl = string;
    }
}

