/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.sip.channel.protocol;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class SIPUri {
    static final TraceComponent tc = Tr.register(SIPUri.class, "WebSphere SIP Channel", "com.ibm.ws.sip.channel.resources.sipchannel");
    public static final String SIP_SCHEME = "sip:";
    public static final String SIPS_SCHEME = "sips:";
    private String URI = null;
    private String scheme = null;
    private String userInfo = null;
    private String host = null;
    private String port = null;
    private String mAddr = null;
    private String transport = null;
    protected String additionalParameters = null;
    boolean changed = false;
    boolean parsed = false;
    private boolean ipV6addr = false;

    public static SIPUri createSIPUri(String string) {
        SIPUri sIPUri = new SIPUri();
        sIPUri.setURI(string);
        return sIPUri;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof SIPUri)) {
            return false;
        }
        this.parseUri();
        SIPUri sIPUri = (SIPUri)object;
        if (this.scheme == null) {
            if (sIPUri.getScheme() != null) {
                return false;
            }
        } else {
            if (sIPUri.getScheme() == null) {
                return false;
            }
            if (!sIPUri.getScheme().equals(this.scheme)) {
                return false;
            }
        }
        if (this.host == null) {
            if (sIPUri.getHost() != null) {
                return false;
            }
        } else {
            if (sIPUri.getHost() == null) {
                return false;
            }
            if (!sIPUri.getHost().equals(this.host)) {
                return false;
            }
        }
        if (this.port == null) {
            if (sIPUri.getPort() != null) {
                return false;
            }
        } else {
            if (sIPUri.getPort() == null) {
                return false;
            }
            if (!sIPUri.getPort().equals(this.port)) {
                return false;
            }
        }
        if (this.mAddr == null) {
            if (sIPUri.getMaddr() != null) {
                return false;
            }
        } else {
            if (sIPUri.getMaddr() == null) {
                return false;
            }
            if (!sIPUri.getMaddr().equals(this.mAddr)) {
                return false;
            }
        }
        if (this.transport == null) {
            if (sIPUri.getTransport() != null) {
                return false;
            }
        } else {
            if (sIPUri.getTransport() == null) {
                return false;
            }
            if (!sIPUri.getTransport().equals(this.transport)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        if (this.scheme != null) {
            n += this.scheme.hashCode();
        }
        if (this.host != null) {
            n += this.host.hashCode();
        }
        if (this.port != null) {
            n += this.port.hashCode();
        }
        if (this.mAddr != null) {
            n += this.mAddr.hashCode();
        }
        if (this.transport != null) {
            n += this.transport.hashCode();
        }
        return n;
    }

    public String getURI() {
        if (this.changed) {
            this.changed = false;
            this.URI = this.scheme;
            if (this.userInfo != null) {
                this.URI = this.URI + this.userInfo + "@";
            }
            this.URI = this.URI + this.host;
            if (this.port != null) {
                this.URI = this.URI + ":" + this.port;
            }
            this.URI = this.URI + this.additionalParameters;
        }
        return this.URI;
    }

    public void setURI(String string) {
        this.URI = string;
        this.changed = false;
        this.parsed = false;
        this.scheme = null;
        this.userInfo = null;
        this.host = null;
        this.port = null;
        this.mAddr = null;
        this.transport = null;
        this.additionalParameters = null;
    }

    protected void parseUri() {
        if (!this.parsed && this.URI != null) {
            this.parsed = true;
            String string = this.URI;
            int n = string.indexOf("<");
            if (n != -1) {
                string = string.substring(n + 1);
            }
            this.scheme = (n = string.indexOf(SIP_SCHEME)) == -1 ? ((n = string.indexOf(SIPS_SCHEME)) == -1 ? new String(string.substring(0, string.indexOf(":") + 1)) : SIPS_SCHEME) : SIP_SCHEME;
            string = string.substring(this.scheme.length());
            n = string.indexOf("@");
            if (n != -1) {
                this.userInfo = string.substring(0, n);
                string = string.substring(n + 1);
            }
            String string2 = null;
            n = string.indexOf(";");
            if (n != -1) {
                string2 = string.substring(0, n);
            } else {
                string2 = string;
                n = string.length();
            }
            int n2 = string2.indexOf("[");
            if (n2 != -1) {
                int n3 = string2.indexOf("]");
                if (n3 != -1) {
                    this.ipV6addr = true;
                    this.host = string2.substring(n2 + 1, n3);
                    int n4 = string2.indexOf(":", n3);
                    this.port = n4 != -1 ? string2.substring(n4 + 1, n) : new String("5060");
                }
            } else {
                int n5 = string2.indexOf(":");
                int n6 = string2.indexOf(">");
                int n7 = string2.indexOf(";");
                if (n6 != -1) {
                    n = n6;
                }
                if (n7 != -1 && n7 < n6) {
                    n = n7;
                }
                if (n5 != -1) {
                    this.host = string2.substring(0, n5);
                    this.port = string2.substring(n5 + 1, n);
                } else {
                    this.host = string2.substring(0, n);
                    this.port = new String("5060");
                }
            }
            this.additionalParameters = string = string.substring(string2.length());
            this.parseAdditionalParameters(this.additionalParameters);
        }
    }

    private void parseAdditionalParameters(String string) {
        if (string.length() > 1) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ";=");
                while (true) {
                    String string2;
                    if ((string2 = stringTokenizer.nextToken()).compareToIgnoreCase("maddr") == 0) {
                        this.mAddr = stringTokenizer.nextToken();
                        continue;
                    }
                    if (string2.compareToIgnoreCase("transport") == 0) {
                        this.transport = stringTokenizer.nextToken();
                        continue;
                    }
                    stringTokenizer.nextToken();
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    public String getHost() {
        this.parseUri();
        return this.host;
    }

    public String getPort() {
        this.parseUri();
        return this.port;
    }

    public String getScheme() {
        this.parseUri();
        return this.scheme;
    }

    public String getUserInfo() {
        this.parseUri();
        return this.userInfo;
    }

    public void setHost(String string) {
        this.parseUri();
        this.changed = true;
        this.host = string;
    }

    public void setPort(String string) {
        this.parseUri();
        this.changed = true;
        this.port = string;
    }

    public void setScheme(String string) {
        this.parseUri();
        this.changed = true;
        this.scheme = string;
    }

    public void setUserInfo(String string) {
        this.parseUri();
        this.changed = true;
        this.userInfo = string;
    }

    public String getBaseSIPUri() {
        this.parseUri();
        String string = new String();
        string = this.scheme;
        if (this.userInfo != null) {
            string = string + this.userInfo + "@";
        }
        string = string + this.getHostnamePortCombo();
        return string;
    }

    public String getHostnamePortCombo() {
        this.parseUri();
        String string = new String();
        string = this.host;
        if (this.port != null) {
            string = string + ":" + this.port;
        }
        string = this.ipV6addr ? "[" + this.host + "]" : this.host;
        if (this.port != null) {
            string = string + ":" + this.port;
        }
        return string;
    }

    public String getBaseSIPUriWithoutSchema() {
        this.parseUri();
        String string = new String();
        if (this.userInfo != null) {
            string = string + this.userInfo + "@";
        }
        string = string + this.getHostnamePortCombo();
        return string;
    }

    public String getAdditionalParms() {
        this.parseUri();
        return this.additionalParameters;
    }

    public void setAdditionalParms(String string) {
        this.parseUri();
        this.changed = true;
        this.additionalParameters = string;
    }

    public void setPortInt(int n) {
        this.parseUri();
        this.changed = true;
        this.port = Integer.toString(n);
    }

    public int getPortInt() {
        this.parseUri();
        if (this.port != null) {
            return Integer.parseInt(this.port);
        }
        return -1;
    }

    public void setTransport(String string) {
        this.parseUri();
        this.changed = true;
        this.transport = string;
    }

    public String getTransport() {
        this.parseUri();
        return this.transport;
    }

    public void setMaddr(String string) {
        this.parseUri();
        this.changed = true;
        this.mAddr = string;
    }

    public String getMaddr() {
        this.parseUri();
        return this.mAddr;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.14 ");
        }
    }
}

