/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.sip.channel.protocol;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.sip.channel.SIPMessage;
import com.ibm.wsspi.sip.channel.protocol.NameAddr;
import com.ibm.wsspi.sip.channel.protocol.ViaHeader;
import com.ibm.wsspi.sip.channelutils.BNFHeaderKeys;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SIPUtils {
    public static final String BRANCH_MAGIC_COOKIE = "z9hG4bK";
    public static final String EMPTY_STRING = "";
    private static TraceComponent tc = Tr.register(SIPUtils.class, "WebSphere SIP Channel", "com.ibm.ws.sip.channel.resources.sipchannel");
    static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String generateBranchId(SIPMessage sIPMessage) {
        String string;
        block9: {
            string = null;
            try {
                String string2 = sIPMessage.retrieveHeaderInUTF8Format(SIPMessage.HDR_VIA, 0);
                ViaHeader viaHeader = ViaHeader.parseViaHeader(string2);
                String string3 = viaHeader.getBranchId();
                if (string3 != null && string3.startsWith(BRANCH_MAGIC_COOKIE)) {
                    string = SIPUtils.generateHashString(string3);
                }
                if (string == null) {
                    String string4;
                    String string5 = SIPUtils.retrieveTagParameter(sIPMessage, SIPMessage.HDR_TO);
                    String string6 = SIPUtils.retrieveTagParameter(sIPMessage, SIPMessage.HDR_FROM);
                    String string7 = SIPUtils.retrieveHeaderInUTF8Format(sIPMessage, SIPMessage.HDR_CALL_ID, 0);
                    if (string7 == null) {
                        string7 = EMPTY_STRING;
                    }
                    String string8 = sIPMessage.getRequestUri();
                    if (string2 == null) {
                        string2 = EMPTY_STRING;
                    }
                    if ((string4 = SIPUtils.retrieveHeaderInUTF8Format(sIPMessage, SIPMessage.HDR_CSEQ, 0)) == null) {
                        string4 = EMPTY_STRING;
                    } else {
                        int n = string4.indexOf(" ");
                        if (n != -1) {
                            string4 = string4.substring(0, n);
                        }
                    }
                    String string9 = string5 + string6 + string7 + string8 + string2 + string4;
                    string = SIPUtils.generateHashString(string9);
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "Caught Exception when generating branch id  " + exception.getMessage());
            }
        }
        return string;
    }

    public static String retrieveTagParameter(SIPMessage sIPMessage, BNFHeaderKeys bNFHeaderKeys) {
        String string;
        block3: {
            string = EMPTY_STRING;
            try {
                String string2 = SIPUtils.retrieveHeaderInUTF8Format(sIPMessage, bNFHeaderKeys, 0);
                if (string2 != null) {
                    NameAddr nameAddr = new NameAddr();
                    nameAddr.parseHeader(string2);
                    string = nameAddr.getTagParameter();
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "Caught Exception: " + exception.toString());
            }
        }
        return string;
    }

    public static int hashUri(String string) {
        int n;
        block3: {
            n = 0;
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                byte[] byArray = messageDigest.digest(string.getBytes());
                int n2 = 0;
                for (int i = 0; i < byArray.length; ++i) {
                    n2 ^= byArray[i];
                }
                n = Math.abs(n2);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "Caught NoSuchAlgorithmException " + noSuchAlgorithmException.getMessage());
            }
        }
        return n;
    }

    public static String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(hexDigits[(byArray[i] & 0xF0) >>> 4]);
            stringBuffer.append(hexDigits[byArray[i] & 0xF]);
        }
        return stringBuffer.toString();
    }

    public static String retrieveHeaderInUTF8Format(SIPMessage sIPMessage, BNFHeaderKeys bNFHeaderKeys, int n) {
        String string = null;
        byte[] byArray = sIPMessage.getHeaderAsByteArray(bNFHeaderKeys, n);
        try {
            if (byArray != null) {
                string = new String(byArray, "UTF8");
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception retrieving header  " + exception.getMessage());
            }
            string = null;
        }
        return string;
    }

    private static String generateHashString(String string) {
        String string2;
        block2: {
            string2 = null;
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                byte[] byArray = messageDigest.digest(string.getBytes());
                string2 = BRANCH_MAGIC_COOKIE + SIPUtils.toHexString(byArray);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "Caught NoSuchAlgorithmException " + noSuchAlgorithmException.getMessage());
            }
        }
        return string2;
    }
}

