/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.sip.channel.protocol;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.sip.channel.exception.InvalidSIPViaHeaderException;
import java.util.StringTokenizer;

public class ViaHeader {
    public static final String DEFAULT_SENT_PROTOCOL_TCP = "SIP/2.0/TCP";
    public static final String DEFAULT_SENT_PROTOCOL_TLS = "SIP/2.0/TLS";
    public static final String DEFAULT_SENT_PROTOCOL_UDP = "SIP/2.0/UDP";
    private static final String TTL = "ttl";
    private static final String MADDR = "maddr";
    private static final String RECEIVED = "received";
    private static final String BRANCH = "branch";
    private static final String ALIAS = "alias";
    String protocol = null;
    String protocolVersion = null;
    String sentBy = null;
    String ttl = null;
    String mAddr = null;
    String received = null;
    String branchId = null;
    boolean alias = false;
    private static TraceComponent tc = Tr.register(ViaHeader.class, "WebSphere SIP Channel", "com.ibm.ws.sip.channel.resources.sipchannel");

    public static ViaHeader parseViaHeader(String string) throws InvalidSIPViaHeaderException {
        ViaHeader viaHeader = new ViaHeader();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            if (stringTokenizer.countTokens() > 0) {
                viaHeader.setProtocol(stringTokenizer.nextToken());
            }
            if (stringTokenizer.countTokens() > 0) {
                String string2 = "";
                while (stringTokenizer.countTokens() > 0) {
                    string2 = string2 + stringTokenizer.nextToken();
                }
                stringTokenizer = new StringTokenizer(string2, ";");
                viaHeader.setSentBy(stringTokenizer.nextToken());
                while (stringTokenizer.countTokens() > 0) {
                    String string3;
                    StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "=");
                    if (stringTokenizer2.countTokens() == 1) {
                        string3 = stringTokenizer2.nextToken();
                        ViaHeader.setToken(viaHeader, string3, "");
                        continue;
                    }
                    if (stringTokenizer2.countTokens() == 2) {
                        string3 = stringTokenizer2.nextToken();
                        String string4 = stringTokenizer2.nextToken();
                        ViaHeader.setToken(viaHeader, string3, string4);
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ViaHeader: parseViaHeader tokenTokenizer.countTokens() != 2 " + stringTokenizer2.countTokens());
                    }
                    throw new InvalidSIPViaHeaderException("Bad token count");
                }
            }
        }
        catch (Exception exception) {
            throw new InvalidSIPViaHeaderException(exception.getMessage());
        }
        return viaHeader;
    }

    private static void setToken(ViaHeader viaHeader, String string, String string2) {
        if (string.equals(ALIAS)) {
            viaHeader.setAlias(true);
        } else if (string.equals(TTL)) {
            viaHeader.setTtl(string2);
        } else if (string.equals(MADDR)) {
            viaHeader.setMAddr(string2);
        } else if (string.equals(RECEIVED)) {
            viaHeader.setReceived(string2);
        } else if (string.equals(BRANCH)) {
            viaHeader.setBranchId(string2);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "unrecongnized token " + string + " value = " + string2);
        }
    }

    public String marshallViaHeader() throws InvalidSIPViaHeaderException {
        if (!this.hasProtocol() || !this.hasSentBy()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No protocol or sent by values");
            }
            throw new InvalidSIPViaHeaderException("No protocol or sent by values");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getProtocol() + " ");
        stringBuffer.append(this.getSentBy());
        if (this.hasTtl()) {
            stringBuffer.append(";ttl=" + this.getTtl());
        }
        if (this.hasMAddr()) {
            stringBuffer.append(";maddr=" + this.getMAddr());
        }
        if (this.hasReceived()) {
            stringBuffer.append(";received=" + this.getReceived());
        }
        if (this.hasBranchId()) {
            stringBuffer.append(";branch=" + this.getBranchId());
        }
        if (this.getAlias()) {
            stringBuffer.append(";alias");
        }
        return stringBuffer.toString();
    }

    public String getBranchId() {
        return this.branchId;
    }

    public String getMAddr() {
        return this.mAddr;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getReceived() {
        return this.received;
    }

    public String getSentBy() {
        String string = this.sentBy;
        int n = this.sentBy.lastIndexOf(58);
        if (n != -1) {
            int n2 = this.sentBy.lastIndexOf(58, n - 1);
            int n3 = this.sentBy.indexOf(91);
            if (n2 != -1 && n3 == -1) {
                string = "[" + this.sentBy.substring(0, n) + "]" + this.sentBy.substring(n, this.sentBy.length());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ViaHeader: detected IPv6 address before=\"" + this.sentBy + "\" after \"" + string + "\"");
                }
            }
        }
        return string;
    }

    public String getTtl() {
        return this.ttl;
    }

    public boolean hasBranchId() {
        return this.branchId != null;
    }

    public boolean hasMAddr() {
        return this.mAddr != null;
    }

    public boolean hasProtocol() {
        return this.protocol != null;
    }

    public boolean hasReceived() {
        return this.received != null;
    }

    public boolean hasSentBy() {
        return this.sentBy != null;
    }

    public boolean hasTtl() {
        return this.ttl != null;
    }

    public void setBranchId(String string) {
        this.branchId = string;
    }

    public void setMAddr(String string) {
        this.mAddr = string;
    }

    public void setProtocol(String string) {
        this.protocol = string;
    }

    public void setReceived(String string) {
        this.received = string;
    }

    public void setSentBy(String string) {
        this.sentBy = string;
    }

    public void setTtl(String string) {
        this.ttl = string;
    }

    public boolean getAlias() {
        return this.alias;
    }

    public void setAlias(boolean bl) {
        this.alias = bl;
    }
}

