/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.sip.channelutils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.genericbnf.GenericKeys;
import com.ibm.wsspi.sip.channelutils.impl.VersionMatcherImpl;
import java.util.ArrayList;

public class VersionValues
extends GenericKeys {
    private static TraceComponent tc = Tr.register(VersionValues.class, "WebSphere SIP Channel", "com.ibm.ws.sip.channel.resources.sipchannel");
    public static int NUM_HEADERS = 0;
    private static ArrayList allKeys = null;
    private static VersionMatcherImpl matcher = VersionMatcherImpl.getRef();
    private byte[] byteArray = null;
    private int major = 0;
    private int minor = 0;
    private String protocol = null;

    public VersionValues(String string, int n) throws IllegalArgumentException {
        super(string, n);
        if (NUM_HEADERS < n) {
            if (allKeys == null) {
                allKeys = new ArrayList(n);
            }
            this.name = string;
            this.byteArray = this.name.getBytes();
            int n2 = this.name.indexOf("/");
            int n3 = this.name.lastIndexOf(".");
            if (-1 == n2 || -1 == n3) {
                throw new IllegalArgumentException("Invalid VersionValues(format)");
            }
            this.protocol = this.name.substring(0, n2);
            try {
                this.major = new Integer(this.name.substring(n2 + 1, n3));
                this.minor = new Integer(this.name.substring(n3 + 1));
            }
            catch (NumberFormatException numberFormatException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invalid Version(" + this.name + ") provided to VersionValues");
                }
                throw new IllegalArgumentException("Invalid VersionValues(versions)");
            }
            allKeys.add(NUM_HEADERS++, this);
            matcher.add(this);
            if (NUM_HEADERS == n) {
                matcher.init();
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Too many instances of VersionValuesImpl");
            }
            throw new IllegalStateException("Unable to create another VersionValuesImpl");
        }
    }

    public String getProtocolName() {
        return this.protocol;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public static final ArrayList getAllKeys() {
        return allKeys;
    }

    public static VersionValues getKey(int n) {
        if (VersionValues.isLegal(n)) {
            return (VersionValues)allKeys.get(n);
        }
        return null;
    }

    public static boolean isLegal(int n) {
        return n >= 0 && n < NUM_HEADERS;
    }

    public static boolean isLegal(VersionValues versionValues) {
        return versionValues.getOrdinal() >= 0 && versionValues.getOrdinal() < NUM_HEADERS;
    }
}

