/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wim;

import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.ws.wim.ConfigManager;
import com.ibm.wsspi.wim.SchemaHelper;
import commonj.sdo.Property;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigHelper {
    private static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = ConfigHelper.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    static Map entityRDNs = null;
    static final Set allEntityProps = new HashSet();
    static final Set allEntityRefProps = new HashSet();
    private static ConfigManager configMgr = null;

    static ConfigManager getConfigManager() throws WIMException {
        if (configMgr == null) {
            configMgr = ConfigManager.singleton();
        }
        return configMgr;
    }

    public static List getSupportedEntityTypes() {
        return configMgr.getSupportedEntityTypes();
    }

    public static Map getEntityRDNs() {
        return entityRDNs;
    }

    public static List getRDNProperties(String string) {
        return configMgr.getRDNProperties(string);
    }

    public static boolean isRDNProperty(String string, String string2) {
        List list = (List)entityRDNs.get(string);
        return list != null && list.contains(string2);
    }

    public static String getConfigXMLFilePath() {
        return configMgr.getWIMConfigXMLFilePath();
    }

    private static void getEntityRDNsFromConfigManager() {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getEntityRDNsFromConfigManager");
        }
        List list = ConfigHelper.getSupportedEntityTypes();
        int n = list.size();
        entityRDNs = new HashMap(n);
        for (int i = 0; i < n; ++i) {
            String string = (String)list.get(i);
            List list2 = ConfigHelper.getRDNProperties(string);
            Vector<String> vector = new Vector<String>(list2.size());
            for (int j = 0; j < list2.size(); ++j) {
                vector.add((String)list2.get(j));
            }
            entityRDNs.put(string, vector);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getEntityRDNsFromConfigManager", "entityRDNs=" + entityRDNs);
        }
    }

    private static void getReferenceProperties() {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getReferenceProperties");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("identifier");
        arrayList.add("viewIdentifiers");
        arrayList.add("parent");
        arrayList.add("children");
        arrayList.add("groups");
        arrayList.add("createTimestamp");
        arrayList.add("modifyTimestamp");
        arrayList.add("entitlementInfo");
        boolean bl = trcLogger.isLoggable(Level.FINEST);
        for (String string : entityRDNs.keySet()) {
            List list = SchemaHelper.getProperties(string);
            if (bl) {
                trcLogger.logp(Level.FINEST, CLASSNAME, "getReferenceProperties", "entityType=" + string + ", propList=" + list);
            }
            int n = list != null ? list.size() : 0;
            for (int i = 0; i < n; ++i) {
                Property property = (Property)list.get(i);
                String string2 = property.getName();
                if (arrayList.contains(string2)) continue;
                if ("IdentifierType".equals(property.getType().getName())) {
                    allEntityRefProps.add(string2);
                    continue;
                }
                allEntityProps.add(string2);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getReferenceProperties", "allEntityRefProps=" + allEntityRefProps + System.getProperty("line.separator") + "allEntityProps=" + allEntityProps);
        }
    }

    static {
        try {
            ConfigHelper.getConfigManager();
            ConfigHelper.getEntityRDNsFromConfigManager();
            ConfigHelper.getReferenceProperties();
        }
        catch (Exception exception) {
            trcLogger.logp(Level.FINE, CLASSNAME, "<static-init>", "Initialization failed:" + exception.getMessage(), exception);
        }
    }
}

