/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wim;

import com.ibm.websphere.wim.exception.InvalidArgumentException;
import com.ibm.websphere.wim.exception.UpdatePropertyException;
import com.ibm.websphere.wim.exception.WIMApplicationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.ws.wim.SchemaManager;
import com.ibm.ws.wim.util.ControlsHelper;
import com.ibm.ws.wim.util.DataGraphHelper;
import com.ibm.ws.wim.util.UniqueNameHelper;
import com.ibm.wsspi.wim.ConfigHelper;
import com.ibm.wsspi.wim.SchemaHelper;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.sdo.EDataGraph;

public class GenericHelper {
    private static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    public static final String UNIQUE_ID_PATH = "identifier/uniqueId";
    public static final String UNIQUE_NAME_PATH = "identifier/uniqueName";
    public static final String EXTERNAL_ID_PATH = "identifier/externalId";
    public static final String EXTERNAL_NAME_PATH = "identifier/externalName";
    public static final String DO_FIRST_ENTITY = "entities.0";
    public static final String WILDCARD = "*";
    public static final List IDENTIFIER_REF = DataGraphHelper.IDENTIFIER_REF;
    private static final String CLASSNAME = GenericHelper.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private static final List WILDCARD_LIST = DataGraphHelper.WILDCARD_LIST;
    private static SchemaManager schemaMgr = null;

    public static boolean isDN(String string) {
        return UniqueNameHelper.isDN(string) != null;
    }

    public static String getNewUniqueName(String string, DataObject dataObject, String string2) throws WIMException {
        String string3 = null;
        List list = (List)ConfigHelper.entityRDNs.get(string);
        if (list != null) {
            String string4 = UniqueNameHelper.getParentDN(string2);
            string3 = UniqueNameHelper.constructUniqueName(list, dataObject, string4, false);
            if (string3 != null && !string2.equals(string3)) {
                if (trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "getNewUniqueName", "uniqueName has changed: oldUniqueName=" + string2 + " #newUniqueName=" + string3);
                }
            } else {
                string3 = null;
            }
        }
        return string3;
    }

    public static void copyIdentifierDataObject(DataObject dataObject, DataObject dataObject2) throws WIMException {
        GenericHelper.copyDataObject(dataObject, dataObject2, null, IDENTIFIER_REF);
    }

    public static void copyAllPropsOfDataObject(DataObject dataObject, DataObject dataObject2) throws WIMException {
        GenericHelper.copyDataObject(dataObject, dataObject2, WILDCARD_LIST, WILDCARD_LIST);
    }

    public static void copyDataObject(DataObject dataObject, DataObject dataObject2, List list, List arrayList, String string, boolean bl, String string2) throws WIMException {
        try {
            DataObject dataObject3;
            boolean bl2 = false;
            ArrayList<String> arrayList2 = null;
            if (list != null) {
                if (list.contains("principalName") && string != null) {
                    if (!list.contains(WILDCARD) && !list.contains(string)) {
                        list.add(string);
                    }
                    bl2 = true;
                }
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    String string3 = (String)list.get(i);
                    if (!ConfigHelper.allEntityRefProps.contains(string3)) continue;
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList<String>();
                        if (arrayList != null) {
                            arrayList2.addAll(arrayList);
                        }
                    }
                    arrayList2.add(string3);
                }
                if (list.contains(WILDCARD)) {
                    Iterator iterator = ConfigHelper.allEntityRefProps.iterator();
                    while (iterator.hasNext()) {
                        if (arrayList2 == null) {
                            arrayList2 = new ArrayList();
                            if (arrayList != null) {
                                arrayList2.addAll(arrayList);
                            }
                        }
                        arrayList2.add((String)iterator.next());
                    }
                }
            }
            if (arrayList2 == null) {
                arrayList2 = arrayList;
            }
            GenericHelper.copyDataObject(dataObject, dataObject2, list, arrayList2);
            if (bl2 && string != null && SchemaHelper.isLoginAccountType(dataObject.getType().getName())) {
                if (bl) {
                    List list2 = dataObject.getList(string);
                    if (list2.size() > 0) {
                        dataObject.set("principalName", list2.get(0));
                    }
                } else {
                    dataObject.set("principalName", dataObject.get(string));
                }
            }
            if (string2 != null && (dataObject3 = dataObject.getDataObject("identifier")) != null && !dataObject3.isSet("repositoryId")) {
                dataObject3.setString("repositoryId", string2);
            }
        }
        catch (WIMException wIMException) {
            throw wIMException;
        }
        catch (Exception exception) {
            throw new WIMApplicationException("GENERIC", WIMMessageHelper.generateMsgParms(exception.getMessage()), Level.SEVERE, CLASSNAME, "copyDataObject", (Throwable)exception);
        }
    }

    public static DataObject createDataObject(DataObject dataObject, String string, String string2) {
        return schemaMgr.createDataObject(dataObject, string, string2);
    }

    public static void checkLoginAccountReadOnlyProperties(String string, DataObject dataObject, String string2, String string3) throws UpdatePropertyException {
        if (SchemaHelper.isLoginAccountType(string)) {
            if (dataObject != null) {
                if (dataObject.isSet("principalName")) {
                    throw new UpdatePropertyException("CAN_NOT_UPDATE_PROPERTY_IN_REPOSITORY", WIMMessageHelper.generateMsgParms("principalName", string3), CLASSNAME, "checkLoginAccountReadOnlyProperties");
                }
                if (dataObject.isSet("realm")) {
                    throw new UpdatePropertyException("CAN_NOT_UPDATE_PROPERTY_IN_REPOSITORY", WIMMessageHelper.generateMsgParms("realm", string3), CLASSNAME, "checkLoginAccountReadOnlyProperties");
                }
            } else {
                if ("principalName".equals(string2)) {
                    throw new UpdatePropertyException("CAN_NOT_UPDATE_PROPERTY_IN_REPOSITORY", WIMMessageHelper.generateMsgParms("principalName", string3), CLASSNAME, "checkLoginAccountReadOnlyProperties");
                }
                if ("realm".equals(string2)) {
                    throw new UpdatePropertyException("CAN_NOT_UPDATE_PROPERTY_IN_REPOSITORY", WIMMessageHelper.generateMsgParms("realm", string3), CLASSNAME, "checkLoginAccountReadOnlyProperties");
                }
            }
        }
    }

    public static void validateNestingLevel(DataObject dataObject, String string) throws InvalidArgumentException {
        int n = dataObject.getInt("level");
        if (n < 0) {
            throw new InvalidArgumentException("INVALID_LEVEL_IN_CONTROL", WIMMessageHelper.generateMsgParms(new Integer(n), string), Level.WARNING, CLASSNAME, "validateNestingLevel");
        }
    }

    public static Map getControlMap(DataObject dataObject) {
        return ControlsHelper.getControlMap(dataObject);
    }

    public static String getIdentifierString(DataObject dataObject) {
        String string = "[";
        try {
            DataObject dataObject2 = dataObject.getDataObject("identifier");
            if (dataObject2 != null) {
                String string2 = dataObject2.getString("externalId");
                if (string2 != null) {
                    string = string + "externalId=" + string2;
                }
                if ((string2 = dataObject2.getString("externalName")) != null) {
                    string = string + ", externalName=" + string2;
                }
                if ((string2 = dataObject2.getString("uniqueId")) != null) {
                    string = string + ", uniqueId=" + string2;
                }
                if ((string2 = dataObject2.getString("uniqueName")) != null) {
                    string = string + ", uniqueName=" + string2;
                }
            } else {
                string = string + dataObject;
            }
        }
        catch (Exception exception) {
            trcLogger.logp(Level.FINE, CLASSNAME, "getIdentifierString", exception.getMessage(), exception);
        }
        string = string + "]";
        return string;
    }

    public static void saveDataGraphToFile(DataGraph dataGraph, String string) throws WIMApplicationException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "saveDataGraphToFile", "saving DataGraph to " + string);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ((EDataGraph)dataGraph).getDataGraphResource().save((OutputStream)fileOutputStream, null);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            throw new WIMApplicationException("ERROR_WRITING_FILE", WIMMessageHelper.generateMsgParms(string, exception.getMessage()), Level.SEVERE, CLASSNAME, "saveDataGraphToFile", (Throwable)exception);
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "saveDataGraphToFile", "save successful.");
        }
    }

    private static void copyDataObject(DataObject dataObject, DataObject dataObject2, List list, List list2) throws WIMException {
        try {
            DataGraphHelper.copyDataObject(dataObject, dataObject2, list, null, list2);
        }
        catch (Exception exception) {
            throw new WIMApplicationException("GENERIC", WIMMessageHelper.generateMsgParms(exception.getMessage()), Level.SEVERE, CLASSNAME, "copyDataObject", (Throwable)exception);
        }
    }

    static {
        try {
            schemaMgr = SchemaHelper.getSchemaManager();
        }
        catch (Exception exception) {
            trcLogger.logp(Level.FINE, CLASSNAME, "<static-init>", "Initialization failed:" + exception.getMessage(), exception);
        }
    }
}

