/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wim;

import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.ws.wim.SchemaManager;
import com.ibm.wsspi.wim.ConfigHelper;
import commonj.sdo.Property;
import commonj.sdo.Type;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.EClass;

public class SchemaHelper {
    private static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = SchemaHelper.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private static SchemaManager schemaMgr = null;

    static SchemaManager getSchemaManager() throws WIMException {
        if (schemaMgr == null) {
            schemaMgr = SchemaManager.singleton();
        }
        return schemaMgr;
    }

    public static boolean isSuperType(String string, String string2) {
        return string.equals(string2) || schemaMgr.isSuperType(string, string2);
    }

    public static boolean isLoginAccountType(String string) {
        return SchemaHelper.isSuperType("LoginAccount", string);
    }

    public static boolean isGroupType(String string) {
        return SchemaHelper.isSuperType("Group", string);
    }

    public static EClass getEClass(String string) {
        return schemaMgr.getEClass(string);
    }

    public static EClass getEClass(Type type) {
        return schemaMgr.getEClass(type);
    }

    public static String getTypeNsURI(String string) {
        return schemaMgr.getTypeNsURI(string);
    }

    public static List getProperties(String string) {
        return schemaMgr.getProperties(string);
    }

    public static boolean isReferenceProperty(String string) {
        return ConfigHelper.allEntityRefProps.contains(string);
    }

    public static boolean isMultiValuedProperty(String string, String string2) {
        try {
            Property property = schemaMgr.getProperty(string, string2);
            if (property != null && property.isMany()) {
                return true;
            }
        }
        catch (Exception exception) {
            trcLogger.logp(Level.FINE, CLASSNAME, "isMultiValued", exception.getMessage(), exception);
        }
        return false;
    }

    static {
        try {
            schemaMgr = SchemaHelper.getSchemaManager();
            ConfigHelper.getConfigManager();
        }
        catch (Exception exception) {
            trcLogger.logp(Level.FINE, CLASSNAME, "<static-init>", "Initialization failed:" + exception.getMessage(), exception);
        }
    }
}

