/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wim.plugins.orgview.impl;

import com.ibm.websphere.wim.exception.SubscriberException;
import com.ibm.websphere.wim.pluginmanager.context.ExceptionContext;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.ws.wim.util.ControlsHelper;
import com.ibm.wsspi.wim.pluginmanager.SubscriberType;
import com.ibm.wsspi.wim.plugins.orgview.ViewProcessor;
import commonj.sdo.DataObject;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BaseViewProcessorImpl
implements ViewProcessor {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = BaseViewProcessorImpl.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private String subscriberName = null;

    public DataObject getViewIdentifierForEntity(DataObject dataObject, String string) {
        List list = dataObject.getList("viewIdentifiers");
        for (int i = 0; i < list.size(); ++i) {
            DataObject dataObject2 = (DataObject)list.get(i);
            String string2 = dataObject2.getString("viewName");
            if (!string2.equals(string)) continue;
            return dataObject2;
        }
        return null;
    }

    public boolean getInViewExplicit(String string, DataObject dataObject) throws SubscriberException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "getInviewExplicit(emitter, rootDO)", WIMTraceHelper.printDataObject(dataObject));
        }
        if (bl) {
            trcLogger.logp(Level.FINER, CLASSNAME, "getInviewExplicit(emitter, rootDO)", "Entered getInViewExplicit for BaseViewProcessor");
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "getInviewExplicit(emitter, rootDO)", WIMTraceHelper.printDataObject(dataObject));
        }
        return true;
    }

    public boolean createInViewExplicit(String string, DataObject dataObject) throws SubscriberException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "createInviewExplicit(emitter, rootDO)", WIMTraceHelper.printDataObject(dataObject));
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "createInviewExplicit(emitter, rootDO)", WIMTraceHelper.printDataObject(dataObject));
        }
        return true;
    }

    public boolean deleteInViewExplicit(String string, DataObject dataObject) throws SubscriberException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "deleteInviewExplicit(emitter, rootDO)", WIMTraceHelper.printDataObject(dataObject));
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "deleteInviewExplicit(emitter, rootDO)", WIMTraceHelper.printDataObject(dataObject));
        }
        return true;
    }

    public boolean createPreExitImplicit(DataObject dataObject) throws SubscriberException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "createPreExitImplicit(rootDO)", WIMTraceHelper.printDataObject(dataObject));
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "createPreExitImplicit(rootDO)", WIMTraceHelper.printDataObject(dataObject));
        }
        return true;
    }

    public boolean deletePreExitImplicit(DataObject dataObject) throws SubscriberException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "deletePreExitImplicit(rootDO)", WIMTraceHelper.printDataObject(dataObject));
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "deletePreExitImplicit(rootDO)", WIMTraceHelper.printDataObject(dataObject));
        }
        return true;
    }

    public boolean updatePreExitImplicit(DataObject dataObject) throws SubscriberException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "updatePreExitImplicit(rootDO)", WIMTraceHelper.printDataObject(dataObject));
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "updatePreExitImplicit(rootDO)", WIMTraceHelper.printDataObject(dataObject));
        }
        return true;
    }

    public boolean createPostExitImplicit(DataObject dataObject) throws SubscriberException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "createPostExitImplicit(rootDO)", WIMTraceHelper.printDataObject(dataObject));
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "createPostExitImplicit(rootDO)", WIMTraceHelper.printDataObject(dataObject));
        }
        return true;
    }

    public boolean deletePostExitImplicit(DataObject dataObject) throws SubscriberException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "deletePostExitImplicit(rootDO)", WIMTraceHelper.printDataObject(dataObject));
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "deletePostExitImplicit(rootDO)", WIMTraceHelper.printDataObject(dataObject));
        }
        return true;
    }

    public boolean updatePostExitImplicit(DataObject dataObject) throws SubscriberException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "updatePostExitImplicit(rootDO)", WIMTraceHelper.printDataObject(dataObject));
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "updatePostExitImplicit(rootDO)", WIMTraceHelper.printDataObject(dataObject));
        }
        return true;
    }

    public boolean preExitCall(String string, DataObject dataObject) throws SubscriberException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "preExitCall(emitter, rootDO)", WIMTraceHelper.printDataObject(dataObject));
        }
        boolean bl2 = true;
        if (string.lastIndexOf(".create") > 0) {
            bl2 = this.createPreExitImplicit(dataObject);
        } else if (string.lastIndexOf(".delete") > 0) {
            bl2 = this.deletePreExitImplicit(dataObject);
        } else if (string.lastIndexOf(".update") > 0) {
            bl2 = this.updatePreExitImplicit(dataObject);
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "preExitCall(emitter, rootDO)", WIMTraceHelper.printDataObject(dataObject));
        }
        return bl2;
    }

    public boolean inlineExitCall(String string, DataObject dataObject, String string2) throws SubscriberException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "inlineExitCall(emitter, rootDO, inlineTopicName)", WIMTraceHelper.printDataObject(dataObject));
        }
        Map map = ControlsHelper.getControlMap(dataObject.getDataGraph());
        DataObject dataObject2 = (DataObject)map.get("ViewControl");
        boolean bl2 = true;
        if (dataObject2 != null && this.getViewName().equals(dataObject2.getString("viewName"))) {
            if (string2.equals("getInViewExplicit")) {
                bl2 = this.getInViewExplicit(string, dataObject);
            } else if (string2.equalsIgnoreCase("createInViewExplicit")) {
                bl2 = this.createInViewExplicit(string, dataObject);
            } else if (string2.equalsIgnoreCase("deleteInViewExplicit")) {
                bl2 = this.deleteInViewExplicit(string, dataObject);
            }
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "inlineExitCall(emitter, rootDO, inlineTopicName)", WIMTraceHelper.printDataObject(dataObject));
        }
        return bl2;
    }

    public boolean postExitCall(String string, DataObject dataObject, DataObject dataObject2) throws SubscriberException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "postExitCall(emitter, rootDO)", WIMTraceHelper.printDataObject(dataObject));
        }
        boolean bl2 = true;
        if (string.lastIndexOf(".create") > 0) {
            bl2 = this.createPostExitImplicit(dataObject);
        } else if (string.lastIndexOf(".delete") > 0) {
            bl2 = this.deletePostExitImplicit(dataObject);
        } else if (string.lastIndexOf(".update") > 0) {
            bl2 = this.updatePostExitImplicit(dataObject);
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "postExitCall(emitter, rootDO)", WIMTraceHelper.printDataObject(dataObject));
        }
        return true;
    }

    public void commit(String string, DataObject dataObject, int n, String string2) throws SubscriberException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "commit", WIMTraceHelper.printDataObject(dataObject));
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "commit", WIMTraceHelper.printDataObject(dataObject));
        }
    }

    public void rollback(String string, DataObject dataObject, int n, String string2) throws SubscriberException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "rollback", WIMTraceHelper.printDataObject(dataObject));
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "rollback", WIMTraceHelper.printDataObject(dataObject));
        }
    }

    public void initSubscriber(Hashtable hashtable) throws SubscriberException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "initSubscriber");
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "initSubscriber");
        }
        if (hashtable != null) {
            this.subscriberName = (String)hashtable.get("topicSubscriberName");
        }
    }

    public void shutdownSubscriber() throws SubscriberException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "shutdownSubscriber");
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "shutdownSubscriber");
        }
    }

    public void recovery(String string, int n, String string2, ExceptionContext exceptionContext) throws SubscriberException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "recovery");
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "recovery");
        }
    }

    public String getSubscriberName() {
        boolean bl = trcLogger.isLoggable(Level.FINEST);
        if (bl) {
            trcLogger.entering(CLASSNAME, "getSubscriberName");
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "getSubscriberName", this.subscriberName);
        }
        return this.subscriberName;
    }

    public SubscriberType getSubscriberType() {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "getSubscriberType");
        }
        SubscriberType subscriberType = SubscriberType.MODIFICATION_SUBSCRIBER_LITERAL;
        if (bl) {
            trcLogger.exiting(CLASSNAME, "getSubscriberType");
        }
        return subscriberType;
    }
}

