/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.auth.callback;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.callback.WSCredTokenCallbackImpl;
import com.ibm.websphere.security.auth.callback.WSGUICallbackHandlerImpl;
import com.ibm.websphere.security.auth.callback.WSRealmNameCallbackImpl;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.wsspi.wssecurity.auth.callback.PropertyCallback;
import com.ibm.wsspi.wssecurity.config.CallbackHandlerConfig;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class GUIPromptCallbackHandler
extends WSGUICallbackHandlerImpl {
    private static final TraceComponent tc = Tr.register(GUIPromptCallbackHandler.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String compName = "security.wssecurity";
    private String _username = "";
    private char[] _password = null;
    private CallbackHandlerConfig _config = null;

    public GUIPromptCallbackHandler() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "GUIPromptCallbackHandler()");
        }
        if ((this._username == null || this._username.length() == 0) && WSSecurityPlatformContextFactory.getInstance().isServer()) {
            Tr.warning(tc, "security.wssecurity.WSEC0130W", this.getClass().getName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "GUIPromptCallbackHandler()");
        }
    }

    public GUIPromptCallbackHandler(String string, char[] cArray, Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "GUIPromptCallbackHandler(String, char[], Map)", new Object[]{"Default user: " + string});
        }
        this._username = string;
        this._password = cArray;
        if ((this._username == null || this._username.length() == 0) && WSSecurityPlatformContextFactory.getInstance().isServer()) {
            Tr.warning(tc, "security.wssecurity.WSEC0130W", this.getClass().getName());
        }
        if (map == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WARNING: The properties parameter is null.");
            }
            this._config = null;
        } else {
            this._config = (CallbackHandlerConfig)map.get("com.ibm.wsspi.wssecurity.config.callbackHandler.configKey");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "CallbackHandlerConfig [" + this._config + "].");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "GUIPromptCallbackHandler(String, char[], Map)");
        }
    }

    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handle(Callback[] callbacks)");
        }
        if (this._username == null || this._username.length() == 0) {
            if (WSSecurityPlatformContextFactory.getInstance().isServer()) {
                String string = MessageFormat.format(ConfigConstants.getMessage("security.wssecurity.WSEC0131E"), this.getClass().getName());
                throw new IOException(string);
            }
            if (callbackArray == null || callbackArray.length == 0) {
                super.handle(callbackArray);
            } else {
                int n = callbackArray.length;
                Callback[] callbackArray2 = new Callback[n];
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    Callback callback = callbackArray[i];
                    if (!(callback instanceof NameCallback) && !(callback instanceof PasswordCallback) && !(callback instanceof WSCredTokenCallbackImpl) && !(callback instanceof WSRealmNameCallbackImpl)) continue;
                    callbackArray2[n2++] = callback;
                }
                if (n2 > 0) {
                    Callback[] callbackArray3 = new Callback[n2];
                    for (int i = 0; i < n2; ++i) {
                        callbackArray3[i] = callbackArray2[i];
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found " + n2 + " of " + n + " valid callbacks to pass to super.handle()");
                    }
                    super.handle(callbackArray3);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No valid callbacks found to pass to super.handle()");
                    }
                    super.handle(null);
                }
            }
        } else {
            int n = 0;
            if (callbackArray == null || (n = callbackArray.length) == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "handle(callbacks = \"{ }\")");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "handle(Callback[] callbacks)");
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("{ ");
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append(callbackArray[i].getClass().getName());
                    if (i >= n - 1) continue;
                    stringBuffer.append(", ");
                }
                stringBuffer.append(" }");
                Tr.debug(tc, "handle(callbacks = \"" + stringBuffer.toString() + "\")");
            }
            for (int i = 0; i < n; ++i) {
                Callback callback = callbackArray[i];
                if (callback instanceof NameCallback) {
                    ((NameCallback)callback).setName(this._username);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    ((PasswordCallback)callback).setPassword(this._password == null ? new char[]{} : this._password);
                    continue;
                }
                if (callbackArray[i] instanceof PropertyCallback || callback instanceof WSCredTokenCallbackImpl) continue;
                throw new UnsupportedCallbackException(callback, ConfigConstants.getMessage("security.wssecurity.WSEC0153E"));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handle(Callback[] callbacks)");
        }
    }
}

