/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.auth.callback;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.callback.WSCredTokenCallbackImpl;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.wsspi.wssecurity.auth.callback.PropertyCallback;
import com.ibm.wsspi.wssecurity.config.CallbackHandlerConfig;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class NonPromptCallbackHandler
implements CallbackHandler {
    private static final TraceComponent tc = Tr.register(NonPromptCallbackHandler.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private String _username = "";
    private char[] _password = null;
    private CallbackHandlerConfig _config = null;

    public NonPromptCallbackHandler() {
    }

    public NonPromptCallbackHandler(String string, char[] cArray, Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "NonPromptCallbackHandler(String, char[], Map)", new Object[]{"Default user: " + string});
        }
        this._username = string;
        this._password = cArray;
        if (map == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WARNING: The properties parameter is null.");
            }
            this._config = null;
        } else {
            this._config = (CallbackHandlerConfig)map.get("com.ibm.wsspi.wssecurity.config.callbackHandler.configKey");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "CallbackHandlerConfig [" + this._config + "].");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "NonPromptCallbackHandler(String, char[], Map)");
        }
    }

    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handle(Callback[] callbacks)");
        }
        int n = 0;
        if (callbackArray == null || (n = callbackArray.length) == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "handle(callbacks = \"{ }\")");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handle(Callback[] callbacks)");
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{ ");
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(callbackArray[i].getClass().getName());
                if (i >= n - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(" }");
            Tr.debug(tc, "handle(callbacks = \"" + stringBuffer.toString() + "\")");
        }
        for (int i = 0; i < n; ++i) {
            Callback callback = callbackArray[i];
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this._username);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(this._password);
                continue;
            }
            if (callbackArray[i] instanceof PropertyCallback || callback instanceof WSCredTokenCallbackImpl) continue;
            throw new UnsupportedCallbackException(callback, ConfigConstants.getMessage("security.wssecurity.WSEC0153E"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handle(Callback[] callbacks)");
        }
    }
}

