/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.auth.callback;

import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.callback.BSTokenCallbackHandler;
import com.ibm.xml.soapsec.util.CertificateUtil;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class PKCS7CallbackHandler
extends BSTokenCallbackHandler {
    private static final TraceComponent tc = Tr.register(PKCS7CallbackHandler.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = PKCS7CallbackHandler.class.getName();

    public PKCS7CallbackHandler(Map map) {
        super(map);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "PKCS7CallbackHandler(Map properties)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "PKCS7CallbackHandler(Map properties)");
        }
    }

    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        BSTokenCallbackHandler.TokenInformation tokenInformation;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handle(Callback[] callbacks[" + callbackArray + "])");
        }
        if ((tokenInformation = super._handle(callbackArray)) != null && tokenInformation._config != null) {
            Provider provider = (Provider)tokenInformation._properties.get("com.ibm.wsspi.wssecurity.token.x509.provider");
            List list = (List)tokenInformation._properties.get("com.ibm.wsspi.wssecurity.token.x509.certStores");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Provider [" + provider + "], CertStores [" + list + "].");
            }
            try {
                byte[] byArray;
                Certificate certificate;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Getting the X509 Certificate with the alias [" + tokenInformation._alias + "].");
                }
                if ((certificate = tokenInformation._config.getCertificate(tokenInformation._alias)) == null) {
                    throw this.processError(tokenInformation);
                }
                if (certificate instanceof X509Certificate) {
                    tokenInformation._bsCallback.setCert((X509Certificate)certificate);
                    tokenInformation._bsCallback.setKeyStorePath(tokenInformation._config.getKeyStorePath());
                    tokenInformation._bsCallback.setAlias(tokenInformation._alias);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Succeeded to get the X509 Certificate with the alias [" + tokenInformation._alias + "].");
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Genarating the pkcs7 with the alias [" + tokenInformation._alias + "].");
                }
                if ((byArray = CertificateUtil.encodePKCS7(provider, list, tokenInformation._config.getKeyStore(), tokenInformation._alias)) == null) {
                    throw new IOException(ConfigUtil.getMessage("security.wssecurity.PkiPathCallbackHandler.s02"));
                }
                tokenInformation._bsCallback.setBinary(byArray);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Succeeded to generate the pkcs7 with the alias [" + tokenInformation._alias + "].");
                }
            }
            catch (CertStoreException certStoreException) {
                Tr.processException((Throwable)certStoreException, clsName + ".handle", "140", this);
                Tr.error(tc, "security.wssecurity.PKCS7CallbackHandler.s01", new Object[]{certStoreException});
                IOException iOException = new IOException(ConfigUtil.getMessage("security.wssecurity.PKCS7CallbackHandler.s01", new String[]{certStoreException.getClass().getName() + ": " + certStoreException.getMessage()}));
                iOException.initCause(certStoreException);
                throw iOException;
            }
            catch (KeyStoreException keyStoreException) {
                Tr.processException((Throwable)keyStoreException, clsName + ".handle", "147", this);
                Tr.error(tc, "security.wssecurity.PKCS7CallbackHandler.s01", new Object[]{keyStoreException});
                IOException iOException = new IOException(ConfigUtil.getMessage("security.wssecurity.PKCS7CallbackHandler.s01", new String[]{keyStoreException.getClass().getName() + ": " + keyStoreException.getMessage()}));
                iOException.initCause(keyStoreException);
                throw iOException;
            }
            catch (SoapSecurityException soapSecurityException) {
                Tr.processException((Throwable)soapSecurityException, clsName + ".handle", "154", this);
                Tr.error(tc, "security.wssecurity.PKCS7CallbackHandler.s01", new Object[]{soapSecurityException});
                IOException iOException = new IOException(ConfigUtil.getMessage("security.wssecurity.PKCS7CallbackHandler.s01", new String[]{soapSecurityException.getClass().getName() + ": " + soapSecurityException.getMessage()}));
                iOException.initCause(soapSecurityException);
                throw iOException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handle()");
        }
    }
}

