/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.auth.callback;

import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.callback.BSTokenCallbackHandler;
import com.ibm.xml.soapsec.util.CertificateUtil;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class PkiPathCallbackHandler
extends BSTokenCallbackHandler {
    private static final TraceComponent tc = Tr.register(PkiPathCallbackHandler.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = PkiPathCallbackHandler.class.getName();

    public PkiPathCallbackHandler(Map map) {
        super(map);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "PkiPathCallbackHandler(Map properties)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "PkiPathCallbackHandler(Map properties)");
        }
    }

    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        BSTokenCallbackHandler.TokenInformation tokenInformation;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, ".handle(Callback[] callbacks)");
        }
        if ((tokenInformation = super._handle(callbackArray)) != null && tokenInformation._config != null) {
            Provider provider = (Provider)tokenInformation._properties.get("com.ibm.wsspi.wssecurity.token.x509.provider");
            List list = (List)tokenInformation._properties.get("com.ibm.wsspi.wssecurity.token.x509.certStores");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Provider [" + provider + "], CertStores [" + list + "].");
            }
            try {
                byte[] byArray;
                Certificate certificate;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Getting the X509 Certificate with the alias [" + tokenInformation._alias + "].");
                }
                if ((certificate = tokenInformation._config.getCertificate(tokenInformation._alias)) == null) {
                    throw this.processError(tokenInformation);
                }
                if (certificate instanceof X509Certificate) {
                    tokenInformation._bsCallback.setCert((X509Certificate)certificate);
                    tokenInformation._bsCallback.setKeyStorePath(tokenInformation._config.getKeyStorePath());
                    tokenInformation._bsCallback.setAlias(tokenInformation._alias);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Succeeded to get the X509 Certificate with the alias [" + tokenInformation._alias + "].");
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Genarating the pki path with the alias [" + tokenInformation._alias + "].");
                }
                if ((byArray = CertificateUtil.encodePkiPath(provider, list, tokenInformation._config.getKeyStore(), tokenInformation._alias)) == null) {
                    throw new IOException(ConfigUtil.getMessage("security.wssecurity.PkiPathCallbackHandler.s02"));
                }
                tokenInformation._bsCallback.setBinary(byArray);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Succeeded to generate the pki path with the alias [" + tokenInformation._alias + "].");
                }
            }
            catch (CertificateException certificateException) {
                Tr.processException((Throwable)certificateException, clsName + ".handle", "137", this);
                Tr.error(tc, "security.wssecurity.PkiPathCallbackHandler.s01", new Object[]{certificateException});
                IOException iOException = new IOException(ConfigUtil.getMessage("security.wssecurity.PkiPathCallbackHandler.s01", new String[]{certificateException.getClass().getName() + ": " + certificateException.getMessage()}));
                iOException.initCause(certificateException);
                throw iOException;
            }
            catch (KeyStoreException keyStoreException) {
                Tr.processException((Throwable)keyStoreException, clsName + ".handle", "144", this);
                Tr.error(tc, "security.wssecurity.PkiPathCallbackHandler.s01", new Object[]{keyStoreException});
                IOException iOException = new IOException(ConfigUtil.getMessage("security.wssecurity.PkiPathCallbackHandler.s01", new String[]{keyStoreException.getClass().getName() + ": " + keyStoreException.getMessage()}));
                iOException.initCause(keyStoreException);
                throw iOException;
            }
            catch (SoapSecurityException soapSecurityException) {
                Tr.processException((Throwable)soapSecurityException, clsName + ".handle", "151", this);
                Tr.error(tc, "security.wssecurity.PkiPathCallbackHandler.s01", new Object[]{soapSecurityException});
                IOException iOException = new IOException(ConfigUtil.getMessage("security.wssecurity.PkiPathCallbackHandler.s01", new String[]{soapSecurityException.getClass().getName() + ": " + soapSecurityException.getMessage()}));
                iOException.initCause(soapSecurityException);
                throw iOException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handle(Callback[] callbacks)");
        }
    }
}

