/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.auth.callback;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.callback.WSCredTokenCallbackImpl;
import com.ibm.websphere.security.auth.callback.WSRealmNameCallbackImpl;
import com.ibm.ws.security.common.auth.util.CredentialsHelper;
import com.ibm.wsspi.security.auth.callback.WSAppContextCallback;
import com.ibm.wsspi.security.auth.callback.WSIdentityCallback;
import com.ibm.wsspi.security.auth.callback.WSProtocolPolicyCallback;
import com.ibm.wsspi.security.auth.callback.WSServletRequestCallback;
import com.ibm.wsspi.security.auth.callback.WSServletResponseCallback;
import com.ibm.wsspi.security.auth.callback.WSTokenHolderCallback;
import com.ibm.wsspi.security.auth.callback.WSX509CertificateChainCallback;
import com.ibm.wsspi.wssecurity.auth.callback.WSSContextCallback;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TokenPropagationCallbackHandler
implements CallbackHandler {
    private static final TraceComponent tc = Tr.register(TokenPropagationCallbackHandler.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private Map _context = null;
    private String userName = null;
    private String password = null;
    private String realm = null;
    private byte[] credToken = null;
    private Map _appContext = null;
    private HttpServletRequest _req = null;
    private HttpServletResponse _resp = null;
    private String _identity = null;
    private List _tokenHolderList = null;
    private Object _protocolPolicy = null;
    private X509Certificate[] certChain;

    public TokenPropagationCallbackHandler(Map map, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TokenPropagationCallbackHandler(Map context, Object policy)");
        }
        this._context = map;
        this._protocolPolicy = object;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TokenPropagationCallbackHandler(Map context, Object policy)");
        }
    }

    public TokenPropagationCallbackHandler(Map map, List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TokenPropagationCallbackHandler(Map context, List tokenHolderList)");
        }
        this._context = map;
        this._tokenHolderList = list;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TokenPropagationCallbackHandler(Map context, List tokenHolderList)");
        }
    }

    public TokenPropagationCallbackHandler(Map map, List list, byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TokenPropagationCallbackHandler(Map context, List tokenHolderList, byte[] credBytes)");
        }
        this._context = map;
        this._tokenHolderList = list;
        this.credToken = CredentialsHelper.copyCredToken(byArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TokenPropagationCallbackHandler(Map context, List tokenHolderList, byte[] credBytes)");
        }
    }

    public TokenPropagationCallbackHandler(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TokenPropagationCallbackHandler(userName = \"" + string + "\", password = \"********\")");
        }
        this.userName = string;
        this.password = string2;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TokenPropagationCallbackHandler(userName, password)");
        }
    }

    public TokenPropagationCallbackHandler(String string, String string2, String string3) {
        this(string, string3);
        this.realm = string2;
    }

    public TokenPropagationCallbackHandler(String string, String string2, String string3, List list) {
        this(string, string3);
        this.realm = string2;
        this._tokenHolderList = list;
    }

    public TokenPropagationCallbackHandler(String string, String string2, String string3, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map map) {
        this(string, string3);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TokenPropagationCallbackHandler(userName, realmName = " + string2 + " ,password, req, resp, appContext)");
        }
        this._req = httpServletRequest;
        this._resp = httpServletResponse;
        this._appContext = map;
        this.realm = string2;
    }

    public TokenPropagationCallbackHandler(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TokenPropagationCallbackHandler(credToken)");
        }
        this.credToken = CredentialsHelper.copyCredToken(byArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TokenPropagationCallbackHandler(credToken)");
        }
    }

    public TokenPropagationCallbackHandler(byte[] byArray, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TokenPropagationCallbackHandler(credToken, req, resp, appContext)");
        }
        this.credToken = CredentialsHelper.copyCredToken(byArray);
        this._req = httpServletRequest;
        this._resp = httpServletResponse;
        this._appContext = map;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TokenPropagationCallbackHandler(credToken, req, resp, appContext)");
        }
    }

    public TokenPropagationCallbackHandler(byte[] byArray, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map map, List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TokenPropagationCallbackHandler(credToken, req, resp, appContext, tokenHolderList)");
        }
        this.credToken = CredentialsHelper.copyCredToken(byArray);
        this._req = httpServletRequest;
        this._resp = httpServletResponse;
        this._appContext = map;
        this._tokenHolderList = list;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TokenPropagationCallbackHandler(credToken, req, resp, appContext, tokenHolderList)");
        }
    }

    public TokenPropagationCallbackHandler(byte[] byArray, List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TokenPropagationCallbackHandler(credToken, tokenHolderList)");
        }
        this.credToken = CredentialsHelper.copyCredToken(byArray);
        this._tokenHolderList = list;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TokenPropagationCallbackHandler(credToken, tokenHolderList)");
        }
    }

    public TokenPropagationCallbackHandler(String string, String string2, List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TokenPropagationCallbackHandler(userName, realmName, tokenHolderList)");
        }
        this.userName = string;
        this.realm = string2;
        this._tokenHolderList = list;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TokenPropagationCallbackHandler(userName, realmName, tokenHolderList)");
        }
    }

    public TokenPropagationCallbackHandler(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TokenPropagationCallbackHandler(protocolPolicy)");
        }
        this._protocolPolicy = object;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TokenPropagationCallbackHandler(protocolPolicy)");
        }
    }

    public TokenPropagationCallbackHandler(String string, X509Certificate[] x509CertificateArray) {
        this.realm = string;
        this.certChain = x509CertificateArray;
    }

    public TokenPropagationCallbackHandler(String string, X509Certificate[] x509CertificateArray, List list) {
        this.realm = string;
        this.certChain = x509CertificateArray;
        this._tokenHolderList = list;
    }

    public TokenPropagationCallbackHandler(String string, X509Certificate[] x509CertificateArray, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TokenPropagationCallbackHandler(realmName,certChain = " + string + " ,certChain, req, resp, appContext)");
        }
        this.realm = string;
        this.certChain = x509CertificateArray;
        this._req = httpServletRequest;
        this._resp = httpServletResponse;
        this._appContext = map;
    }

    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        int n = 0;
        if (callbackArray == null || (n = callbackArray.length) == 0) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "handle(callbacks = \"{ }\")");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handle(callbacks)");
            }
            return;
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{ ");
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(callbackArray[i].getClass().getName());
                if (i >= n - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(" }");
            Tr.entry(tc, "handle(callbacks = \"" + stringBuffer.toString() + "\")");
        }
        for (int i = 0; i < n; ++i) {
            Callback callback = callbackArray[i];
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this.userName);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(this.password == null ? null : this.password.toCharArray());
                continue;
            }
            if (callback instanceof WSCredTokenCallbackImpl) {
                ((WSCredTokenCallbackImpl)callback).setCredToken(this.credToken);
                continue;
            }
            if (callback instanceof WSRealmNameCallbackImpl) {
                ((WSRealmNameCallbackImpl)callback).setRealmName(this.realm);
                continue;
            }
            if (callback instanceof WSAppContextCallback) {
                ((WSAppContextCallback)callback).setContext(this._appContext);
                continue;
            }
            if (callback instanceof WSIdentityCallback) {
                ((WSIdentityCallback)callback).setClientIdentity(this._identity);
                continue;
            }
            if (callback instanceof WSServletRequestCallback) {
                ((WSServletRequestCallback)callback).setHttpServletRequest(this._req);
                continue;
            }
            if (callback instanceof WSServletResponseCallback) {
                ((WSServletResponseCallback)callback).setHttpServletResponse(this._resp);
                continue;
            }
            if (callback instanceof WSTokenHolderCallback) {
                ((WSTokenHolderCallback)callback).setTokenHolderList(this._tokenHolderList);
                continue;
            }
            if (callback instanceof WSProtocolPolicyCallback) {
                ((WSProtocolPolicyCallback)callback).setProtocolPolicy(this._protocolPolicy);
                continue;
            }
            if (callback instanceof WSX509CertificateChainCallback) {
                ((WSX509CertificateChainCallback)callback).setX509CertificateChain(this.certChain);
                continue;
            }
            if (callback instanceof WSSContextCallback) {
                ((WSSContextCallback)callback).setContext(this._context);
                continue;
            }
            throw new UnsupportedCallbackException(callback, "Unsupported callback");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handle(callbacks)");
        }
    }
}

