/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.auth.module;

import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.Constants;
import com.ibm.wsspi.wssecurity.auth.callback.BinaryTokenCallback;
import com.ibm.wsspi.wssecurity.auth.callback.PropertyCallback;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public abstract class BSTokenLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(BSTokenLoginModule.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = BSTokenLoginModule.class.getName();
    protected Subject _subject;
    protected CallbackHandler _handler;
    protected Map _sharedState;
    protected Map _options;
    protected byte[] _binary = null;
    protected Map _properties = null;
    protected SOAPMessageContext _messageContext = null;
    protected X509Certificate _cert = null;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(Subject subject,CallbackHandler handler,Map sharedState,Map options)");
        }
        this._subject = subject;
        this._handler = callbackHandler;
        this._sharedState = map;
        this._options = map2;
        if (this._handler != null && tc.isDebugEnabled()) {
            Tr.debug(tc, "CallbackHandler: " + this._handler.getClass().getName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(Subject subject,CallbackHandler handler,Map sharedState,Map options)");
        }
    }

    public boolean login() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        Callback[] callbackArray = new Callback[]{new BinaryTokenCallback(com.ibm.ws.webservices.wssecurity.Constants.X509V3.toString() + ": "), new PropertyCallback(null)};
        try {
            this._handler.handle(callbackArray);
        }
        catch (Exception exception) {
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.BSTokenLoginModule.s01", new String[]{exception.toString()}));
        }
        this._binary = ((BinaryTokenCallback)callbackArray[0]).getCredToken();
        this._properties = ((PropertyCallback)callbackArray[1]).getProperties();
        if (this._properties != null) {
            this._messageContext = (SOAPMessageContext)this._properties.get("com.ibm.wsspi.wssecurity.core.messageContext");
            this._cert = (X509Certificate)this._properties.get("com.ibm.wsspi.wssecurity.token.x509.certificate");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Succeeded to invoke the callback handler.");
            Tr.debug(tc, "Binary [" + this._binary + "], Properties [" + this._properties + "].");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return true;
    }

    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        if (this._properties == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WARNING: Can't return the X509 certificate because properties parameter is null.");
            }
        } else {
            this._properties.put(Constants.WSSECURITY_TOKEN_LOGININFO, this._cert);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return true;
    }

    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        this._binary = null;
        this._properties = null;
        this._messageContext = null;
        this._cert = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return true;
    }
}

