/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.auth.module;

import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.wssecurity.token.UserRegistryProcessor;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.Constants;
import com.ibm.wsspi.wssecurity.auth.callback.PropertyCallback;
import com.ibm.wsspi.wssecurity.auth.token.UsernameToken;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class IDAssertionUsernameLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(IDAssertionUsernameLoginModule.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private String comp = "security.wssecurity";
    private static final String clsName = IDAssertionUsernameLoginModule.class.getName();
    private Subject _subject;
    private CallbackHandler _handler;
    private Map _sharedState;
    private Map _options;
    private String _username;
    private char[] _password;
    private Map _properties = null;
    private SOAPMessageContext _messageContext = null;
    private boolean _isUsernameOnly = false;
    private boolean disableURCheck = false;
    private static final String _DISABLE_REGISTRY_CHECK = "com.ibm.wsspi.wssecurity.auth.module.IDAssertionUsernameLoginModule.disableUserRegistryCheck";

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        this._subject = subject;
        this._handler = callbackHandler;
        this._sharedState = map;
        this._options = map2;
        String string = (String)this._options.get(_DISABLE_REGISTRY_CHECK);
        if (string != null) {
            this.disableURCheck = "true".equalsIgnoreCase(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "disableURCheck=" + this.disableURCheck);
        }
    }

    public boolean login() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        boolean bl = true;
        NameCallback nameCallback = new NameCallback("username: ");
        PropertyCallback propertyCallback = new PropertyCallback(null);
        Callback[] callbackArray = new Callback[]{nameCallback, propertyCallback};
        String string = null;
        try {
            this._handler.handle(callbackArray);
        }
        catch (Exception exception) {
            throw new LoginException(ConfigUtil.getMessage(this.comp + ".BSTokenLoginModule.s01", new String[]{exception.toString()}));
        }
        this._username = nameCallback.getName();
        this._properties = propertyCallback.getProperties();
        if (this._properties != null) {
            this._messageContext = (SOAPMessageContext)this._properties.get("com.ibm.wsspi.wssecurity.core.messageContext");
            string = (String)this._properties.get("com.ibm.wsspi.wssecurity.auth.module.UsernameLoginModule.disableUserRegistryCheck");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "usernameCB [" + nameCallback + "]");
            Tr.debug(tc, "username [" + this._username + "]");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "disableURCheck=" + this.disableURCheck + " disableSingleURCheck=" + string);
        }
        if (this.disableURCheck || string != null && "true".equals(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Skipping registry check, returning true.");
            }
            bl = true;
        } else if (this._username != null && this._username.length() > 0) {
            boolean bl2 = UserRegistryProcessor.checkUsername(this._username);
            if (!bl2) {
                throw new LoginException(ConfigUtil.getMessage(this.comp + ".UserRegistryProcessor.s02", new String[]{this._username, "UserRegistryProcessor.checkUsername()=" + bl2}));
            }
        } else {
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return bl;
    }

    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        boolean bl = true;
        boolean bl2 = false;
        UsernameToken usernameToken = new UsernameToken(null, null, null);
        if (this._username != null && this._username.length() > 0) {
            final UsernameToken usernameToken2 = usernameToken;
            final String string = this._username;
            AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    usernameToken2.setUsername(string);
                    return null;
                }
            });
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Added Username [" + this._username + "].");
            }
            bl2 = true;
        } else {
            bl = false;
        }
        if (!bl2) {
            throw new LoginException(ConfigUtil.getMessage(this.comp + ".LoginProcessor.s11"));
        }
        if (this._properties == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WARNING: Can't return username and user password because properties parameter is null.");
            }
        } else {
            this._properties.put(Constants.WSSECURITY_TOKEN_LOGININFO, usernameToken);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return bl;
    }

    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return true;
    }
}

