/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.auth.module;

import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.wsspi.wssecurity.Constants;
import com.ibm.wsspi.wssecurity.auth.module.BSTokenLoginModule;
import com.ibm.wsspi.wssecurity.auth.module.PkiPathLoginModule;
import com.ibm.xml.soapsec.util.CertificateUtil;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.math.BigInteger;
import java.security.Provider;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.login.LoginException;
import javax.security.auth.x500.X500Principal;

public class PKCS7LoginModule
extends BSTokenLoginModule {
    private static final TraceComponent tc = Tr.register(PKCS7LoginModule.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = PkiPathLoginModule.class.getName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean login() throws LoginException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        if (bl = super.login()) {
            Object object;
            Object object2;
            Collection<Certificate> collection;
            Object object3;
            if (this._binary == null) {
                if (tc.isDebugEnabled()) {
                    Tr.error(tc, "PKCS7 binary is null.");
                }
                throw new LoginException(ConfigUtil.getMessage("security.wssecurity.PKCS7CallbackHandler.s01", new String[0]));
            }
            CertPath certPath = null;
            Provider provider = (Provider)this._properties.get("com.ibm.wsspi.wssecurity.token.x509.provider");
            try {
                certPath = CertificateUtil.generateCertPath(this._binary, "X.509", "PKCS7", provider);
                if (certPath == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.error(tc, "Result from CertificateUtil.generateCertPath was null.");
                    }
                    throw new LoginException(ConfigUtil.getMessage("security.wssecurity.PKCS7CallbackHandler.s01", new String[0]));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Succeeded to generate cert path [" + certPath + "]");
                }
                this._cert = PKCS7LoginModule.findSubject(certPath.getCertificates());
                if (this._cert == null) {
                    throw new CertificateException(ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.setCertToSubject01"));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Succeeded to get a X509 certificate [" + this._cert + "]");
                }
            }
            catch (Exception exception) {
                throw new LoginException(ConfigUtil.getMessage("security.wssecurity.PKCS7PathLoginModule.s01", new String[]{exception.toString()}));
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Checking the validity of X609 certificate...");
                }
                this._cert.checkValidity();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Succeeded to check the validity of X609 certificate.");
                }
            }
            catch (Exception exception) {
                throw new LoginException(ConfigUtil.getMessage("security.wssecurity.X509LoginModule.s02", new String[]{exception.toString()}));
            }
            boolean bl2 = false;
            String string = (String)this._properties.get("com.ibm.wsspi.wssecurity.token.x509.trustAny");
            if (string != null && string.length() > 0) {
                bl2 = ConfigUtil.isTrue(string);
                if (tc.isDebugEnabled() && bl2) {
                    Tr.debug(tc, "This login module trusts any certificate.");
                }
            }
            if (!bl2) {
                string = (String)this._properties.get(Constants.WSSECURITY_ISSUER_NAME);
                String string2 = (String)this._properties.get(Constants.WSSECURITY_ISSUER_SERIAL);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Issuer name of its own certificate is [" + string + "].");
                    Tr.debug(tc, "Serial number of its own certificate is [" + string2 + "].");
                }
                if (string != null && string2 != null) {
                    object3 = this._cert.getIssuerDN().getName();
                    if (((String)(object3 = KeyInfo.X509Data.encodeDName((String)object3))).equals(collection = KeyInfo.X509Data.encodeDName(string))) {
                        object2 = this._cert.getSerialNumber();
                        object = null;
                        try {
                            object = CertificateUtil.convertSerialNumber(string2);
                        }
                        catch (ParseException parseException) {
                            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.X509LoginModule.s04", new String[]{string2, parseException.toString()}));
                        }
                        if (((BigInteger)object2).equals(object)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "The cert is its own certificate, so this login module trusts it.");
                            }
                            bl2 = true;
                        }
                    }
                } else if (string != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "There is issuer name, but not serial number.");
                    }
                } else if (string2 != null && tc.isDebugEnabled()) {
                    Tr.debug(tc, "There is serial number, but not issur name.");
                }
            }
            if (!bl2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "This login module doesn't trust all certificate, so starts checking the cert path.");
                }
                if ((object3 = (PKIXBuilderParameters)this._properties.get("com.ibm.wsspi.wssecurity.token.x509.pkixBuilderParam")) == null) {
                    throw new LoginException(ConfigUtil.getMessage("security.wssecurity.X509LoginModule.s05"));
                }
                collection = object3;
                synchronized (collection) {
                    object3 = (PKIXBuilderParameters)((PKIXParameters)object3).clone();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Provider [" + provider + "], PKIBuilderParameters [" + object3 + "].");
                }
                try {
                    collection = certPath.getCertificates();
                    if (collection != null && !collection.isEmpty()) {
                        object2 = new CollectionCertStoreParameters(collection);
                        object = CertStore.getInstance("Collection", (CertStoreParameters)object2);
                        ((PKIXParameters)object3).addCertStore((CertStore)object);
                    }
                    collection = CertificateUtil.generateCRLs(this._binary, "X.509", provider);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Resetting revocation state based on the PKCS7 contents");
                    }
                    if (collection != null && !collection.isEmpty()) {
                        ((PKIXParameters)object3).setRevocationEnabled(true);
                        object2 = new CollectionCertStoreParameters(collection);
                        object = CertStore.getInstance("Collection", (CertStoreParameters)object2);
                        ((PKIXParameters)object3).addCertStore((CertStore)object);
                        if (tc.isDebugEnabled()) {
                            CertificateUtil.listCrlContents(collection);
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        if (((PKIXParameters)object3).isRevocationEnabled()) {
                            Tr.debug(tc, " Revocation Enabled for PKCS#7.");
                        } else {
                            Tr.debug(tc, " Revocation Not Enabled for PKCS#7.");
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Validating the cert path.");
                    }
                    CertificateUtil.validateCertPath(certPath, (PKIXParameters)object3);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Succeeded to validate the cert path.");
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Building validated cert path.");
                    }
                    CertificateUtil.buildCertPath(this._cert, certPath, (PKIXParameters)object3, provider, true);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Succeeded to build validated cert path.");
                    }
                }
                catch (Exception exception) {
                    Tr.processException((Throwable)exception, clsName + ".login", "251", this);
                    throw new LoginException(ConfigUtil.getMessage("security.wssecurity.PKCS7PathLoginModule.s02", new String[]{exception.toString()}));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return true;
    }

    public static X509Certificate findSubject(List list) throws CertPathValidatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findSubject(certs)");
        }
        HashSet<X500Principal> hashSet = new HashSet<X500Principal>();
        X509Certificate x509Certificate = null;
        if (list != null && !list.isEmpty()) {
            X509Certificate x509Certificate2;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                x509Certificate2 = (X509Certificate)iterator.next();
                hashSet.add(x509Certificate2.getIssuerX500Principal());
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Cert   DN: " + x509Certificate2.getSubjectX500Principal().getName());
                Tr.debug(tc, "Issuer DN: " + x509Certificate2.getIssuerX500Principal().getName());
            }
            iterator = list.iterator();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Subject(s) not found in issuer list:");
            }
            while (iterator.hasNext()) {
                x509Certificate2 = (X509Certificate)iterator.next();
                if (hashSet.contains(x509Certificate2.getSubjectX500Principal())) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "  " + x509Certificate2.getSubjectX500Principal().getName());
                }
                if (x509Certificate == null) {
                    x509Certificate = x509Certificate2;
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to determine subject of PKCS#7 token.  More than one subjectDN doesn't have a matching issuerDN.  Only one is allowed.");
                }
                x509Certificate = null;
                throw new CertPathValidatorException("Certificate Chaining Error");
            }
            if (x509Certificate == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "  None");
                    Tr.debug(tc, "Unable to determine subject of PKCS#7 token.  All subjectDNs and issuerDNs are accounted for.");
                }
                throw new CertPathValidatorException("Certificate Chaining Error");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findSubject returns " + x509Certificate.getSubjectDN());
        }
        return x509Certificate;
    }
}

