/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.auth.module;

import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.wsspi.wssecurity.Constants;
import com.ibm.wsspi.wssecurity.auth.module.BSTokenLoginModule;
import com.ibm.xml.soapsec.util.CertificateUtil;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.math.BigInteger;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import javax.security.auth.login.LoginException;

public class PkiPathLoginModule
extends BSTokenLoginModule {
    private static final TraceComponent tc = Tr.register(PkiPathLoginModule.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = PkiPathLoginModule.class.getName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean login() throws LoginException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        if (bl = super.login()) {
            Object object;
            Object object2;
            CertPath certPath = null;
            Provider provider = (Provider)this._properties.get("com.ibm.wsspi.wssecurity.token.x509.provider");
            try {
                if (this._binary == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.error(tc, "PkiPath binary is null.");
                    }
                    throw new LoginException(ConfigUtil.getMessage("security.wssecurity.PkiPathCallbackHandler.s01", new String[0]));
                }
                certPath = CertificateUtil.generateCertPath(this._binary, "X.509", "PkiPath", provider);
                if (certPath == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.error(tc, "Result from CertificateUtil.generateCertPath was null.");
                    }
                    throw new LoginException(ConfigUtil.getMessage("security.wssecurity.PkiPathCallbackHandler.s01", new String[0]));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Succeeded to generate cert path.");
                }
                this._cert = (X509Certificate)certPath.getCertificates().get(0);
                if (this._cert == null) {
                    throw new CertificateException(ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.setCertToSubject01"));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Succeeded to get a X509 certificate [" + this._cert + "]");
                }
            }
            catch (CertificateException certificateException) {
                throw new LoginException(ConfigUtil.getMessage("security.wssecurity.PkiPathLoginModule.s01", new String[]{certificateException.toString()}));
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new LoginException(ConfigUtil.getMessage("security.wssecurity.PkiPathLoginModule.s01", new String[]{noSuchProviderException.toString()}));
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Checking the validity of X509 certificate...");
                }
                this._cert.checkValidity();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Succeeded to check the validity of X509 certificate.");
                }
            }
            catch (Exception exception) {
                throw new LoginException(ConfigUtil.getMessage("security.wssecurity.X509LoginModule.s02", new String[]{exception.toString()}));
            }
            boolean bl2 = false;
            String string = (String)this._properties.get("com.ibm.wsspi.wssecurity.token.x509.trustAny");
            if (string != null && string.length() > 0) {
                bl2 = ConfigUtil.isTrue(string);
                if (tc.isDebugEnabled() && bl2) {
                    Tr.debug(tc, "This login module trusts any certificate.");
                }
            }
            if (!bl2) {
                string = (String)this._properties.get(Constants.WSSECURITY_ISSUER_NAME);
                String string2 = (String)this._properties.get(Constants.WSSECURITY_ISSUER_SERIAL);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Issuer name of its own certificate is [" + string + "].");
                    Tr.debug(tc, "Serial number of its own certificate is [" + string2 + "].");
                }
                if (string != null && string2 != null) {
                    object2 = this._cert.getIssuerDN().getName();
                    if (((String)(object2 = KeyInfo.X509Data.encodeDName((String)object2))).equals(object = KeyInfo.X509Data.encodeDName(string))) {
                        BigInteger bigInteger = this._cert.getSerialNumber();
                        BigInteger bigInteger2 = null;
                        try {
                            bigInteger2 = CertificateUtil.convertSerialNumber(string2);
                        }
                        catch (ParseException parseException) {
                            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.X509LoginModule.s04", new String[]{string2, parseException.toString()}));
                        }
                        if (bigInteger.equals(bigInteger2)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "The cert is its own certificate, so this login module trusts it.");
                            }
                            bl2 = true;
                        }
                    }
                } else if (string != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "There is issuer name, but not serial number.");
                    }
                } else if (string2 != null && tc.isDebugEnabled()) {
                    Tr.debug(tc, "There is serial number, but not issur name.");
                }
            }
            if (!bl2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "This login module doesn't trust all certificate, so starts checking the cert path.");
                }
                if ((object2 = (PKIXBuilderParameters)this._properties.get("com.ibm.wsspi.wssecurity.token.x509.pkixBuilderParam")) == null) {
                    throw new LoginException(ConfigUtil.getMessage("security.wssecurity.X509LoginModule.s05"));
                }
                object = object2;
                synchronized (object) {
                    object2 = (PKIXBuilderParameters)((PKIXParameters)object2).clone();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Provider [" + provider + "], PKIBuilderParameters [" + object2 + "].");
                }
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Checking the cert path...");
                    }
                    CertificateUtil.validateCertPath(certPath, (PKIXParameters)object2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Succeeded to validate the cert path.");
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Building validated cert path.");
                    }
                    CertificateUtil.buildCertPath(this._cert, certPath, (PKIXParameters)object2, provider, false);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Succeeded to build validated cert path.");
                    }
                }
                catch (Exception exception) {
                    Tr.processException((Throwable)exception, clsName + ".login", "204", this);
                    throw new LoginException(ConfigUtil.getMessage("security.wssecurity.PkiPathLoginModule.s02", new String[]{exception.toString()}));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return true;
    }
}

