/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.auth.module;

import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.wssecurity.token.UserRegistryProcessor;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.Constants;
import com.ibm.wsspi.wssecurity.auth.callback.PropertyCallback;
import com.ibm.wsspi.wssecurity.auth.token.UsernameToken;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class UsernameLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(UsernameLoginModule.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private String comp = "security.wssecurity";
    private static final String clsName = UsernameLoginModule.class.getName();
    private Subject _subject;
    private CallbackHandler _handler;
    private Map _sharedState;
    private Map _options;
    private String _username;
    private char[] _password;
    private Map _properties = null;
    private SOAPMessageContext _messageContext = null;
    private boolean disableURCheck = false;
    private static final String _DISABLE_REGISTRY_CHECK = "com.ibm.wsspi.wssecurity.auth.module.UsernameLoginModule.disableUserRegistryCheck";

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(Subject subject,CallbackHandler handler,Map sharedState,Map options)");
        }
        this._subject = subject;
        this._handler = callbackHandler;
        this._sharedState = map;
        this._options = map2;
        if (this._handler != null && tc.isDebugEnabled()) {
            Tr.debug(tc, "CallbackHandler: " + this._handler.getClass().getName());
        }
        this.disableURCheck = "true".equalsIgnoreCase((String)this._options.get(_DISABLE_REGISTRY_CHECK));
        if (tc.isDebugEnabled() && this.disableURCheck) {
            Tr.debug(tc, "com.ibm.wsspi.wssecurity.auth.module.UsernameLoginModule.disableUserRegistryCheck=true.  UsernameLoginModule user registry checking will be disabled");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(Subject subject,CallbackHandler handler,Map sharedState,Map options)");
        }
    }

    public boolean login() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        boolean bl = true;
        NameCallback nameCallback = new NameCallback("username: ");
        PasswordCallback passwordCallback = new PasswordCallback("password: ", false);
        PropertyCallback propertyCallback = new PropertyCallback(null);
        Callback[] callbackArray = new Callback[]{nameCallback, passwordCallback, propertyCallback};
        String string = null;
        try {
            this._handler.handle(callbackArray);
        }
        catch (Exception exception) {
            throw new LoginException(ConfigUtil.getMessage(this.comp + ".BSTokenLoginModule.s01", new String[]{exception.toString()}));
        }
        this._username = nameCallback.getName();
        this._password = passwordCallback.getPassword();
        this._properties = propertyCallback.getProperties();
        if (this._properties != null) {
            this._messageContext = (SOAPMessageContext)this._properties.get("com.ibm.wsspi.wssecurity.core.messageContext");
            string = (String)this._properties.get(_DISABLE_REGISTRY_CHECK);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "usernameCB [" + nameCallback + "], passwordCB [" + passwordCallback);
            String string2 = this._password == null ? "null" : "not null";
            Tr.debug(tc, "username [" + this._username + "], password [" + string2 + "]");
        }
        if (this.disableURCheck || string != null && "true".equals(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Skipping registry check, returning true.");
            }
            bl = true;
        } else if (this._username != null && this._username.length() > 0) {
            boolean bl2 = UserRegistryProcessor.checkRegistry(this._username, this._password);
            if (!bl2) {
                throw new LoginException(ConfigUtil.getMessage(this.comp + ".UserRegistryProcessor.s01", new String[]{this._username, "UserRegistryProcessor.checkRegistry()=" + bl2}));
            }
        } else {
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return bl;
    }

    public boolean commit() throws LoginException {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        boolean bl = true;
        boolean bl2 = false;
        UsernameToken usernameToken = new UsernameToken(null, null, null);
        if (this._username != null && this._username.length() > 0) {
            object2 = usernameToken;
            object = this._username;
            AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction((UsernameToken)object2, (String)object){
                private final /* synthetic */ UsernameToken val$tokenPriv;
                private final /* synthetic */ String val$usernamePriv;
                {
                    this.val$tokenPriv = usernameToken;
                    this.val$usernamePriv = string;
                }

                public Object run() {
                    this.val$tokenPriv.setUsername(this.val$usernamePriv);
                    return null;
                }
            });
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Added Username [" + this._username + "].");
            }
            bl2 = true;
        } else {
            bl = false;
        }
        if (this._password != null && this._password.length > 0) {
            object2 = this._password;
            object = usernameToken;
            AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction((UsernameToken)object, (char[])object2){
                private final /* synthetic */ UsernameToken val$tokenPriv;
                private final /* synthetic */ char[] val$passwordPriv;
                {
                    this.val$tokenPriv = usernameToken;
                    this.val$passwordPriv = cArray;
                }

                public Object run() {
                    this.val$tokenPriv.setPassword(this.val$passwordPriv);
                    return null;
                }
            });
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Added Password [not null].");
            }
        }
        if (!bl2) {
            throw new LoginException(ConfigUtil.getMessage(this.comp + ".LoginProcessor.s11"));
        }
        if (this._properties == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WARNING: Can't return username and user password because properties parameter is null.");
            }
        } else {
            this._properties.put(Constants.WSSECURITY_TOKEN_LOGININFO, usernameToken);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return bl;
    }

    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return true;
    }
}

