/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.auth.token;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.wsspi.wssecurity.auth.token.WSSToken;
import java.util.Date;
import org.w3c.dom.Element;

public class UsernameToken
extends WSSToken {
    private String uid = null;
    private String _username = null;
    private char[] _password = null;
    private Date _date = null;
    private volatile int hashCode = 0;
    private static final String setUsernamePermission = "wssecurity.UsernameToken.setUsername";
    private static final String getPasswordPermission = "wssecurity.UsernameToken.getPassword";
    private static final String setPasswordPermission = "wssecurity.UsernameToken.setPassword";
    private static final String setExpirationPermission = "wssecurity.UsernameToken.setExpiration";
    private static final TraceComponent tc = Tr.register(UsernameToken.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final WebSphereRuntimePermission SETUSERNAME_PERM = new WebSphereRuntimePermission("wssecurity.UsernameToken.setUsername");
    private static final WebSphereRuntimePermission GETPASSWORD_PERM = new WebSphereRuntimePermission("wssecurity.UsernameToken.getPassword");
    private static final WebSphereRuntimePermission SETPASSWORD_PERM = new WebSphereRuntimePermission("wssecurity.UsernameToken.setPassword");
    private static final WebSphereRuntimePermission SETEXPIRATION_PERM = new WebSphereRuntimePermission("wssecurity.UsernameToken.setExpiration");
    private long _expiration;

    public UsernameToken(String string, String string2, char[] cArray) {
        this(string, string2, cArray, null);
    }

    public UsernameToken(String string, String string2, char[] cArray, Element element) {
        this._tokenId = string == null ? "" : string;
        this._username = string2;
        this._password = cArray;
        this._tokenelem = element;
        this._vtype = Constants.UNTOKEN;
    }

    public void setDate(Date date) {
        if (this.isReadOnly()) {
            return;
        }
        this._date = date;
    }

    public Date getDate() {
        if (this.isReadOnly()) {
            Date date = (Date)this._date.clone();
            return date;
        }
        return this._date;
    }

    public void setUsername(String string) {
        Tr.entry(tc, "setUsername");
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETUSERNAME_PERM.toString());
            }
            securityManager.checkPermission(SETUSERNAME_PERM);
        }
        Tr.exit(tc, "setUsername", string);
        if (this.isReadOnly()) {
            return;
        }
        this._username = string;
    }

    public String getUsername() {
        if (this.isReadOnly()) {
            String string = new String(this._username);
            return string;
        }
        return this._username;
    }

    public void setPassword(char[] cArray) {
        Tr.entry(tc, "setPassword");
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETPASSWORD_PERM.toString());
            }
            securityManager.checkPermission(SETPASSWORD_PERM);
        }
        Tr.exit(tc, "setPassword");
        if (this.isReadOnly()) {
            return;
        }
        this._password = cArray;
    }

    public char[] getPassword() {
        Tr.entry(tc, "getPassword");
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GETPASSWORD_PERM.toString());
            }
            securityManager.checkPermission(GETPASSWORD_PERM);
        }
        Tr.exit(tc, "getPassword");
        if (this.isReadOnly()) {
            char[] cArray = new char[this._password.length];
            System.arraycopy(this._password, 0, cArray, 0, this._password.length);
            return cArray;
        }
        return this._password;
    }

    public long getExpiration() {
        if (this.isReadOnly()) {
            long l = this._expiration;
            return l;
        }
        return this._expiration;
    }

    public void setExpiration(long l) {
        Tr.entry(tc, "setExpiration");
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETEXPIRATION_PERM.toString());
            }
            securityManager.checkPermission(SETEXPIRATION_PERM);
        }
        Tr.exit(tc, "setExpiration");
        if (this.isReadOnly()) {
            return;
        }
        this._expiration = l;
    }

    public String getPrincipal() {
        if (this.isReadOnly()) {
            String string = new String(this._username);
            return string;
        }
        return this._username;
    }

    public String getUniqueID() {
        if (this.uid == null) {
            this.uid = String.valueOf(this.hashCode());
        }
        if (this.isReadOnly()) {
            String string = new String(this.uid);
            return string;
        }
        return this.uid;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int n = 0;
            if (this._username != null) {
                n += new String(this._username).hashCode();
            }
            if (this._password != null) {
                n += new String(this._password).hashCode();
            }
            this.hashCode = n;
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof UsernameToken)) {
            return false;
        }
        UsernameToken usernameToken = (UsernameToken)object;
        return usernameToken.hashCode() == this.hashCode();
    }

    public boolean isValid() {
        return this._username != null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UsernameToken[tokenId=[").append(this._tokenId);
        stringBuffer.append("], element=[").append(DOMUtil.getDisplayName(this._tokenelem));
        stringBuffer.append("], username=[").append(this._username);
        stringBuffer.append("], password=[xxx]");
        return stringBuffer.toString();
    }
}

