/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.auth.token;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.token.Token;
import com.ibm.wsspi.wssecurity.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.config.TokenGeneratorConfig;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public abstract class WSSToken
implements Token {
    protected static final short _version = 1;
    protected HashMap _attributes = new HashMap();
    private static final String setTrustedpermission = "wssecurity.WSSToken.setTrusted";
    private static final String addAttributePermission = "wssecurity.WSSToken.addAttribute";
    private static final String setUsedTokenConsumerPermission = "wssecurity.WSSToken.setUsedTokenConsumer";
    protected String _tokenId = null;
    protected Element _tokenelem = null;
    protected QName _vtype = null;
    protected String _keyInfoType = null;
    protected boolean _trusted = false;
    protected boolean _usedToLogin = false;
    protected boolean _callerChecked = false;
    protected boolean _referenced = false;
    private boolean _isReadOnly = false;
    protected TokenGeneratorConfig _usedTokenGenerator = null;
    protected TokenConsumerConfig _usedTokenConsumer = null;
    protected boolean _processed = false;
    protected SoapSecurityException _error = null;
    private static final TraceComponent tc = Tr.register(WSSToken.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final WebSphereRuntimePermission SETTRUSTED_PERM = new WebSphereRuntimePermission("wssecurity.WSSToken.setTrusted");
    private static final WebSphereRuntimePermission ADDATRIBUTE_PERM = new WebSphereRuntimePermission("wssecurity.WSSToken.addAttribute");
    private static final WebSphereRuntimePermission SETUSEDTOKENCONSUMER_PERM = new WebSphereRuntimePermission("wssecurity.WSSToken.setUsedTokenConsumer");

    public String getId() {
        if (this.isReadOnly()) {
            String string = new String(this._tokenId);
            return string;
        }
        return this._tokenId;
    }

    public void setId(String string) {
        if (this.isReadOnly()) {
            return;
        }
        this._tokenId = string;
    }

    public Element getElement() {
        if (this.isReadOnly()) {
            Element element = (Element)this._tokenelem.cloneNode(true);
            return element;
        }
        return this._tokenelem;
    }

    public void setElement(Element element) {
        if (this.isReadOnly()) {
            return;
        }
        this._tokenelem = element;
    }

    public QName getType() {
        if (this.isReadOnly()) {
            QName qName = new QName(this._vtype.getNamespaceURI(), this._vtype.getLocalPart());
            return qName;
        }
        return this._vtype;
    }

    public void setType(QName qName) {
        if (this.isReadOnly()) {
            return;
        }
        this._vtype = qName;
    }

    public void setType(String string, String string2) {
        if (this.isReadOnly()) {
            return;
        }
        this._vtype = new QName(string, string2);
    }

    public String getKeyInfoType() {
        if (this.isReadOnly()) {
            String string = new String(this._keyInfoType);
            return string;
        }
        return this._keyInfoType;
    }

    public void setKeyInfoType(String string) {
        if (this.isReadOnly()) {
            return;
        }
        this._keyInfoType = string;
    }

    public byte[] getBytes() {
        return null;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public short getVersion() {
        return 1;
    }

    public boolean isForwardable() {
        return false;
    }

    public Object clone() {
        return this.clone();
    }

    public void setTrusted(boolean bl) {
        Tr.entry(tc, "setTrusted");
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETTRUSTED_PERM.toString());
            }
            securityManager.checkPermission(SETTRUSTED_PERM);
        }
        Tr.exit(tc, "setTrusted");
        if (this.isReadOnly()) {
            return;
        }
        this._trusted = bl;
    }

    public boolean isTrusted() {
        return this._trusted;
    }

    public void setUsedToLogin(boolean bl) {
        this._usedToLogin = bl;
    }

    public boolean getUsedToLogin() {
        return this._usedToLogin;
    }

    public Enumeration getAttributeNames() {
        Iterator iterator = this._attributes.keySet().iterator();
        return iterator == null ? null : new AttributesEnumerator(iterator);
    }

    public String[] getAttributes(String string) {
        ArrayList arrayList = (ArrayList)this._attributes.get(string);
        return arrayList == null ? null : arrayList.toArray(new String[0]);
    }

    public String[] addAttribute(String string, String string2) {
        Tr.entry(tc, "addAttribute");
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + ADDATRIBUTE_PERM.toString());
            }
            securityManager.checkPermission(ADDATRIBUTE_PERM);
        }
        if (this.isReadOnly()) {
            return null;
        }
        ArrayList<String> arrayList = (ArrayList<String>)this._attributes.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
        }
        arrayList.add(string2);
        Tr.exit(tc, "addAttribute");
        return arrayList.toArray(new String[0]);
    }

    public void setCallerChecked(boolean bl) {
        if (this.isReadOnly()) {
            return;
        }
        this._callerChecked = bl;
    }

    public boolean getCallerChecked() {
        return this._callerChecked;
    }

    public boolean isReferenced() {
        return this._referenced;
    }

    public void setReferenced(boolean bl) {
        this._referenced = bl;
    }

    public TokenGeneratorConfig getUsedTokenGenerator() {
        return this._usedTokenGenerator;
    }

    public void setUsedTokenGenerator(TokenGeneratorConfig tokenGeneratorConfig) {
        if (this.isReadOnly()) {
            return;
        }
        this._usedTokenGenerator = tokenGeneratorConfig;
    }

    public TokenConsumerConfig getUsedTokenConsumer() {
        return this._usedTokenConsumer;
    }

    public void setUsedTokenConsumer(TokenConsumerConfig tokenConsumerConfig) {
        Tr.entry(tc, "setUsedTokenConsumer");
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETUSEDTOKENCONSUMER_PERM.toString());
            }
            securityManager.checkPermission(SETUSEDTOKENCONSUMER_PERM);
        }
        Tr.exit(tc, "setUsedTokenConsumer");
        if (this.isReadOnly()) {
            return;
        }
        this._usedTokenConsumer = tokenConsumerConfig;
    }

    public boolean isProcessed() {
        return this._processed;
    }

    public void setProcessed(boolean bl) {
        if (this.isReadOnly()) {
            return;
        }
        this._processed = bl;
    }

    public SoapSecurityException getError() {
        return this._error;
    }

    public void setError(SoapSecurityException soapSecurityException) {
        this._error = soapSecurityException;
    }

    public boolean isReadOnly() {
        return this._isReadOnly;
    }

    public void setReadOnly() {
        this._isReadOnly = true;
    }

    protected class AttributesEnumerator
    implements Enumeration {
        protected Iterator _it;

        public AttributesEnumerator(Iterator iterator) {
            this._it = iterator;
        }

        public boolean hasMoreElements() {
            return this._it.hasNext();
        }

        public Object nextElement() throws NoSuchElementException {
            return this._it.next();
        }
    }
}

